/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmBsnLagId;
import org.projectfloodlight.openflow.protocol.oxm.OFOxms;
import org.projectfloodlight.openflow.protocol.ver13.OFOxmBsnLagIdVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFOxmsVer13;
import org.projectfloodlight.openflow.types.LagId;

public class OFOxmBsnLagIdVer13Test {
    OFOxms factory;
    static final byte[] OXM_BSN_LAG_ID_SERIALIZED = new byte[]{0, 3, 2, 4, 18, 52, 86, 120};

    @Before
    public void setup() {
        this.factory = OFOxmsVer13.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFOxmBsnLagId.Builder builder = this.factory.buildBsnLagId();
        builder.setValue(LagId.of((int)305419896));
        OFOxmBsnLagId oxmBsnLagId = builder.build();
        ChannelBuffer bb = ChannelBuffers.dynamicBuffer();
        oxmBsnLagId.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)OXM_BSN_LAG_ID_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFOxmBsnLagId.Builder builder = this.factory.buildBsnLagId();
        builder.setValue(LagId.of((int)305419896));
        OFOxmBsnLagId oxmBsnLagIdBuilt = builder.build();
        ChannelBuffer input = ChannelBuffers.copiedBuffer((byte[])OXM_BSN_LAG_ID_SERIALIZED);
        OFOxmBsnLagId oxmBsnLagIdRead = OFOxmBsnLagIdVer13.READER.readFrom(input);
        Assert.assertEquals((long)OXM_BSN_LAG_ID_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)oxmBsnLagIdBuilt, (Object)oxmBsnLagIdRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ChannelBuffer input = ChannelBuffers.copiedBuffer((byte[])OXM_BSN_LAG_ID_SERIALIZED);
        OFOxmBsnLagId oxmBsnLagId = OFOxmBsnLagIdVer13.READER.readFrom(input);
        Assert.assertEquals((long)OXM_BSN_LAG_ID_SERIALIZED.length, (long)input.readerIndex());
        ChannelBuffer bb = ChannelBuffers.dynamicBuffer();
        oxmBsnLagId.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)OXM_BSN_LAG_ID_SERIALIZED));
    }
}

