/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.types;

import com.google.common.io.BaseEncoding;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.Assert;
import org.junit.Test;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.types.IPAddress;
import org.projectfloodlight.openflow.types.IPAddressWithMask;
import org.projectfloodlight.openflow.types.IPVersion;
import org.projectfloodlight.openflow.types.IPv6Address;
import org.projectfloodlight.openflow.types.IPv6AddressWithMask;

public class IPv6AddressTest {
    String[] testStrings = new String[]{"::", "::1", "ffe0::", "1:2:3:4:5:6:7:8", "8091:a2b3:c4d5:e6f7:8495:a6b7:c1d2:e3d4"};
    private final BaseEncoding hex = BaseEncoding.base16().omitPadding().lowerCase();
    WithMaskTaskCase[] withMasks = new WithMaskTaskCase[]{new WithMaskTaskCase("1::1/80").maskHex("ff ff ff ff ff ff ff ff ff ff 00 00 00 00 00 00").expectedMaskLength(80), new WithMaskTaskCase("ffff:ffee:1::/ff00:ff00:ff00:ff00::").maskHex("ff 00 ff 00 ff 00 ff 00 00 00 00 00 00 00 00 00").expectedMaskLength(-1), new WithMaskTaskCase("1:2:3:4:5:6:7:8/1::ff00:ff00").maskHex("00 01 00 00 00 00 00 00 00 00 00 00 ff 00 ff 00").expectedMaskLength(-1), new WithMaskTaskCase("1:2:3:4:5:6:7:8/::ff00:ff00").maskHex("00 00 00 00 00 00 00 00 00 00 00 00 ff 00 ff 00").expectedMaskLength(-1), new WithMaskTaskCase("1:2:3:4:5:6:7:8/ffff:ffff:ffff:ffff:ffff::ff00:ff00").maskHex("ff ff ff ff ff ff ff ff ff ff 00 00 ff 00 ff 00").expectedMaskLength(-1), new WithMaskTaskCase("8:8:8:8:8:8:8:8"), new WithMaskTaskCase("8:8:8:8:8:8:8:8"), new WithMaskTaskCase("1:2:3:4:5:6:7:8/128"), new WithMaskTaskCase("::/0").maskHex("00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00").expectedMaskLength(0)};
    String[] invalidIPs = new String[]{"", ":", "1:2:3:4:5:6:7:8:9", "1:2:3:4:5:6:7:8:", "1:2:3:4:5:6:7:8g", "1:2:3:", "12345::", "1::3::8", "::3::"};

    @Test
    public void testLogicalOperatorsBroadcast() {
        Assert.assertTrue((boolean)IPv6Address.NO_MASK.not().equals((Object)IPv6Address.FULL_MASK));
        Assert.assertTrue((boolean)IPv6Address.NO_MASK.or(IPv6Address.FULL_MASK).equals((Object)IPv6Address.NO_MASK));
        Assert.assertTrue((boolean)IPv6Address.NO_MASK.and(IPv6Address.FULL_MASK).equals((Object)IPv6Address.FULL_MASK));
        Assert.assertTrue((boolean)IPv6Address.NO_MASK.isBroadcast());
        Assert.assertTrue((!IPv6Address.FULL_MASK.isBroadcast() ? 1 : 0) != 0);
    }

    @Test
    public void testMaskedSubnetBroadcast() {
        Assert.assertTrue((boolean)((IPv6Address)IPv6AddressWithMask.of((String)"10:10::1/112").getSubnetBroadcastAddress()).equals((Object)IPv6Address.of((String)"10:10::ffff")));
        Assert.assertTrue((boolean)IPv6AddressWithMask.of((String)"10:10::1/112").isSubnetBroadcastAddress((IPAddress)IPv6Address.of((String)"10:10::ffff")));
        Assert.assertTrue((!IPv6AddressWithMask.of((String)"10:10::1/112").isSubnetBroadcastAddress((IPAddress)IPv6Address.of((String)"10:10::fffd")) ? 1 : 0) != 0);
    }

    @Test
    public void testConstants() {
        byte[] zeros = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        byte[] ones = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        Assert.assertTrue((boolean)IPv6Address.NONE.isCidrMask());
        Assert.assertEquals((long)0L, (long)IPv6Address.NONE.asCidrMaskLength());
        Assert.assertArrayEquals((byte[])zeros, (byte[])IPv6Address.NONE.getBytes());
        Assert.assertTrue((boolean)IPv6Address.NONE.isCidrMask());
        Assert.assertEquals((long)0L, (long)IPv6Address.NONE.asCidrMaskLength());
        Assert.assertArrayEquals((byte[])zeros, (byte[])IPv6Address.NONE.getBytes());
        Assert.assertTrue((boolean)IPv6Address.NO_MASK.isCidrMask());
        Assert.assertEquals((long)128L, (long)IPv6Address.NO_MASK.asCidrMaskLength());
        Assert.assertArrayEquals((byte[])ones, (byte[])IPv6Address.NO_MASK.getBytes());
        Assert.assertTrue((boolean)IPv6Address.NO_MASK.isCidrMask());
        Assert.assertEquals((long)128L, (long)IPv6Address.NO_MASK.asCidrMaskLength());
        Assert.assertArrayEquals((byte[])ones, (byte[])IPv6Address.NO_MASK.getBytes());
        Assert.assertTrue((boolean)IPv6Address.FULL_MASK.isCidrMask());
        Assert.assertEquals((long)0L, (long)IPv6Address.FULL_MASK.asCidrMaskLength());
        Assert.assertArrayEquals((byte[])zeros, (byte[])IPv6Address.FULL_MASK.getBytes());
        Assert.assertTrue((boolean)IPv6Address.FULL_MASK.isCidrMask());
        Assert.assertEquals((long)0L, (long)IPv6Address.FULL_MASK.asCidrMaskLength());
        Assert.assertArrayEquals((byte[])zeros, (byte[])IPv6Address.FULL_MASK.getBytes());
    }

    @Test
    public void testMasked() throws UnknownHostException {
        for (WithMaskTaskCase w : this.withMasks) {
            IPv6AddressWithMask value = IPv6AddressWithMask.of((String)w.input);
            if (!w.hasMask) {
                IPv6Address ip = (IPv6Address)value.getValue();
                InetAddress inetAddress2 = InetAddress.getByName(w.input.split("/")[0]);
                Assert.assertArrayEquals((byte[])ip.getBytes(), (byte[])inetAddress2.getAddress());
                Assert.assertEquals((Object)w.input.split("/")[0], (Object)ip.toString());
            }
            InetAddress inetAddress = InetAddress.getByName(w.input.split("/")[0]);
            if (w.expectedMaskLength == -1) {
                Assert.assertFalse((boolean)((IPv6Address)value.getMask()).isCidrMask());
                try {
                    ((IPv6Address)value.getMask()).asCidrMaskLength();
                    Assert.fail((String)"Expected IllegalStateException not thrown");
                }
                catch (IllegalStateException inetAddress2) {}
            } else {
                Assert.assertTrue((boolean)((IPv6Address)value.getMask()).isCidrMask());
                Assert.assertEquals((String)("Input " + w.input), (long)w.expectedMaskLength, (long)((IPv6Address)value.getMask()).asCidrMaskLength());
            }
            byte[] address = inetAddress.getAddress();
            Assert.assertEquals((long)address.length, (long)((IPv6Address)value.getValue()).getBytes().length);
            for (int j = 0; j < address.length; ++j) {
                int n = j;
                address[n] = (byte)(address[n] & w.expectedMask[j]);
            }
            Assert.assertThat((String)("Address bytes for input " + w.input + ", value=" + value), (Object)((IPv6Address)value.getValue()).getBytes(), (Matcher)CoreMatchers.equalTo((Object)address));
            Assert.assertThat((String)("mask check for input " + w.input + ", value=" + value), (Object)((IPv6Address)value.getMask()).getBytes(), (Matcher)CoreMatchers.equalTo((Object)w.expectedMask));
        }
        for (int i = 0; i <= 128; ++i) {
            String ipString = String.format("8001:2::1/%d", i);
            IPv6AddressWithMask value = IPv6AddressWithMask.of((String)ipString);
            Assert.assertEquals((String)("Input " + ipString), (long)i, (long)((IPv6Address)value.getMask()).asCidrMaskLength());
        }
    }

    @Test
    public void testOfString() throws UnknownHostException {
        for (int i = 0; i < this.testStrings.length; ++i) {
            IPv6Address ip = IPv6Address.of((String)this.testStrings[i]);
            InetAddress inetAddress = InetAddress.getByName(this.testStrings[i]);
            Assert.assertArrayEquals((byte[])ip.getBytes(), (byte[])inetAddress.getAddress());
            Assert.assertEquals((Object)this.testStrings[i], (Object)ip.toString());
        }
    }

    @Test
    public void testOfByteArray() throws UnknownHostException {
        for (int i = 0; i < this.testStrings.length; ++i) {
            byte[] bytes = Inet6Address.getByName(this.testStrings[i]).getAddress();
            IPv6Address ip = IPv6Address.of((byte[])bytes);
            Assert.assertEquals((Object)this.testStrings[i], (Object)ip.toString());
            Assert.assertArrayEquals((byte[])bytes, (byte[])ip.getBytes());
        }
    }

    private static void testOfCidrMaskLengthHelper(int cidrMaskLength, String ipStr) throws UnknownHostException {
        byte[] ba0 = IPv6Address.ofCidrMaskLength((int)cidrMaskLength).getBytes();
        byte[] ba1 = Inet6Address.getByName(ipStr).getAddress();
        Assert.assertArrayEquals((byte[])ba0, (byte[])ba1);
    }

    @Test
    public void testOfCidrMaskLength() throws UnknownHostException {
        for (int i = 0; i <= 128; ++i) {
            Assert.assertTrue((boolean)IPv6Address.ofCidrMaskLength((int)i).isCidrMask());
            Assert.assertEquals((long)IPv6Address.ofCidrMaskLength((int)i).asCidrMaskLength(), (long)i);
        }
        IPv6AddressTest.testOfCidrMaskLengthHelper(0, "::");
        IPv6AddressTest.testOfCidrMaskLengthHelper(1, "8000::");
        IPv6AddressTest.testOfCidrMaskLengthHelper(2, "c000::");
        IPv6AddressTest.testOfCidrMaskLengthHelper(8, "ff00::");
        IPv6AddressTest.testOfCidrMaskLengthHelper(16, "ffff::");
        IPv6AddressTest.testOfCidrMaskLengthHelper(17, "ffff:8000::");
        IPv6AddressTest.testOfCidrMaskLengthHelper(31, "ffff:fffe::");
        IPv6AddressTest.testOfCidrMaskLengthHelper(32, "ffff:ffff::");
        IPv6AddressTest.testOfCidrMaskLengthHelper(33, "ffff:ffff:8000::");
        IPv6AddressTest.testOfCidrMaskLengthHelper(46, "ffff:ffff:fffc::");
        IPv6AddressTest.testOfCidrMaskLengthHelper(48, "ffff:ffff:ffff::");
        IPv6AddressTest.testOfCidrMaskLengthHelper(55, "ffff:ffff:ffff:fe00::");
        IPv6AddressTest.testOfCidrMaskLengthHelper(56, "ffff:ffff:ffff:ff00::");
        IPv6AddressTest.testOfCidrMaskLengthHelper(59, "ffff:ffff:ffff:ffe0::");
        IPv6AddressTest.testOfCidrMaskLengthHelper(63, "ffff:ffff:ffff:fffe::");
        IPv6AddressTest.testOfCidrMaskLengthHelper(64, "ffff:ffff:ffff:ffff::");
        IPv6AddressTest.testOfCidrMaskLengthHelper(65, "ffff:ffff:ffff:ffff:8000::");
        IPv6AddressTest.testOfCidrMaskLengthHelper(67, "ffff:ffff:ffff:ffff:e000::");
        IPv6AddressTest.testOfCidrMaskLengthHelper(100, "ffff:ffff:ffff:ffff:ffff:ffff:f000::");
        IPv6AddressTest.testOfCidrMaskLengthHelper(101, "ffff:ffff:ffff:ffff:ffff:ffff:f800::");
        IPv6AddressTest.testOfCidrMaskLengthHelper(126, "ffff:ffff:ffff:ffff:ffff:ffff:ffff:fffc");
        IPv6AddressTest.testOfCidrMaskLengthHelper(127, "ffff:ffff:ffff:ffff:ffff:ffff:ffff:fffe");
        IPv6AddressTest.testOfCidrMaskLengthHelper(128, "ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff");
    }

    @Test
    public void testWithMask() throws Exception {
        IPv6Address original = IPv6Address.of((String)"fd12:3456:ABCD:7890::1");
        IPv6Address expectedValue = IPv6Address.of((String)"fd12:3456:ABCD::");
        IPv6Address expectedMask = IPv6Address.of((String)"ffff:ffff:ffff::");
        IPv6AddressWithMask v = original.withMask(IPv6Address.of((byte[])new byte[]{-1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}));
        Assert.assertEquals((Object)v.getValue(), (Object)expectedValue);
        Assert.assertEquals((Object)v.getMask(), (Object)expectedMask);
        v = original.withMask(IPv6Address.of((long)-65536L, (long)0L));
        Assert.assertEquals((Object)v.getValue(), (Object)expectedValue);
        Assert.assertEquals((Object)v.getMask(), (Object)expectedMask);
        v = original.withMask(IPv6Address.of((String)"ffff:ffff:ffff::"));
        Assert.assertEquals((Object)v.getValue(), (Object)expectedValue);
        Assert.assertEquals((Object)v.getMask(), (Object)expectedMask);
        Inet6Address i6a = (Inet6Address)InetAddress.getByName("ffff:ffff:ffff::");
        v = original.withMask(IPv6Address.of((Inet6Address)i6a));
        Assert.assertEquals((Object)v.getValue(), (Object)expectedValue);
        Assert.assertEquals((Object)v.getMask(), (Object)expectedMask);
        v = original.withMaskOfLength(48);
        Assert.assertEquals((Object)v.getValue(), (Object)expectedValue);
        Assert.assertEquals((Object)v.getMask(), (Object)expectedMask);
    }

    @Test
    public void testReadFrom() throws OFParseError, UnknownHostException {
        for (int i = 0; i < this.testStrings.length; ++i) {
            byte[] bytes = Inet6Address.getByName(this.testStrings[i]).getAddress();
            IPv6Address ip = IPv6Address.read16Bytes((ChannelBuffer)ChannelBuffers.copiedBuffer((byte[])bytes));
            Assert.assertEquals((Object)this.testStrings[i], (Object)ip.toString());
            Assert.assertArrayEquals((byte[])bytes, (byte[])ip.getBytes());
        }
    }

    @Test
    public void testInvalidIPs() throws OFParseError {
        for (String invalid : this.invalidIPs) {
            try {
                IPv6Address.of((String)invalid);
                Assert.fail((String)("Invalid IP " + invalid + " should have raised IllegalArgumentException"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testZeroCompression() throws OFParseError {
        Assert.assertEquals((Object)"::", (Object)IPv6Address.of((String)"::").toString(true, false));
        Assert.assertEquals((Object)"0:0:0:0:0:0:0:0", (Object)IPv6Address.of((String)"::").toString(false, false));
        Assert.assertEquals((Object)"0000:0000:0000:0000:0000:0000:0000:0000", (Object)IPv6Address.of((String)"::").toString(false, true));
        Assert.assertEquals((Object)"1::4:5:6:0:8", (Object)IPv6Address.of((String)"1:0:0:4:5:6:0:8").toString(true, false));
        Assert.assertEquals((Object)"1:0:0:4::8", (Object)IPv6Address.of((String)"1:0:0:4:0:0:0:8").toString(true, false));
    }

    @Test
    public void testSuperclass() throws Exception {
        for (String ipString : this.testStrings) {
            IPAddress superIp = IPAddress.of((String)ipString);
            Assert.assertEquals((Object)IPVersion.IPv6, (Object)superIp.getIpVersion());
            Assert.assertEquals((Object)IPv6Address.of((String)ipString), (Object)superIp);
        }
        for (WithMaskTaskCase w : this.withMasks) {
            String ipMaskedString = w.input;
            IPAddressWithMask superIp = IPAddressWithMask.of((String)ipMaskedString);
            Assert.assertEquals((Object)IPVersion.IPv6, (Object)superIp.getIpVersion());
            Assert.assertEquals((Object)IPv6AddressWithMask.of((String)ipMaskedString), (Object)superIp);
        }
    }

    @Test
    public void testCompareTo() {
        Assert.assertThat((Object)IPv6Address.of((String)"fc00::1").compareTo(IPv6Address.of((String)"fc00::2")), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0)));
        Assert.assertThat((Object)IPv6Address.of((String)"::1").compareTo(IPv6Address.of((String)"fc00::")), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(0)));
        Assert.assertThat((Object)IPv6Address.of((String)"fc00::1").compareTo(IPv6Address.of((String)"1234::3")), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        Assert.assertThat((Object)IPv6Address.of((String)"::8000:0:0:1").compareTo(IPv6Address.of((String)"::1")), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
    }

    @Test
    public void testOfExceptions() throws Exception {
        byte[] b;
        try {
            IPv6AddressWithMask.of(null);
            Assert.fail((String)"Should have thrown NullPointerException");
        }
        catch (NullPointerException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
        try {
            String s = null;
            IPv6Address.of(s);
            Assert.fail((String)"Should have thrown NullPointerException");
        }
        catch (NullPointerException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
        try {
            b = null;
            IPv6Address.of(b);
            Assert.fail((String)"Should have thrown NullPointerException");
        }
        catch (NullPointerException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
        try {
            b = new byte[7];
            IPv6Address.of((byte[])b);
            Assert.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException b2) {
            // empty catch block
        }
        try {
            b = new byte[9];
            IPv6Address.of((byte[])b);
            Assert.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException b3) {
            // empty catch block
        }
        try {
            IPv6AddressWithMask.of((IPv6Address)IPv6Address.of((String)"1::"), null);
            Assert.fail((String)"Should have thrown NullPointerException");
        }
        catch (NullPointerException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
        try {
            IPv6AddressWithMask.of(null, (IPv6Address)IPv6Address.of((String)"255::"));
            Assert.fail((String)"Should have thrown NullPointerException");
        }
        catch (NullPointerException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
        try {
            IPv6AddressWithMask.of((IPv6Address)IPv6Address.of((String)"10:10::0"), (IPv6Address)IPv6Address.of((String)"ffff:0:ffff::")).getSubnetBroadcastAddress();
            Assert.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
        try {
            IPv6Address.ofCidrMaskLength((int)-1);
            Assert.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
        try {
            IPv6Address.ofCidrMaskLength((int)129);
            Assert.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException e) {
            Assert.assertNotNull((Object)e.getMessage());
        }
    }

    @Test
    public void testZoneId() throws OFParseError {
        Assert.assertEquals((Object)"::", (Object)IPv6Address.of((String)"::%eth0").toString(true, false));
        Assert.assertEquals((Object)"1:0:0:4::8", (Object)IPv6Address.of((String)"1:0:0:4:0:0:0:8%2").toString(true, false));
    }

    private class WithMaskTaskCase {
        final String input;
        boolean hasMask;
        int expectedMaskLength = 128;
        byte[] expectedMask = IPv6AddressTest.access$000(IPv6AddressTest.this).decode((CharSequence)"ff ff ff ff ff ff ff ff ff ff ff ff ff ff ff ff".replaceAll(" ", ""));

        public WithMaskTaskCase(String input) {
            this.input = input;
        }

        public WithMaskTaskCase maskHex(String string) {
            string = string.replaceAll(" ", "");
            this.hasMask = true;
            this.expectedMask = IPv6AddressTest.this.hex.decode((CharSequence)string);
            return this;
        }

        public WithMaskTaskCase expectedMaskLength(int expectedLength) {
            this.expectedMaskLength = expectedLength;
            return this;
        }
    }
}

