/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver10;

import com.google.common.hash.PrimitiveSink;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFFlowWildcards;

public class OFFlowWildcardsSerializerVer10 {
    public static final int IN_PORT_VAL = 1;
    public static final int DL_VLAN_VAL = 2;
    public static final int DL_SRC_VAL = 4;
    public static final int DL_DST_VAL = 8;
    public static final int DL_TYPE_VAL = 16;
    public static final int NW_PROTO_VAL = 32;
    public static final int TP_SRC_VAL = 64;
    public static final int TP_DST_VAL = 128;
    public static final int NW_SRC_ALL_VAL = 8192;
    public static final int NW_SRC_MASK_VAL = 16128;
    public static final int NW_DST_ALL_VAL = 524288;
    public static final int NW_DST_MASK_VAL = 1032192;
    public static final int DL_VLAN_PCP_VAL = 0x100000;
    public static final int NW_TOS_VAL = 0x200000;
    public static final int ALL_VAL = 0x3FFFFF;

    public static Set<OFFlowWildcards> readFrom(ChannelBuffer bb) throws OFParseError {
        try {
            return OFFlowWildcardsSerializerVer10.ofWireValue(bb.readInt());
        }
        catch (IllegalArgumentException e) {
            throw new OFParseError(e);
        }
    }

    public static void writeTo(ChannelBuffer bb, Set<OFFlowWildcards> set) {
        bb.writeInt(OFFlowWildcardsSerializerVer10.toWireValue(set));
    }

    public static void putTo(Set<OFFlowWildcards> set, PrimitiveSink sink) {
        sink.putInt(OFFlowWildcardsSerializerVer10.toWireValue(set));
    }

    public static Set<OFFlowWildcards> ofWireValue(int val) {
        EnumSet<OFFlowWildcards> set = EnumSet.noneOf(OFFlowWildcards.class);
        if ((val & 1) != 0) {
            set.add(OFFlowWildcards.IN_PORT);
        }
        if ((val & 2) != 0) {
            set.add(OFFlowWildcards.DL_VLAN);
        }
        if ((val & 4) != 0) {
            set.add(OFFlowWildcards.DL_SRC);
        }
        if ((val & 8) != 0) {
            set.add(OFFlowWildcards.DL_DST);
        }
        if ((val & 0x10) != 0) {
            set.add(OFFlowWildcards.DL_TYPE);
        }
        if ((val & 0x20) != 0) {
            set.add(OFFlowWildcards.NW_PROTO);
        }
        if ((val & 0x40) != 0) {
            set.add(OFFlowWildcards.TP_SRC);
        }
        if ((val & 0x80) != 0) {
            set.add(OFFlowWildcards.TP_DST);
        }
        if ((val & 0x2000) != 0) {
            set.add(OFFlowWildcards.NW_SRC_ALL);
        }
        if ((val & 0x3F00) != 0) {
            set.add(OFFlowWildcards.NW_SRC_MASK);
        }
        if ((val & 0x80000) != 0) {
            set.add(OFFlowWildcards.NW_DST_ALL);
        }
        if ((val & 0xFC000) != 0) {
            set.add(OFFlowWildcards.NW_DST_MASK);
        }
        if ((val & 0x100000) != 0) {
            set.add(OFFlowWildcards.DL_VLAN_PCP);
        }
        if ((val & 0x200000) != 0) {
            set.add(OFFlowWildcards.NW_TOS);
        }
        if ((val & 0x3FFFFF) != 0) {
            set.add(OFFlowWildcards.ALL);
        }
        return Collections.unmodifiableSet(set);
    }

    public static int toWireValue(Set<OFFlowWildcards> set) {
        int wireValue = 0;
        block17: for (OFFlowWildcards e : set) {
            switch (e) {
                case IN_PORT: {
                    wireValue |= 1;
                    continue block17;
                }
                case DL_VLAN: {
                    wireValue |= 2;
                    continue block17;
                }
                case DL_SRC: {
                    wireValue |= 4;
                    continue block17;
                }
                case DL_DST: {
                    wireValue |= 8;
                    continue block17;
                }
                case DL_TYPE: {
                    wireValue |= 0x10;
                    continue block17;
                }
                case NW_PROTO: {
                    wireValue |= 0x20;
                    continue block17;
                }
                case TP_SRC: {
                    wireValue |= 0x40;
                    continue block17;
                }
                case TP_DST: {
                    wireValue |= 0x80;
                    continue block17;
                }
                case NW_SRC_ALL: {
                    wireValue |= 0x2000;
                    continue block17;
                }
                case NW_SRC_MASK: {
                    wireValue |= 0x3F00;
                    continue block17;
                }
                case NW_DST_ALL: {
                    wireValue |= 0x80000;
                    continue block17;
                }
                case NW_DST_MASK: {
                    wireValue |= 0xFC000;
                    continue block17;
                }
                case DL_VLAN_PCP: {
                    wireValue |= 0x100000;
                    continue block17;
                }
                case NW_TOS: {
                    wireValue |= 0x200000;
                    continue block17;
                }
                case ALL: {
                    wireValue |= 0x3FFFFF;
                    continue block17;
                }
            }
            throw new IllegalArgumentException("Illegal enum value for type OFFlowWildcards in version 1.0: " + (Object)((Object)e));
        }
        return wireValue;
    }
}

