/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver10;

import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFPortConfig;
import org.projectfloodlight.openflow.protocol.OFPortDesc;
import org.projectfloodlight.openflow.protocol.OFPortDescProp;
import org.projectfloodlight.openflow.protocol.OFPortFeatures;
import org.projectfloodlight.openflow.protocol.OFPortState;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver10.OFPortConfigSerializerVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFPortFeaturesSerializerVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFPortStateSerializerVer10;
import org.projectfloodlight.openflow.types.MacAddress;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.U64;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFPortDescVer10
implements OFPortDesc {
    private static final Logger logger = LoggerFactory.getLogger(OFPortDescVer10.class);
    static final byte WIRE_VERSION = 1;
    static final int LENGTH = 48;
    private static final OFPort DEFAULT_PORT_NO = OFPort.ANY;
    private static final MacAddress DEFAULT_HW_ADDR = MacAddress.NONE;
    private static final String DEFAULT_NAME = "";
    private static final Set<OFPortConfig> DEFAULT_CONFIG = ImmutableSet.of();
    private static final Set<OFPortState> DEFAULT_STATE = ImmutableSet.of();
    private static final Set<OFPortFeatures> DEFAULT_CURR = ImmutableSet.of();
    private static final Set<OFPortFeatures> DEFAULT_ADVERTISED = ImmutableSet.of();
    private static final Set<OFPortFeatures> DEFAULT_SUPPORTED = ImmutableSet.of();
    private static final Set<OFPortFeatures> DEFAULT_PEER = ImmutableSet.of();
    private final OFPort portNo;
    private final MacAddress hwAddr;
    private final String name;
    private final Set<OFPortConfig> config;
    private final Set<OFPortState> state;
    private final Set<OFPortFeatures> curr;
    private final Set<OFPortFeatures> advertised;
    private final Set<OFPortFeatures> supported;
    private final Set<OFPortFeatures> peer;
    static final OFPortDescVer10 DEFAULT = new OFPortDescVer10(DEFAULT_PORT_NO, DEFAULT_HW_ADDR, "", DEFAULT_CONFIG, DEFAULT_STATE, DEFAULT_CURR, DEFAULT_ADVERTISED, DEFAULT_SUPPORTED, DEFAULT_PEER);
    static final Reader READER = new Reader();
    static final OFPortDescVer10Funnel FUNNEL = new OFPortDescVer10Funnel();
    static final Writer WRITER = new Writer();

    OFPortDescVer10(OFPort portNo, MacAddress hwAddr, String name, Set<OFPortConfig> config, Set<OFPortState> state, Set<OFPortFeatures> curr, Set<OFPortFeatures> advertised, Set<OFPortFeatures> supported, Set<OFPortFeatures> peer) {
        if (portNo == null) {
            throw new NullPointerException("OFPortDescVer10: property portNo cannot be null");
        }
        if (hwAddr == null) {
            throw new NullPointerException("OFPortDescVer10: property hwAddr cannot be null");
        }
        if (name == null) {
            throw new NullPointerException("OFPortDescVer10: property name cannot be null");
        }
        if (config == null) {
            throw new NullPointerException("OFPortDescVer10: property config cannot be null");
        }
        if (state == null) {
            throw new NullPointerException("OFPortDescVer10: property state cannot be null");
        }
        if (curr == null) {
            throw new NullPointerException("OFPortDescVer10: property curr cannot be null");
        }
        if (advertised == null) {
            throw new NullPointerException("OFPortDescVer10: property advertised cannot be null");
        }
        if (supported == null) {
            throw new NullPointerException("OFPortDescVer10: property supported cannot be null");
        }
        if (peer == null) {
            throw new NullPointerException("OFPortDescVer10: property peer cannot be null");
        }
        this.portNo = portNo;
        this.hwAddr = hwAddr;
        this.name = name;
        this.config = config;
        this.state = state;
        this.curr = curr;
        this.advertised = advertised;
        this.supported = supported;
        this.peer = peer;
    }

    @Override
    public OFPort getPortNo() {
        return this.portNo;
    }

    @Override
    public MacAddress getHwAddr() {
        return this.hwAddr;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Set<OFPortConfig> getConfig() {
        return this.config;
    }

    @Override
    public Set<OFPortState> getState() {
        return this.state;
    }

    @Override
    public Set<OFPortFeatures> getCurr() {
        return this.curr;
    }

    @Override
    public Set<OFPortFeatures> getAdvertised() {
        return this.advertised;
    }

    @Override
    public Set<OFPortFeatures> getSupported() {
        return this.supported;
    }

    @Override
    public Set<OFPortFeatures> getPeer() {
        return this.peer;
    }

    @Override
    public long getCurrSpeed() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property currSpeed not supported in version 1.0");
    }

    @Override
    public long getMaxSpeed() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property maxSpeed not supported in version 1.0");
    }

    @Override
    public List<OFPortDescProp> getProperties() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property properties not supported in version 1.0");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_10;
    }

    @Override
    public boolean isEnabled() {
        return !this.state.contains((Object)OFPortState.LINK_DOWN) && !this.config.contains((Object)OFPortConfig.PORT_DOWN);
    }

    @Override
    @Nonnull
    public U64 getBsnGenerationId() {
        return U64.ZERO;
    }

    @Override
    public OFPortDesc.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFPortDescVer10(");
        b.append("portNo=").append(this.portNo);
        b.append(", ");
        b.append("hwAddr=").append(this.hwAddr);
        b.append(", ");
        b.append("name=").append(this.name);
        b.append(", ");
        b.append("config=").append(this.config);
        b.append(", ");
        b.append("state=").append(this.state);
        b.append(", ");
        b.append("curr=").append(this.curr);
        b.append(", ");
        b.append("advertised=").append(this.advertised);
        b.append(", ");
        b.append("supported=").append(this.supported);
        b.append(", ");
        b.append("peer=").append(this.peer);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFPortDescVer10 other = (OFPortDescVer10)obj;
        if (this.portNo == null ? other.portNo != null : !this.portNo.equals(other.portNo)) {
            return false;
        }
        if (this.hwAddr == null ? other.hwAddr != null : !this.hwAddr.equals(other.hwAddr)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.config == null ? other.config != null : !this.config.equals(other.config)) {
            return false;
        }
        if (this.state == null ? other.state != null : !this.state.equals(other.state)) {
            return false;
        }
        if (this.curr == null ? other.curr != null : !this.curr.equals(other.curr)) {
            return false;
        }
        if (this.advertised == null ? other.advertised != null : !this.advertised.equals(other.advertised)) {
            return false;
        }
        if (this.supported == null ? other.supported != null : !this.supported.equals(other.supported)) {
            return false;
        }
        return !(this.peer == null ? other.peer != null : !this.peer.equals(other.peer));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.portNo == null ? 0 : this.portNo.hashCode());
        result = 31 * result + (this.hwAddr == null ? 0 : this.hwAddr.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.config == null ? 0 : this.config.hashCode());
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        result = 31 * result + (this.curr == null ? 0 : this.curr.hashCode());
        result = 31 * result + (this.advertised == null ? 0 : this.advertised.hashCode());
        result = 31 * result + (this.supported == null ? 0 : this.supported.hashCode());
        result = 31 * result + (this.peer == null ? 0 : this.peer.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFPortDescVer10> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFPortDescVer10 message) {
            message.portNo.write2Bytes(bb);
            message.hwAddr.write6Bytes(bb);
            ChannelUtils.writeFixedLengthString(bb, message.name, 16);
            OFPortConfigSerializerVer10.writeTo(bb, message.config);
            OFPortStateSerializerVer10.writeTo(bb, message.state);
            OFPortFeaturesSerializerVer10.writeTo(bb, message.curr);
            OFPortFeaturesSerializerVer10.writeTo(bb, message.advertised);
            OFPortFeaturesSerializerVer10.writeTo(bb, message.supported);
            OFPortFeaturesSerializerVer10.writeTo(bb, message.peer);
        }
    }

    static class OFPortDescVer10Funnel
    implements Funnel<OFPortDescVer10> {
        private static final long serialVersionUID = 1L;

        OFPortDescVer10Funnel() {
        }

        public void funnel(OFPortDescVer10 message, PrimitiveSink sink) {
            message.portNo.putTo(sink);
            message.hwAddr.putTo(sink);
            sink.putUnencodedChars((CharSequence)message.name);
            OFPortConfigSerializerVer10.putTo(message.config, sink);
            OFPortStateSerializerVer10.putTo(message.state, sink);
            OFPortFeaturesSerializerVer10.putTo(message.curr, sink);
            OFPortFeaturesSerializerVer10.putTo(message.advertised, sink);
            OFPortFeaturesSerializerVer10.putTo(message.supported, sink);
            OFPortFeaturesSerializerVer10.putTo(message.peer, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFPortDesc> {
        Reader() {
        }

        @Override
        public OFPortDesc readFrom(ChannelBuffer bb) throws OFParseError {
            OFPort portNo = OFPort.read2Bytes(bb);
            MacAddress hwAddr = MacAddress.read6Bytes(bb);
            String name = ChannelUtils.readFixedLengthString(bb, 16);
            Set<OFPortConfig> config = OFPortConfigSerializerVer10.readFrom(bb);
            Set<OFPortState> state = OFPortStateSerializerVer10.readFrom(bb);
            Set<OFPortFeatures> curr = OFPortFeaturesSerializerVer10.readFrom(bb);
            Set<OFPortFeatures> advertised = OFPortFeaturesSerializerVer10.readFrom(bb);
            Set<OFPortFeatures> supported = OFPortFeaturesSerializerVer10.readFrom(bb);
            Set<OFPortFeatures> peer = OFPortFeaturesSerializerVer10.readFrom(bb);
            OFPortDescVer10 portDescVer10 = new OFPortDescVer10(portNo, hwAddr, name, config, state, curr, advertised, supported, peer);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)portDescVer10);
            }
            return portDescVer10;
        }
    }

    static class Builder
    implements OFPortDesc.Builder {
        private boolean portNoSet;
        private OFPort portNo;
        private boolean hwAddrSet;
        private MacAddress hwAddr;
        private boolean nameSet;
        private String name;
        private boolean configSet;
        private Set<OFPortConfig> config;
        private boolean stateSet;
        private Set<OFPortState> state;
        private boolean currSet;
        private Set<OFPortFeatures> curr;
        private boolean advertisedSet;
        private Set<OFPortFeatures> advertised;
        private boolean supportedSet;
        private Set<OFPortFeatures> supported;
        private boolean peerSet;
        private Set<OFPortFeatures> peer;

        Builder() {
        }

        @Override
        public OFPort getPortNo() {
            return this.portNo;
        }

        @Override
        public OFPortDesc.Builder setPortNo(OFPort portNo) {
            this.portNo = portNo;
            this.portNoSet = true;
            return this;
        }

        @Override
        public MacAddress getHwAddr() {
            return this.hwAddr;
        }

        @Override
        public OFPortDesc.Builder setHwAddr(MacAddress hwAddr) {
            this.hwAddr = hwAddr;
            this.hwAddrSet = true;
            return this;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public OFPortDesc.Builder setName(String name) {
            this.name = name;
            this.nameSet = true;
            return this;
        }

        @Override
        public Set<OFPortConfig> getConfig() {
            return this.config;
        }

        @Override
        public OFPortDesc.Builder setConfig(Set<OFPortConfig> config) {
            this.config = config;
            this.configSet = true;
            return this;
        }

        @Override
        public Set<OFPortState> getState() {
            return this.state;
        }

        @Override
        public OFPortDesc.Builder setState(Set<OFPortState> state) {
            this.state = state;
            this.stateSet = true;
            return this;
        }

        @Override
        public Set<OFPortFeatures> getCurr() {
            return this.curr;
        }

        @Override
        public OFPortDesc.Builder setCurr(Set<OFPortFeatures> curr) {
            this.curr = curr;
            this.currSet = true;
            return this;
        }

        @Override
        public Set<OFPortFeatures> getAdvertised() {
            return this.advertised;
        }

        @Override
        public OFPortDesc.Builder setAdvertised(Set<OFPortFeatures> advertised) {
            this.advertised = advertised;
            this.advertisedSet = true;
            return this;
        }

        @Override
        public Set<OFPortFeatures> getSupported() {
            return this.supported;
        }

        @Override
        public OFPortDesc.Builder setSupported(Set<OFPortFeatures> supported) {
            this.supported = supported;
            this.supportedSet = true;
            return this;
        }

        @Override
        public Set<OFPortFeatures> getPeer() {
            return this.peer;
        }

        @Override
        public OFPortDesc.Builder setPeer(Set<OFPortFeatures> peer) {
            this.peer = peer;
            this.peerSet = true;
            return this;
        }

        @Override
        public long getCurrSpeed() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property currSpeed not supported in version 1.0");
        }

        @Override
        public OFPortDesc.Builder setCurrSpeed(long currSpeed) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property currSpeed not supported in version 1.0");
        }

        @Override
        public long getMaxSpeed() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property maxSpeed not supported in version 1.0");
        }

        @Override
        public OFPortDesc.Builder setMaxSpeed(long maxSpeed) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property maxSpeed not supported in version 1.0");
        }

        @Override
        public List<OFPortDescProp> getProperties() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property properties not supported in version 1.0");
        }

        @Override
        public OFPortDesc.Builder setProperties(List<OFPortDescProp> properties) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property properties not supported in version 1.0");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_10;
        }

        @Override
        public OFPortDesc build() {
            Set<OFPortFeatures> peer;
            Set<OFPortFeatures> supported;
            Set<OFPortFeatures> advertised;
            Set<OFPortFeatures> curr;
            Set<OFPortState> state;
            Set<OFPortConfig> config;
            String name;
            MacAddress hwAddr;
            OFPort portNo;
            OFPort oFPort = portNo = this.portNoSet ? this.portNo : DEFAULT_PORT_NO;
            if (portNo == null) {
                throw new NullPointerException("Property portNo must not be null");
            }
            MacAddress macAddress = hwAddr = this.hwAddrSet ? this.hwAddr : DEFAULT_HW_ADDR;
            if (hwAddr == null) {
                throw new NullPointerException("Property hwAddr must not be null");
            }
            String string = name = this.nameSet ? this.name : OFPortDescVer10.DEFAULT_NAME;
            if (name == null) {
                throw new NullPointerException("Property name must not be null");
            }
            Set<OFPortConfig> set = config = this.configSet ? this.config : DEFAULT_CONFIG;
            if (config == null) {
                throw new NullPointerException("Property config must not be null");
            }
            Set<OFPortState> set2 = state = this.stateSet ? this.state : DEFAULT_STATE;
            if (state == null) {
                throw new NullPointerException("Property state must not be null");
            }
            Set<OFPortFeatures> set3 = curr = this.currSet ? this.curr : DEFAULT_CURR;
            if (curr == null) {
                throw new NullPointerException("Property curr must not be null");
            }
            Set<OFPortFeatures> set4 = advertised = this.advertisedSet ? this.advertised : DEFAULT_ADVERTISED;
            if (advertised == null) {
                throw new NullPointerException("Property advertised must not be null");
            }
            Set<OFPortFeatures> set5 = supported = this.supportedSet ? this.supported : DEFAULT_SUPPORTED;
            if (supported == null) {
                throw new NullPointerException("Property supported must not be null");
            }
            Set<OFPortFeatures> set6 = peer = this.peerSet ? this.peer : DEFAULT_PEER;
            if (peer == null) {
                throw new NullPointerException("Property peer must not be null");
            }
            return new OFPortDescVer10(portNo, hwAddr, name, config, state, curr, advertised, supported, peer);
        }
    }

    static class BuilderWithParent
    implements OFPortDesc.Builder {
        final OFPortDescVer10 parentMessage;
        private boolean portNoSet;
        private OFPort portNo;
        private boolean hwAddrSet;
        private MacAddress hwAddr;
        private boolean nameSet;
        private String name;
        private boolean configSet;
        private Set<OFPortConfig> config;
        private boolean stateSet;
        private Set<OFPortState> state;
        private boolean currSet;
        private Set<OFPortFeatures> curr;
        private boolean advertisedSet;
        private Set<OFPortFeatures> advertised;
        private boolean supportedSet;
        private Set<OFPortFeatures> supported;
        private boolean peerSet;
        private Set<OFPortFeatures> peer;

        BuilderWithParent(OFPortDescVer10 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFPort getPortNo() {
            return this.portNo;
        }

        @Override
        public OFPortDesc.Builder setPortNo(OFPort portNo) {
            this.portNo = portNo;
            this.portNoSet = true;
            return this;
        }

        @Override
        public MacAddress getHwAddr() {
            return this.hwAddr;
        }

        @Override
        public OFPortDesc.Builder setHwAddr(MacAddress hwAddr) {
            this.hwAddr = hwAddr;
            this.hwAddrSet = true;
            return this;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public OFPortDesc.Builder setName(String name) {
            this.name = name;
            this.nameSet = true;
            return this;
        }

        @Override
        public Set<OFPortConfig> getConfig() {
            return this.config;
        }

        @Override
        public OFPortDesc.Builder setConfig(Set<OFPortConfig> config) {
            this.config = config;
            this.configSet = true;
            return this;
        }

        @Override
        public Set<OFPortState> getState() {
            return this.state;
        }

        @Override
        public OFPortDesc.Builder setState(Set<OFPortState> state) {
            this.state = state;
            this.stateSet = true;
            return this;
        }

        @Override
        public Set<OFPortFeatures> getCurr() {
            return this.curr;
        }

        @Override
        public OFPortDesc.Builder setCurr(Set<OFPortFeatures> curr) {
            this.curr = curr;
            this.currSet = true;
            return this;
        }

        @Override
        public Set<OFPortFeatures> getAdvertised() {
            return this.advertised;
        }

        @Override
        public OFPortDesc.Builder setAdvertised(Set<OFPortFeatures> advertised) {
            this.advertised = advertised;
            this.advertisedSet = true;
            return this;
        }

        @Override
        public Set<OFPortFeatures> getSupported() {
            return this.supported;
        }

        @Override
        public OFPortDesc.Builder setSupported(Set<OFPortFeatures> supported) {
            this.supported = supported;
            this.supportedSet = true;
            return this;
        }

        @Override
        public Set<OFPortFeatures> getPeer() {
            return this.peer;
        }

        @Override
        public OFPortDesc.Builder setPeer(Set<OFPortFeatures> peer) {
            this.peer = peer;
            this.peerSet = true;
            return this;
        }

        @Override
        public long getCurrSpeed() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property currSpeed not supported in version 1.0");
        }

        @Override
        public OFPortDesc.Builder setCurrSpeed(long currSpeed) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property currSpeed not supported in version 1.0");
        }

        @Override
        public long getMaxSpeed() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property maxSpeed not supported in version 1.0");
        }

        @Override
        public OFPortDesc.Builder setMaxSpeed(long maxSpeed) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property maxSpeed not supported in version 1.0");
        }

        @Override
        public List<OFPortDescProp> getProperties() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property properties not supported in version 1.0");
        }

        @Override
        public OFPortDesc.Builder setProperties(List<OFPortDescProp> properties) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property properties not supported in version 1.0");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_10;
        }

        @Override
        public OFPortDesc build() {
            Set peer;
            Set supported;
            Set advertised;
            Set curr;
            Set state;
            Set config;
            String name;
            MacAddress hwAddr;
            OFPort portNo;
            OFPort oFPort = portNo = this.portNoSet ? this.portNo : this.parentMessage.portNo;
            if (portNo == null) {
                throw new NullPointerException("Property portNo must not be null");
            }
            MacAddress macAddress = hwAddr = this.hwAddrSet ? this.hwAddr : this.parentMessage.hwAddr;
            if (hwAddr == null) {
                throw new NullPointerException("Property hwAddr must not be null");
            }
            String string = name = this.nameSet ? this.name : this.parentMessage.name;
            if (name == null) {
                throw new NullPointerException("Property name must not be null");
            }
            Set set = config = this.configSet ? this.config : this.parentMessage.config;
            if (config == null) {
                throw new NullPointerException("Property config must not be null");
            }
            Set set2 = state = this.stateSet ? this.state : this.parentMessage.state;
            if (state == null) {
                throw new NullPointerException("Property state must not be null");
            }
            Set set3 = curr = this.currSet ? this.curr : this.parentMessage.curr;
            if (curr == null) {
                throw new NullPointerException("Property curr must not be null");
            }
            Set set4 = advertised = this.advertisedSet ? this.advertised : this.parentMessage.advertised;
            if (advertised == null) {
                throw new NullPointerException("Property advertised must not be null");
            }
            Set set5 = supported = this.supportedSet ? this.supported : this.parentMessage.supported;
            if (supported == null) {
                throw new NullPointerException("Property supported must not be null");
            }
            Set set6 = peer = this.peerSet ? this.peer : this.parentMessage.peer;
            if (peer == null) {
                throw new NullPointerException("Property peer must not be null");
            }
            return new OFPortDescVer10(portNo, hwAddr, name, config, state, curr, advertised, supported, peer);
        }
    }
}

