/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver11;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFActionSetTpDst;
import org.projectfloodlight.openflow.types.TransportPort;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionSetTpDstVer11
implements OFActionSetTpDst {
    private static final Logger logger = LoggerFactory.getLogger(OFActionSetTpDstVer11.class);
    static final byte WIRE_VERSION = 2;
    static final int LENGTH = 8;
    private static final TransportPort DEFAULT_TP_PORT = TransportPort.NONE;
    private final TransportPort tpPort;
    static final OFActionSetTpDstVer11 DEFAULT = new OFActionSetTpDstVer11(DEFAULT_TP_PORT);
    static final Reader READER = new Reader();
    static final OFActionSetTpDstVer11Funnel FUNNEL = new OFActionSetTpDstVer11Funnel();
    static final Writer WRITER = new Writer();

    OFActionSetTpDstVer11(TransportPort tpPort) {
        if (tpPort == null) {
            throw new NullPointerException("OFActionSetTpDstVer11: property tpPort cannot be null");
        }
        this.tpPort = tpPort;
    }

    @Override
    public OFActionType getType() {
        return OFActionType.SET_TP_DST;
    }

    @Override
    public TransportPort getTpPort() {
        return this.tpPort;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_11;
    }

    @Override
    public OFActionSetTpDst.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionSetTpDstVer11(");
        b.append("tpPort=").append(this.tpPort);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFActionSetTpDstVer11 other = (OFActionSetTpDstVer11)obj;
        return !(this.tpPort == null ? other.tpPort != null : !this.tpPort.equals(other.tpPort));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.tpPort == null ? 0 : this.tpPort.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionSetTpDstVer11> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFActionSetTpDstVer11 message) {
            bb.writeShort(10);
            bb.writeShort(8);
            message.tpPort.write2Bytes(bb);
            bb.writeZero(2);
        }
    }

    static class OFActionSetTpDstVer11Funnel
    implements Funnel<OFActionSetTpDstVer11> {
        private static final long serialVersionUID = 1L;

        OFActionSetTpDstVer11Funnel() {
        }

        public void funnel(OFActionSetTpDstVer11 message, PrimitiveSink sink) {
            sink.putShort((short)10);
            sink.putShort((short)8);
            message.tpPort.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionSetTpDst> {
        Reader() {
        }

        @Override
        public OFActionSetTpDst readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 10) {
                throw new OFParseError("Wrong type: Expected=OFActionType.SET_TP_DST(10), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            TransportPort tpPort = TransportPort.read2Bytes(bb);
            bb.skipBytes(2);
            OFActionSetTpDstVer11 actionSetTpDstVer11 = new OFActionSetTpDstVer11(tpPort);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)actionSetTpDstVer11);
            }
            return actionSetTpDstVer11;
        }
    }

    static class Builder
    implements OFActionSetTpDst.Builder {
        private boolean tpPortSet;
        private TransportPort tpPort;

        Builder() {
        }

        @Override
        public OFActionType getType() {
            return OFActionType.SET_TP_DST;
        }

        @Override
        public TransportPort getTpPort() {
            return this.tpPort;
        }

        @Override
        public OFActionSetTpDst.Builder setTpPort(TransportPort tpPort) {
            this.tpPort = tpPort;
            this.tpPortSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFActionSetTpDst build() {
            TransportPort tpPort;
            TransportPort transportPort = tpPort = this.tpPortSet ? this.tpPort : DEFAULT_TP_PORT;
            if (tpPort == null) {
                throw new NullPointerException("Property tpPort must not be null");
            }
            return new OFActionSetTpDstVer11(tpPort);
        }
    }

    static class BuilderWithParent
    implements OFActionSetTpDst.Builder {
        final OFActionSetTpDstVer11 parentMessage;
        private boolean tpPortSet;
        private TransportPort tpPort;

        BuilderWithParent(OFActionSetTpDstVer11 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFActionType getType() {
            return OFActionType.SET_TP_DST;
        }

        @Override
        public TransportPort getTpPort() {
            return this.tpPort;
        }

        @Override
        public OFActionSetTpDst.Builder setTpPort(TransportPort tpPort) {
            this.tpPort = tpPort;
            this.tpPortSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFActionSetTpDst build() {
            TransportPort tpPort;
            TransportPort transportPort = tpPort = this.tpPortSet ? this.tpPort : this.parentMessage.tpPort;
            if (tpPort == null) {
                throw new NullPointerException("Property tpPort must not be null");
            }
            return new OFActionSetTpDstVer11(tpPort);
        }
    }
}

