/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver11;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFErrorType;
import org.projectfloodlight.openflow.protocol.OFHelloFailedCode;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.errormsg.OFHelloFailedErrorMsg;
import org.projectfloodlight.openflow.protocol.ver11.OFHelloFailedCodeSerializerVer11;
import org.projectfloodlight.openflow.types.OFErrorCauseData;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFHelloFailedErrorMsgVer11
implements OFHelloFailedErrorMsg {
    private static final Logger logger = LoggerFactory.getLogger(OFHelloFailedErrorMsgVer11.class);
    static final byte WIRE_VERSION = 2;
    static final int MINIMUM_LENGTH = 12;
    private static final long DEFAULT_XID = 0L;
    private static final OFErrorCauseData DEFAULT_DATA = OFErrorCauseData.NONE;
    private final long xid;
    private final OFHelloFailedCode code;
    private final OFErrorCauseData data;
    static final Reader READER = new Reader();
    static final OFHelloFailedErrorMsgVer11Funnel FUNNEL = new OFHelloFailedErrorMsgVer11Funnel();
    static final Writer WRITER = new Writer();

    OFHelloFailedErrorMsgVer11(long xid, OFHelloFailedCode code, OFErrorCauseData data) {
        if (code == null) {
            throw new NullPointerException("OFHelloFailedErrorMsgVer11: property code cannot be null");
        }
        if (data == null) {
            throw new NullPointerException("OFHelloFailedErrorMsgVer11: property data cannot be null");
        }
        this.xid = xid;
        this.code = code;
        this.data = data;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_11;
    }

    @Override
    public OFType getType() {
        return OFType.ERROR;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFErrorType getErrType() {
        return OFErrorType.HELLO_FAILED;
    }

    @Override
    public OFHelloFailedCode getCode() {
        return this.code;
    }

    @Override
    public OFErrorCauseData getData() {
        return this.data;
    }

    @Override
    public OFHelloFailedErrorMsg.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFHelloFailedErrorMsgVer11(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("code=").append((Object)this.code);
        b.append(", ");
        b.append("data=").append(this.data);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFHelloFailedErrorMsgVer11 other = (OFHelloFailedErrorMsgVer11)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.code == null ? other.code != null : !this.code.equals((Object)other.code)) {
            return false;
        }
        return !(this.data == null ? other.data != null : !this.data.equals(other.data));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.code == null ? 0 : this.code.hashCode());
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFHelloFailedErrorMsgVer11> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFHelloFailedErrorMsgVer11 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(2);
            bb.writeByte(1);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            bb.writeShort(0);
            OFHelloFailedCodeSerializerVer11.writeTo(bb, message.code);
            message.data.writeTo(bb);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFHelloFailedErrorMsgVer11Funnel
    implements Funnel<OFHelloFailedErrorMsgVer11> {
        private static final long serialVersionUID = 1L;

        OFHelloFailedErrorMsgVer11Funnel() {
        }

        public void funnel(OFHelloFailedErrorMsgVer11 message, PrimitiveSink sink) {
            sink.putByte((byte)2);
            sink.putByte((byte)1);
            sink.putLong(message.xid);
            sink.putShort((short)0);
            OFHelloFailedCodeSerializerVer11.putTo(message.code, sink);
            message.data.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFHelloFailedErrorMsg> {
        Reader() {
        }

        @Override
        public OFHelloFailedErrorMsg readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 2) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_11(2), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 1) {
                throw new OFParseError("Wrong type: Expected=OFType.ERROR(1), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 12) {
                throw new OFParseError("Wrong length: Expected to be >= 12, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            short errType = bb.readShort();
            if (errType != 0) {
                throw new OFParseError("Wrong errType: Expected=OFErrorType.HELLO_FAILED(0), got=" + errType);
            }
            OFHelloFailedCode code = OFHelloFailedCodeSerializerVer11.readFrom(bb);
            OFErrorCauseData data = OFErrorCauseData.read(bb, length - (bb.readerIndex() - start), OFVersion.OF_11);
            OFHelloFailedErrorMsgVer11 helloFailedErrorMsgVer11 = new OFHelloFailedErrorMsgVer11(xid, code, data);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)helloFailedErrorMsgVer11);
            }
            return helloFailedErrorMsgVer11;
        }
    }

    static class Builder
    implements OFHelloFailedErrorMsg.Builder {
        private boolean xidSet;
        private long xid;
        private boolean codeSet;
        private OFHelloFailedCode code;
        private boolean dataSet;
        private OFErrorCauseData data;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFType getType() {
            return OFType.ERROR;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFHelloFailedErrorMsg.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFErrorType getErrType() {
            return OFErrorType.HELLO_FAILED;
        }

        @Override
        public OFHelloFailedCode getCode() {
            return this.code;
        }

        @Override
        public OFHelloFailedErrorMsg.Builder setCode(OFHelloFailedCode code) {
            this.code = code;
            this.codeSet = true;
            return this;
        }

        @Override
        public OFErrorCauseData getData() {
            return this.data;
        }

        @Override
        public OFHelloFailedErrorMsg.Builder setData(OFErrorCauseData data) {
            this.data = data;
            this.dataSet = true;
            return this;
        }

        @Override
        public OFHelloFailedErrorMsg build() {
            OFErrorCauseData data;
            long xid;
            long l = xid = this.xidSet ? this.xid : 0L;
            if (!this.codeSet) {
                throw new IllegalStateException("Property code doesn't have default value -- must be set");
            }
            if (this.code == null) {
                throw new NullPointerException("Property code must not be null");
            }
            OFErrorCauseData oFErrorCauseData = data = this.dataSet ? this.data : DEFAULT_DATA;
            if (data == null) {
                throw new NullPointerException("Property data must not be null");
            }
            return new OFHelloFailedErrorMsgVer11(xid, this.code, data);
        }
    }

    static class BuilderWithParent
    implements OFHelloFailedErrorMsg.Builder {
        final OFHelloFailedErrorMsgVer11 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean codeSet;
        private OFHelloFailedCode code;
        private boolean dataSet;
        private OFErrorCauseData data;

        BuilderWithParent(OFHelloFailedErrorMsgVer11 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFType getType() {
            return OFType.ERROR;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFHelloFailedErrorMsg.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFErrorType getErrType() {
            return OFErrorType.HELLO_FAILED;
        }

        @Override
        public OFHelloFailedCode getCode() {
            return this.code;
        }

        @Override
        public OFHelloFailedErrorMsg.Builder setCode(OFHelloFailedCode code) {
            this.code = code;
            this.codeSet = true;
            return this;
        }

        @Override
        public OFErrorCauseData getData() {
            return this.data;
        }

        @Override
        public OFHelloFailedErrorMsg.Builder setData(OFErrorCauseData data) {
            this.data = data;
            this.dataSet = true;
            return this;
        }

        @Override
        public OFHelloFailedErrorMsg build() {
            OFErrorCauseData data;
            OFHelloFailedCode code;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            OFHelloFailedCode oFHelloFailedCode = code = this.codeSet ? this.code : this.parentMessage.code;
            if (code == null) {
                throw new NullPointerException("Property code must not be null");
            }
            OFErrorCauseData oFErrorCauseData = data = this.dataSet ? this.data : this.parentMessage.data;
            if (data == null) {
                throw new NullPointerException("Property data must not be null");
            }
            return new OFHelloFailedErrorMsgVer11(xid, code, data);
        }
    }
}

