/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver12;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmIpv6FlabelMasked;
import org.projectfloodlight.openflow.protocol.ver12.OFOxmIpv6FlabelVer12;
import org.projectfloodlight.openflow.types.IPv6FlowLabel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmIpv6FlabelMaskedVer12
implements OFOxmIpv6FlabelMasked {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmIpv6FlabelMaskedVer12.class);
    static final byte WIRE_VERSION = 3;
    static final int LENGTH = 12;
    private static final IPv6FlowLabel DEFAULT_VALUE = IPv6FlowLabel.NONE;
    private static final IPv6FlowLabel DEFAULT_VALUE_MASK = IPv6FlowLabel.NONE;
    private final IPv6FlowLabel value;
    private final IPv6FlowLabel mask;
    static final OFOxmIpv6FlabelMaskedVer12 DEFAULT = new OFOxmIpv6FlabelMaskedVer12(DEFAULT_VALUE, DEFAULT_VALUE_MASK);
    static final Reader READER = new Reader();
    static final OFOxmIpv6FlabelMaskedVer12Funnel FUNNEL = new OFOxmIpv6FlabelMaskedVer12Funnel();
    static final Writer WRITER = new Writer();

    OFOxmIpv6FlabelMaskedVer12(IPv6FlowLabel value, IPv6FlowLabel mask) {
        if (value == null) {
            throw new NullPointerException("OFOxmIpv6FlabelMaskedVer12: property value cannot be null");
        }
        if (mask == null) {
            throw new NullPointerException("OFOxmIpv6FlabelMaskedVer12: property mask cannot be null");
        }
        this.value = value;
        this.mask = mask;
    }

    @Override
    public long getTypeLen() {
        return 2147498248L;
    }

    @Override
    public IPv6FlowLabel getValue() {
        return this.value;
    }

    @Override
    public IPv6FlowLabel getMask() {
        return this.mask;
    }

    @Override
    public MatchField<IPv6FlowLabel> getMatchField() {
        return MatchField.IPV6_FLABEL;
    }

    @Override
    public boolean isMasked() {
        return true;
    }

    @Override
    public OFOxm<IPv6FlowLabel> getCanonical() {
        if (IPv6FlowLabel.NO_MASK.equals(this.mask)) {
            return new OFOxmIpv6FlabelVer12(this.value);
        }
        if (IPv6FlowLabel.FULL_MASK.equals(this.mask)) {
            return null;
        }
        return this;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_12;
    }

    @Override
    public OFOxmIpv6FlabelMasked.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmIpv6FlabelMaskedVer12(");
        b.append("value=").append(this.value);
        b.append(", ");
        b.append("mask=").append(this.mask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmIpv6FlabelMaskedVer12 other = (OFOxmIpv6FlabelMaskedVer12)obj;
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.mask == null ? other.mask != null : !this.mask.equals(other.mask));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.mask == null ? 0 : this.mask.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmIpv6FlabelMaskedVer12> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFOxmIpv6FlabelMaskedVer12 message) {
            bb.writeInt(-2147469048);
            message.value.write4Bytes(bb);
            message.mask.write4Bytes(bb);
        }
    }

    static class OFOxmIpv6FlabelMaskedVer12Funnel
    implements Funnel<OFOxmIpv6FlabelMaskedVer12> {
        private static final long serialVersionUID = 1L;

        OFOxmIpv6FlabelMaskedVer12Funnel() {
        }

        public void funnel(OFOxmIpv6FlabelMaskedVer12 message, PrimitiveSink sink) {
            sink.putInt(-2147469048);
            message.value.putTo(sink);
            message.mask.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmIpv6FlabelMasked> {
        Reader() {
        }

        @Override
        public OFOxmIpv6FlabelMasked readFrom(ChannelBuffer bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -2147469048) {
                throw new OFParseError("Wrong typeLen: Expected=0x80003908L(0x80003908L), got=" + typeLen);
            }
            IPv6FlowLabel value = IPv6FlowLabel.read4Bytes(bb);
            IPv6FlowLabel mask = IPv6FlowLabel.read4Bytes(bb);
            OFOxmIpv6FlabelMaskedVer12 oxmIpv6FlabelMaskedVer12 = new OFOxmIpv6FlabelMaskedVer12(value, mask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmIpv6FlabelMaskedVer12);
            }
            return oxmIpv6FlabelMaskedVer12;
        }
    }

    static class Builder
    implements OFOxmIpv6FlabelMasked.Builder {
        private boolean valueSet;
        private IPv6FlowLabel value;
        private boolean maskSet;
        private IPv6FlowLabel mask;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 2147498248L;
        }

        @Override
        public IPv6FlowLabel getValue() {
            return this.value;
        }

        @Override
        public OFOxmIpv6FlabelMasked.Builder setValue(IPv6FlowLabel value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public IPv6FlowLabel getMask() {
            return this.mask;
        }

        @Override
        public OFOxmIpv6FlabelMasked.Builder setMask(IPv6FlowLabel mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<IPv6FlowLabel> getMatchField() {
            return MatchField.IPV6_FLABEL;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<IPv6FlowLabel> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.2");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFOxmIpv6FlabelMasked build() {
            IPv6FlowLabel mask;
            IPv6FlowLabel value;
            IPv6FlowLabel iPv6FlowLabel = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            IPv6FlowLabel iPv6FlowLabel2 = mask = this.maskSet ? this.mask : DEFAULT_VALUE_MASK;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmIpv6FlabelMaskedVer12(value, mask);
        }
    }

    static class BuilderWithParent
    implements OFOxmIpv6FlabelMasked.Builder {
        final OFOxmIpv6FlabelMaskedVer12 parentMessage;
        private boolean valueSet;
        private IPv6FlowLabel value;
        private boolean maskSet;
        private IPv6FlowLabel mask;

        BuilderWithParent(OFOxmIpv6FlabelMaskedVer12 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 2147498248L;
        }

        @Override
        public IPv6FlowLabel getValue() {
            return this.value;
        }

        @Override
        public OFOxmIpv6FlabelMasked.Builder setValue(IPv6FlowLabel value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public IPv6FlowLabel getMask() {
            return this.mask;
        }

        @Override
        public OFOxmIpv6FlabelMasked.Builder setMask(IPv6FlowLabel mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<IPv6FlowLabel> getMatchField() {
            return MatchField.IPV6_FLABEL;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<IPv6FlowLabel> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.2");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFOxmIpv6FlabelMasked build() {
            IPv6FlowLabel mask;
            IPv6FlowLabel value;
            IPv6FlowLabel iPv6FlowLabel = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            IPv6FlowLabel iPv6FlowLabel2 = mask = this.maskSet ? this.mask : this.parentMessage.mask;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmIpv6FlabelMaskedVer12(value, mask);
        }
    }
}

