/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver12;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmTunGbpFlags;
import org.projectfloodlight.openflow.types.U8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmTunGbpFlagsVer12
implements OFOxmTunGbpFlags {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmTunGbpFlagsVer12.class);
    static final byte WIRE_VERSION = 3;
    static final int LENGTH = 5;
    private static final U8 DEFAULT_VALUE = U8.ZERO;
    private final U8 value;
    static final OFOxmTunGbpFlagsVer12 DEFAULT = new OFOxmTunGbpFlagsVer12(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmTunGbpFlagsVer12Funnel FUNNEL = new OFOxmTunGbpFlagsVer12Funnel();
    static final Writer WRITER = new Writer();

    OFOxmTunGbpFlagsVer12(U8 value) {
        if (value == null) {
            throw new NullPointerException("OFOxmTunGbpFlagsVer12: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 85505L;
    }

    @Override
    public U8 getValue() {
        return this.value;
    }

    @Override
    public MatchField<U8> getMatchField() {
        return MatchField.TUN_GBP_FLAGS;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<U8> getCanonical() {
        return this;
    }

    @Override
    public U8 getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.2");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_12;
    }

    @Override
    public OFOxmTunGbpFlags.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmTunGbpFlagsVer12(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmTunGbpFlagsVer12 other = (OFOxmTunGbpFlagsVer12)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmTunGbpFlagsVer12> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFOxmTunGbpFlagsVer12 message) {
            bb.writeInt(85505);
            bb.writeByte((int)message.value.getRaw());
        }
    }

    static class OFOxmTunGbpFlagsVer12Funnel
    implements Funnel<OFOxmTunGbpFlagsVer12> {
        private static final long serialVersionUID = 1L;

        OFOxmTunGbpFlagsVer12Funnel() {
        }

        public void funnel(OFOxmTunGbpFlagsVer12 message, PrimitiveSink sink) {
            sink.putInt(85505);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmTunGbpFlags> {
        Reader() {
        }

        @Override
        public OFOxmTunGbpFlags readFrom(ChannelBuffer bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 85505) {
                throw new OFParseError("Wrong typeLen: Expected=0x14e01L(0x14e01L), got=" + typeLen);
            }
            U8 value = U8.of(bb.readByte());
            OFOxmTunGbpFlagsVer12 oxmTunGbpFlagsVer12 = new OFOxmTunGbpFlagsVer12(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmTunGbpFlagsVer12);
            }
            return oxmTunGbpFlagsVer12;
        }
    }

    static class Builder
    implements OFOxmTunGbpFlags.Builder {
        private boolean valueSet;
        private U8 value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 85505L;
        }

        @Override
        public U8 getValue() {
            return this.value;
        }

        @Override
        public OFOxmTunGbpFlags.Builder setValue(U8 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U8> getMatchField() {
            return MatchField.TUN_GBP_FLAGS;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U8> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.2");
        }

        @Override
        public U8 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.2");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFOxmTunGbpFlags build() {
            U8 value;
            U8 u8 = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmTunGbpFlagsVer12(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmTunGbpFlags.Builder {
        final OFOxmTunGbpFlagsVer12 parentMessage;
        private boolean valueSet;
        private U8 value;

        BuilderWithParent(OFOxmTunGbpFlagsVer12 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 85505L;
        }

        @Override
        public U8 getValue() {
            return this.value;
        }

        @Override
        public OFOxmTunGbpFlags.Builder setValue(U8 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U8> getMatchField() {
            return MatchField.TUN_GBP_FLAGS;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U8> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.2");
        }

        @Override
        public U8 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.2");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_12;
        }

        @Override
        public OFOxmTunGbpFlags build() {
            U8 value;
            U8 u8 = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmTunGbpFlagsVer12(value);
        }
    }
}

