/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver12;

import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFStatsRequest;
import org.projectfloodlight.openflow.protocol.ver12.OFAggregateStatsRequestVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFDescStatsRequestVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFExperimenterStatsRequestVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFFlowStatsRequestVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFGroupDescStatsRequestVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFGroupFeaturesStatsRequestVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFGroupStatsRequestVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFPortStatsRequestVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFQueueStatsRequestVer12;
import org.projectfloodlight.openflow.protocol.ver12.OFTableStatsRequestVer12;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;

abstract class OFStatsRequestVer12 {
    static final byte WIRE_VERSION = 3;
    static final int MINIMUM_LENGTH = 16;
    public static final Reader READER = new Reader();

    OFStatsRequestVer12() {
    }

    static class Reader
    implements OFMessageReader<OFStatsRequest<?>> {
        Reader() {
        }

        @Override
        public OFStatsRequest<?> readFrom(ChannelBuffer bb) throws OFParseError {
            if (bb.readableBytes() < 16) {
                return null;
            }
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 3) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_12(3), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 18) {
                throw new OFParseError("Wrong type: Expected=OFType.STATS_REQUEST(18), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 16) {
                throw new OFParseError("Wrong length: Expected to be >= 16, was: " + length);
            }
            U32.f(bb.readInt());
            short statsType = bb.readShort();
            bb.readerIndex(start);
            switch (statsType) {
                case 2: {
                    return OFAggregateStatsRequestVer12.READER.readFrom(bb);
                }
                case -1: {
                    return OFExperimenterStatsRequestVer12.READER.readFrom(bb);
                }
                case 0: {
                    return OFDescStatsRequestVer12.READER.readFrom(bb);
                }
                case 1: {
                    return OFFlowStatsRequestVer12.READER.readFrom(bb);
                }
                case 4: {
                    return OFPortStatsRequestVer12.READER.readFrom(bb);
                }
                case 5: {
                    return OFQueueStatsRequestVer12.READER.readFrom(bb);
                }
                case 3: {
                    return OFTableStatsRequestVer12.READER.readFrom(bb);
                }
                case 7: {
                    return OFGroupDescStatsRequestVer12.READER.readFrom(bb);
                }
                case 6: {
                    return OFGroupStatsRequestVer12.READER.readFrom(bb);
                }
                case 8: {
                    return OFGroupFeaturesStatsRequestVer12.READER.readFrom(bb);
                }
            }
            throw new OFParseError("Unknown value for discriminator statsType of class OFStatsRequestVer12: " + statsType);
        }
    }
}

