/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFActionCircuit;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.ver13.OFOxmVer13;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionCircuitVer13
implements OFActionCircuit {
    private static final Logger logger = LoggerFactory.getLogger(OFActionCircuitVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int MINIMUM_LENGTH = 18;
    private final OFOxm<?> field;
    static final Reader READER = new Reader();
    static final OFActionCircuitVer13Funnel FUNNEL = new OFActionCircuitVer13Funnel();
    static final Writer WRITER = new Writer();

    OFActionCircuitVer13(OFOxm<?> field) {
        if (field == null) {
            throw new NullPointerException("OFActionCircuitVer13: property field cannot be null");
        }
        this.field = field;
    }

    @Override
    public OFActionType getType() {
        return OFActionType.EXPERIMENTER;
    }

    @Override
    public long getExperimenter() {
        return 7636849L;
    }

    @Override
    public int getSubtype() {
        return 25;
    }

    @Override
    public int getHlength() {
        return 16;
    }

    @Override
    public OFOxm<?> getField() {
        return this.field;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFActionCircuit.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionCircuitVer13(");
        b.append("field=").append(this.field);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFActionCircuitVer13 other = (OFActionCircuitVer13)obj;
        return !(this.field == null ? other.field != null : !this.field.equals(other.field));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.field == null ? 0 : this.field.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionCircuitVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFActionCircuitVer13 message) {
            int startIndex = bb.writerIndex();
            bb.writeShort(-1);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(7636849);
            bb.writeShort(25);
            bb.writeShort(16);
            message.field.writeTo(bb);
            bb.writeZero(2);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFActionCircuitVer13Funnel
    implements Funnel<OFActionCircuitVer13> {
        private static final long serialVersionUID = 1L;

        OFActionCircuitVer13Funnel() {
        }

        public void funnel(OFActionCircuitVer13 message, PrimitiveSink sink) {
            sink.putShort((short)-1);
            sink.putInt(7636849);
            sink.putShort((short)25);
            sink.putShort((short)16);
            message.field.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionCircuit> {
        Reader() {
        }

        @Override
        public OFActionCircuit readFrom(ChannelBuffer bb) throws OFParseError {
            int experimenter;
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != -1) {
                throw new OFParseError("Wrong type: Expected=OFActionType.EXPERIMENTER(65535), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 18) {
                throw new OFParseError("Wrong length: Expected to be >= 18, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if ((experimenter = bb.readInt()) != 7636849) {
                throw new OFParseError("Wrong experimenter: Expected=0x748771L(0x748771L), got=" + experimenter);
            }
            short subtype = bb.readShort();
            if (subtype != 25) {
                throw new OFParseError("Wrong subtype: Expected=0x19(0x19), got=" + subtype);
            }
            short hlength = bb.readShort();
            if (hlength != 16) {
                throw new OFParseError("Wrong hlength: Expected=0x10(0x10), got=" + hlength);
            }
            Object field = OFOxmVer13.READER.readFrom(bb);
            bb.skipBytes(2);
            OFActionCircuitVer13 actionCircuitVer13 = new OFActionCircuitVer13((OFOxm<?>)field);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)actionCircuitVer13);
            }
            return actionCircuitVer13;
        }
    }

    static class Builder
    implements OFActionCircuit.Builder {
        private boolean fieldSet;
        private OFOxm<?> field;

        Builder() {
        }

        @Override
        public OFActionType getType() {
            return OFActionType.EXPERIMENTER;
        }

        @Override
        public long getExperimenter() {
            return 7636849L;
        }

        @Override
        public int getSubtype() {
            return 25;
        }

        @Override
        public int getHlength() {
            return 16;
        }

        @Override
        public OFOxm<?> getField() {
            return this.field;
        }

        @Override
        public OFActionCircuit.Builder setField(OFOxm<?> field) {
            this.field = field;
            this.fieldSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFActionCircuit build() {
            if (!this.fieldSet) {
                throw new IllegalStateException("Property field doesn't have default value -- must be set");
            }
            if (this.field == null) {
                throw new NullPointerException("Property field must not be null");
            }
            return new OFActionCircuitVer13(this.field);
        }
    }

    static class BuilderWithParent
    implements OFActionCircuit.Builder {
        final OFActionCircuitVer13 parentMessage;
        private boolean fieldSet;
        private OFOxm<?> field;

        BuilderWithParent(OFActionCircuitVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFActionType getType() {
            return OFActionType.EXPERIMENTER;
        }

        @Override
        public long getExperimenter() {
            return 7636849L;
        }

        @Override
        public int getSubtype() {
            return 25;
        }

        @Override
        public int getHlength() {
            return 16;
        }

        @Override
        public OFOxm<?> getField() {
            return this.field;
        }

        @Override
        public OFActionCircuit.Builder setField(OFOxm<?> field) {
            this.field = field;
            this.fieldSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFActionCircuit build() {
            OFOxm field;
            OFOxm oFOxm = field = this.fieldSet ? this.field : this.parentMessage.field;
            if (field == null) {
                throw new NullPointerException("Property field must not be null");
            }
            return new OFActionCircuitVer13(field);
        }
    }
}

