/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.actionid.OFActionIdCircuit;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionIdCircuitVer13
implements OFActionIdCircuit {
    private static final Logger logger = LoggerFactory.getLogger(OFActionIdCircuitVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 12;
    static final OFActionIdCircuitVer13 DEFAULT = new OFActionIdCircuitVer13();
    static final OFActionIdCircuitVer13 INSTANCE = new OFActionIdCircuitVer13();
    static final Reader READER = new Reader();
    static final OFActionIdCircuitVer13Funnel FUNNEL = new OFActionIdCircuitVer13Funnel();
    static final Writer WRITER = new Writer();

    private OFActionIdCircuitVer13() {
    }

    @Override
    public OFActionType getType() {
        return OFActionType.EXPERIMENTER;
    }

    @Override
    public long getExperimenter() {
        return 7636849L;
    }

    @Override
    public int getSubtype() {
        return 25;
    }

    @Override
    public int getHlength() {
        return 16;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFActionIdCircuit.Builder createBuilder() {
        throw new UnsupportedOperationException("OFActionIdCircuitVer13 has no mutable properties -- builder unneeded");
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionIdCircuitVer13(");
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionIdCircuitVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFActionIdCircuitVer13 message) {
            bb.writeShort(-1);
            bb.writeShort(12);
            bb.writeInt(7636849);
            bb.writeShort(25);
            bb.writeShort(16);
        }
    }

    static class OFActionIdCircuitVer13Funnel
    implements Funnel<OFActionIdCircuitVer13> {
        private static final long serialVersionUID = 1L;

        OFActionIdCircuitVer13Funnel() {
        }

        public void funnel(OFActionIdCircuitVer13 message, PrimitiveSink sink) {
            sink.putShort((short)-1);
            sink.putShort((short)12);
            sink.putInt(7636849);
            sink.putShort((short)25);
            sink.putShort((short)16);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionIdCircuit> {
        Reader() {
        }

        @Override
        public OFActionIdCircuit readFrom(ChannelBuffer bb) throws OFParseError {
            int experimenter;
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != -1) {
                throw new OFParseError("Wrong type: Expected=OFActionType.EXPERIMENTER(65535), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 12) {
                throw new OFParseError("Wrong length: Expected=12(12), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if ((experimenter = bb.readInt()) != 7636849) {
                throw new OFParseError("Wrong experimenter: Expected=0x748771L(0x748771L), got=" + experimenter);
            }
            short subtype = bb.readShort();
            if (subtype != 25) {
                throw new OFParseError("Wrong subtype: Expected=0x19(0x19), got=" + subtype);
            }
            short hlength = bb.readShort();
            if (hlength != 16) {
                throw new OFParseError("Wrong hlength: Expected=0x10(0x10), got=" + hlength);
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - returning shared instance={}", (Object)INSTANCE);
            }
            return INSTANCE;
        }
    }
}

