/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.Set;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFBsnVrfCounterStatsRequest;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFStatsRequestFlags;
import org.projectfloodlight.openflow.protocol.OFStatsType;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver13.OFStatsRequestFlagsSerializerVer13;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnVrfCounterStatsRequestVer13
implements OFBsnVrfCounterStatsRequest {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnVrfCounterStatsRequestVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 28;
    private static final long DEFAULT_XID = 0L;
    private static final Set<OFStatsRequestFlags> DEFAULT_FLAGS = ImmutableSet.of();
    private static final long DEFAULT_VRF = 0L;
    private final long xid;
    private final Set<OFStatsRequestFlags> flags;
    private final long vrf;
    static final OFBsnVrfCounterStatsRequestVer13 DEFAULT = new OFBsnVrfCounterStatsRequestVer13(0L, DEFAULT_FLAGS, 0L);
    static final Reader READER = new Reader();
    static final OFBsnVrfCounterStatsRequestVer13Funnel FUNNEL = new OFBsnVrfCounterStatsRequestVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnVrfCounterStatsRequestVer13(long xid, Set<OFStatsRequestFlags> flags, long vrf) {
        if (flags == null) {
            throw new NullPointerException("OFBsnVrfCounterStatsRequestVer13: property flags cannot be null");
        }
        this.xid = xid;
        this.flags = flags;
        this.vrf = vrf;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFType getType() {
        return OFType.STATS_REQUEST;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public OFStatsType getStatsType() {
        return OFStatsType.EXPERIMENTER;
    }

    @Override
    public Set<OFStatsRequestFlags> getFlags() {
        return this.flags;
    }

    @Override
    public long getExperimenter() {
        return 6035143L;
    }

    @Override
    public long getSubtype() {
        return 15L;
    }

    @Override
    public long getVrf() {
        return this.vrf;
    }

    @Override
    public OFBsnVrfCounterStatsRequest.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnVrfCounterStatsRequestVer13(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("flags=").append(this.flags);
        b.append(", ");
        b.append("vrf=").append(this.vrf);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnVrfCounterStatsRequestVer13 other = (OFBsnVrfCounterStatsRequestVer13)obj;
        if (this.xid != other.xid) {
            return false;
        }
        if (this.flags == null ? other.flags != null : !this.flags.equals(other.flags)) {
            return false;
        }
        return this.vrf == other.vrf;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + (this.flags == null ? 0 : this.flags.hashCode());
        result = 31 * (int)(this.vrf ^ this.vrf >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnVrfCounterStatsRequestVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFBsnVrfCounterStatsRequestVer13 message) {
            bb.writeByte(4);
            bb.writeByte(18);
            bb.writeShort(28);
            bb.writeInt(U32.t(message.xid));
            bb.writeShort(-1);
            OFStatsRequestFlagsSerializerVer13.writeTo(bb, message.flags);
            bb.writeZero(4);
            bb.writeInt(6035143);
            bb.writeInt(15);
            bb.writeInt(U32.t(message.vrf));
        }
    }

    static class OFBsnVrfCounterStatsRequestVer13Funnel
    implements Funnel<OFBsnVrfCounterStatsRequestVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnVrfCounterStatsRequestVer13Funnel() {
        }

        public void funnel(OFBsnVrfCounterStatsRequestVer13 message, PrimitiveSink sink) {
            sink.putByte((byte)4);
            sink.putByte((byte)18);
            sink.putShort((short)28);
            sink.putLong(message.xid);
            sink.putShort((short)-1);
            OFStatsRequestFlagsSerializerVer13.putTo(message.flags, sink);
            sink.putInt(6035143);
            sink.putInt(15);
            sink.putLong(message.vrf);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnVrfCounterStatsRequest> {
        Reader() {
        }

        @Override
        public OFBsnVrfCounterStatsRequest readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 4) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_13(4), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 18) {
                throw new OFParseError("Wrong type: Expected=OFType.STATS_REQUEST(18), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 28) {
                throw new OFParseError("Wrong length: Expected=28(28), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            short statsType = bb.readShort();
            if (statsType != -1) {
                throw new OFParseError("Wrong statsType: Expected=OFStatsType.EXPERIMENTER(65535), got=" + statsType);
            }
            Set<OFStatsRequestFlags> flags = OFStatsRequestFlagsSerializerVer13.readFrom(bb);
            bb.skipBytes(4);
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int subtype = bb.readInt();
            if (subtype != 15) {
                throw new OFParseError("Wrong subtype: Expected=0xfL(0xfL), got=" + subtype);
            }
            long vrf = U32.f(bb.readInt());
            OFBsnVrfCounterStatsRequestVer13 bsnVrfCounterStatsRequestVer13 = new OFBsnVrfCounterStatsRequestVer13(xid, flags, vrf);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnVrfCounterStatsRequestVer13);
            }
            return bsnVrfCounterStatsRequestVer13;
        }
    }

    static class Builder
    implements OFBsnVrfCounterStatsRequest.Builder {
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsRequestFlags> flags;
        private boolean vrfSet;
        private long vrf;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnVrfCounterStatsRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.EXPERIMENTER;
        }

        @Override
        public Set<OFStatsRequestFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFBsnVrfCounterStatsRequest.Builder setFlags(Set<OFStatsRequestFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 15L;
        }

        @Override
        public long getVrf() {
            return this.vrf;
        }

        @Override
        public OFBsnVrfCounterStatsRequest.Builder setVrf(long vrf) {
            this.vrf = vrf;
            this.vrfSet = true;
            return this;
        }

        @Override
        public OFBsnVrfCounterStatsRequest build() {
            Set<OFStatsRequestFlags> flags;
            long xid = this.xidSet ? this.xid : 0L;
            Set<OFStatsRequestFlags> set = flags = this.flagsSet ? this.flags : DEFAULT_FLAGS;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            long vrf = this.vrfSet ? this.vrf : 0L;
            return new OFBsnVrfCounterStatsRequestVer13(xid, flags, vrf);
        }
    }

    static class BuilderWithParent
    implements OFBsnVrfCounterStatsRequest.Builder {
        final OFBsnVrfCounterStatsRequestVer13 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean flagsSet;
        private Set<OFStatsRequestFlags> flags;
        private boolean vrfSet;
        private long vrf;

        BuilderWithParent(OFBsnVrfCounterStatsRequestVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFType getType() {
            return OFType.STATS_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFBsnVrfCounterStatsRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public OFStatsType getStatsType() {
            return OFStatsType.EXPERIMENTER;
        }

        @Override
        public Set<OFStatsRequestFlags> getFlags() {
            return this.flags;
        }

        @Override
        public OFBsnVrfCounterStatsRequest.Builder setFlags(Set<OFStatsRequestFlags> flags) {
            this.flags = flags;
            this.flagsSet = true;
            return this;
        }

        @Override
        public long getExperimenter() {
            return 6035143L;
        }

        @Override
        public long getSubtype() {
            return 15L;
        }

        @Override
        public long getVrf() {
            return this.vrf;
        }

        @Override
        public OFBsnVrfCounterStatsRequest.Builder setVrf(long vrf) {
            this.vrf = vrf;
            this.vrfSet = true;
            return this;
        }

        @Override
        public OFBsnVrfCounterStatsRequest build() {
            Set flags;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            Set set = flags = this.flagsSet ? this.flags : this.parentMessage.flags;
            if (flags == null) {
                throw new NullPointerException("Property flags must not be null");
            }
            long vrf = this.vrfSet ? this.vrf : this.parentMessage.vrf;
            return new OFBsnVrfCounterStatsRequestVer13(xid, flags, vrf);
        }
    }
}

