/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.List;
import java.util.Set;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFExpPortAdjacency;
import org.projectfloodlight.openflow.protocol.OFExpPortAdjacencyId;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFPortConfig;
import org.projectfloodlight.openflow.protocol.OFPortState;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver13.OFExpPortAdjacencyIdVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFPortConfigSerializerVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFPortStateSerializerVer13;
import org.projectfloodlight.openflow.types.MacAddress;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFExpPortAdjacencyVer13
implements OFExpPortAdjacency {
    private static final Logger logger = LoggerFactory.getLogger(OFExpPortAdjacencyVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int MINIMUM_LENGTH = 40;
    private static final OFPort DEFAULT_PORT_NO = OFPort.ANY;
    private static final MacAddress DEFAULT_HW_ADDR = MacAddress.NONE;
    private static final String DEFAULT_NAME = "";
    private static final Set<OFPortConfig> DEFAULT_CONFIG = ImmutableSet.of();
    private static final Set<OFPortState> DEFAULT_STATE = ImmutableSet.of();
    private static final List<OFExpPortAdjacencyId> DEFAULT_PROPERTIES = ImmutableList.of();
    private final OFPort portNo;
    private final MacAddress hwAddr;
    private final String name;
    private final Set<OFPortConfig> config;
    private final Set<OFPortState> state;
    private final List<OFExpPortAdjacencyId> properties;
    static final OFExpPortAdjacencyVer13 DEFAULT = new OFExpPortAdjacencyVer13(DEFAULT_PORT_NO, DEFAULT_HW_ADDR, "", DEFAULT_CONFIG, DEFAULT_STATE, DEFAULT_PROPERTIES);
    static final Reader READER = new Reader();
    static final OFExpPortAdjacencyVer13Funnel FUNNEL = new OFExpPortAdjacencyVer13Funnel();
    static final Writer WRITER = new Writer();

    OFExpPortAdjacencyVer13(OFPort portNo, MacAddress hwAddr, String name, Set<OFPortConfig> config, Set<OFPortState> state, List<OFExpPortAdjacencyId> properties) {
        if (portNo == null) {
            throw new NullPointerException("OFExpPortAdjacencyVer13: property portNo cannot be null");
        }
        if (hwAddr == null) {
            throw new NullPointerException("OFExpPortAdjacencyVer13: property hwAddr cannot be null");
        }
        if (name == null) {
            throw new NullPointerException("OFExpPortAdjacencyVer13: property name cannot be null");
        }
        if (config == null) {
            throw new NullPointerException("OFExpPortAdjacencyVer13: property config cannot be null");
        }
        if (state == null) {
            throw new NullPointerException("OFExpPortAdjacencyVer13: property state cannot be null");
        }
        if (properties == null) {
            throw new NullPointerException("OFExpPortAdjacencyVer13: property properties cannot be null");
        }
        this.portNo = portNo;
        this.hwAddr = hwAddr;
        this.name = name;
        this.config = config;
        this.state = state;
        this.properties = properties;
    }

    @Override
    public OFPort getPortNo() {
        return this.portNo;
    }

    @Override
    public MacAddress getHwAddr() {
        return this.hwAddr;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Set<OFPortConfig> getConfig() {
        return this.config;
    }

    @Override
    public Set<OFPortState> getState() {
        return this.state;
    }

    @Override
    public List<OFExpPortAdjacencyId> getProperties() {
        return this.properties;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFExpPortAdjacency.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFExpPortAdjacencyVer13(");
        b.append("portNo=").append(this.portNo);
        b.append(", ");
        b.append("hwAddr=").append(this.hwAddr);
        b.append(", ");
        b.append("name=").append(this.name);
        b.append(", ");
        b.append("config=").append(this.config);
        b.append(", ");
        b.append("state=").append(this.state);
        b.append(", ");
        b.append("properties=").append(this.properties);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFExpPortAdjacencyVer13 other = (OFExpPortAdjacencyVer13)obj;
        if (this.portNo == null ? other.portNo != null : !this.portNo.equals(other.portNo)) {
            return false;
        }
        if (this.hwAddr == null ? other.hwAddr != null : !this.hwAddr.equals(other.hwAddr)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.config == null ? other.config != null : !this.config.equals(other.config)) {
            return false;
        }
        if (this.state == null ? other.state != null : !this.state.equals(other.state)) {
            return false;
        }
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.portNo == null ? 0 : this.portNo.hashCode());
        result = 31 * result + (this.hwAddr == null ? 0 : this.hwAddr.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.config == null ? 0 : this.config.hashCode());
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFExpPortAdjacencyVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFExpPortAdjacencyVer13 message) {
            int startIndex = bb.writerIndex();
            message.portNo.write4Bytes(bb);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeZero(2);
            message.hwAddr.write6Bytes(bb);
            bb.writeZero(2);
            ChannelUtils.writeFixedLengthString(bb, message.name, 16);
            OFPortConfigSerializerVer13.writeTo(bb, message.config);
            OFPortStateSerializerVer13.writeTo(bb, message.state);
            ChannelUtils.writeList(bb, message.properties);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFExpPortAdjacencyVer13Funnel
    implements Funnel<OFExpPortAdjacencyVer13> {
        private static final long serialVersionUID = 1L;

        OFExpPortAdjacencyVer13Funnel() {
        }

        public void funnel(OFExpPortAdjacencyVer13 message, PrimitiveSink sink) {
            message.portNo.putTo(sink);
            message.hwAddr.putTo(sink);
            sink.putUnencodedChars((CharSequence)message.name);
            OFPortConfigSerializerVer13.putTo(message.config, sink);
            OFPortStateSerializerVer13.putTo(message.state, sink);
            FunnelUtils.putList(message.properties, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFExpPortAdjacency> {
        Reader() {
        }

        @Override
        public OFExpPortAdjacency readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            OFPort portNo = OFPort.read4Bytes(bb);
            int length = U16.f(bb.readShort());
            if (length < 40) {
                throw new OFParseError("Wrong length: Expected to be >= 40, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            bb.skipBytes(2);
            MacAddress hwAddr = MacAddress.read6Bytes(bb);
            bb.skipBytes(2);
            String name = ChannelUtils.readFixedLengthString(bb, 16);
            Set<OFPortConfig> config = OFPortConfigSerializerVer13.readFrom(bb);
            Set<OFPortState> state = OFPortStateSerializerVer13.readFrom(bb);
            List<OFExpPortAdjacencyId> properties = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFExpPortAdjacencyIdVer13.READER);
            OFExpPortAdjacencyVer13 expPortAdjacencyVer13 = new OFExpPortAdjacencyVer13(portNo, hwAddr, name, config, state, properties);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)expPortAdjacencyVer13);
            }
            return expPortAdjacencyVer13;
        }
    }

    static class Builder
    implements OFExpPortAdjacency.Builder {
        private boolean portNoSet;
        private OFPort portNo;
        private boolean hwAddrSet;
        private MacAddress hwAddr;
        private boolean nameSet;
        private String name;
        private boolean configSet;
        private Set<OFPortConfig> config;
        private boolean stateSet;
        private Set<OFPortState> state;
        private boolean propertiesSet;
        private List<OFExpPortAdjacencyId> properties;

        Builder() {
        }

        @Override
        public OFPort getPortNo() {
            return this.portNo;
        }

        @Override
        public OFExpPortAdjacency.Builder setPortNo(OFPort portNo) {
            this.portNo = portNo;
            this.portNoSet = true;
            return this;
        }

        @Override
        public MacAddress getHwAddr() {
            return this.hwAddr;
        }

        @Override
        public OFExpPortAdjacency.Builder setHwAddr(MacAddress hwAddr) {
            this.hwAddr = hwAddr;
            this.hwAddrSet = true;
            return this;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public OFExpPortAdjacency.Builder setName(String name) {
            this.name = name;
            this.nameSet = true;
            return this;
        }

        @Override
        public Set<OFPortConfig> getConfig() {
            return this.config;
        }

        @Override
        public OFExpPortAdjacency.Builder setConfig(Set<OFPortConfig> config) {
            this.config = config;
            this.configSet = true;
            return this;
        }

        @Override
        public Set<OFPortState> getState() {
            return this.state;
        }

        @Override
        public OFExpPortAdjacency.Builder setState(Set<OFPortState> state) {
            this.state = state;
            this.stateSet = true;
            return this;
        }

        @Override
        public List<OFExpPortAdjacencyId> getProperties() {
            return this.properties;
        }

        @Override
        public OFExpPortAdjacency.Builder setProperties(List<OFExpPortAdjacencyId> properties) {
            this.properties = properties;
            this.propertiesSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFExpPortAdjacency build() {
            List<OFExpPortAdjacencyId> properties;
            Set<OFPortState> state;
            Set<OFPortConfig> config;
            String name;
            MacAddress hwAddr;
            OFPort portNo;
            OFPort oFPort = portNo = this.portNoSet ? this.portNo : DEFAULT_PORT_NO;
            if (portNo == null) {
                throw new NullPointerException("Property portNo must not be null");
            }
            MacAddress macAddress = hwAddr = this.hwAddrSet ? this.hwAddr : DEFAULT_HW_ADDR;
            if (hwAddr == null) {
                throw new NullPointerException("Property hwAddr must not be null");
            }
            String string = name = this.nameSet ? this.name : OFExpPortAdjacencyVer13.DEFAULT_NAME;
            if (name == null) {
                throw new NullPointerException("Property name must not be null");
            }
            Set<OFPortConfig> set = config = this.configSet ? this.config : DEFAULT_CONFIG;
            if (config == null) {
                throw new NullPointerException("Property config must not be null");
            }
            Set<OFPortState> set2 = state = this.stateSet ? this.state : DEFAULT_STATE;
            if (state == null) {
                throw new NullPointerException("Property state must not be null");
            }
            List<OFExpPortAdjacencyId> list = properties = this.propertiesSet ? this.properties : DEFAULT_PROPERTIES;
            if (properties == null) {
                throw new NullPointerException("Property properties must not be null");
            }
            return new OFExpPortAdjacencyVer13(portNo, hwAddr, name, config, state, properties);
        }
    }

    static class BuilderWithParent
    implements OFExpPortAdjacency.Builder {
        final OFExpPortAdjacencyVer13 parentMessage;
        private boolean portNoSet;
        private OFPort portNo;
        private boolean hwAddrSet;
        private MacAddress hwAddr;
        private boolean nameSet;
        private String name;
        private boolean configSet;
        private Set<OFPortConfig> config;
        private boolean stateSet;
        private Set<OFPortState> state;
        private boolean propertiesSet;
        private List<OFExpPortAdjacencyId> properties;

        BuilderWithParent(OFExpPortAdjacencyVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFPort getPortNo() {
            return this.portNo;
        }

        @Override
        public OFExpPortAdjacency.Builder setPortNo(OFPort portNo) {
            this.portNo = portNo;
            this.portNoSet = true;
            return this;
        }

        @Override
        public MacAddress getHwAddr() {
            return this.hwAddr;
        }

        @Override
        public OFExpPortAdjacency.Builder setHwAddr(MacAddress hwAddr) {
            this.hwAddr = hwAddr;
            this.hwAddrSet = true;
            return this;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public OFExpPortAdjacency.Builder setName(String name) {
            this.name = name;
            this.nameSet = true;
            return this;
        }

        @Override
        public Set<OFPortConfig> getConfig() {
            return this.config;
        }

        @Override
        public OFExpPortAdjacency.Builder setConfig(Set<OFPortConfig> config) {
            this.config = config;
            this.configSet = true;
            return this;
        }

        @Override
        public Set<OFPortState> getState() {
            return this.state;
        }

        @Override
        public OFExpPortAdjacency.Builder setState(Set<OFPortState> state) {
            this.state = state;
            this.stateSet = true;
            return this;
        }

        @Override
        public List<OFExpPortAdjacencyId> getProperties() {
            return this.properties;
        }

        @Override
        public OFExpPortAdjacency.Builder setProperties(List<OFExpPortAdjacencyId> properties) {
            this.properties = properties;
            this.propertiesSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFExpPortAdjacency build() {
            List properties;
            Set state;
            Set config;
            String name;
            MacAddress hwAddr;
            OFPort portNo;
            OFPort oFPort = portNo = this.portNoSet ? this.portNo : this.parentMessage.portNo;
            if (portNo == null) {
                throw new NullPointerException("Property portNo must not be null");
            }
            MacAddress macAddress = hwAddr = this.hwAddrSet ? this.hwAddr : this.parentMessage.hwAddr;
            if (hwAddr == null) {
                throw new NullPointerException("Property hwAddr must not be null");
            }
            String string = name = this.nameSet ? this.name : this.parentMessage.name;
            if (name == null) {
                throw new NullPointerException("Property name must not be null");
            }
            Set set = config = this.configSet ? this.config : this.parentMessage.config;
            if (config == null) {
                throw new NullPointerException("Property config must not be null");
            }
            Set set2 = state = this.stateSet ? this.state : this.parentMessage.state;
            if (state == null) {
                throw new NullPointerException("Property state must not be null");
            }
            List list = properties = this.propertiesSet ? this.properties : this.parentMessage.properties;
            if (properties == null) {
                throw new NullPointerException("Property properties must not be null");
            }
            return new OFExpPortAdjacencyVer13(portNo, hwAddr, name, config, state, properties);
        }
    }
}

