/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFOplinkChannelPower;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOplinkChannelPowerVer13
implements OFOplinkChannelPower {
    private static final Logger logger = LoggerFactory.getLogger(OFOplinkChannelPowerVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 8;
    private static final int DEFAULT_IN_PORT = 0;
    private static final int DEFAULT_OUT_PORT = 0;
    private static final int DEFAULT_CHANNEL = 0;
    private static final int DEFAULT_POWER_VALUE = 0;
    private final int inPort;
    private final int outPort;
    private final int channel;
    private final int powerValue;
    static final OFOplinkChannelPowerVer13 DEFAULT = new OFOplinkChannelPowerVer13(0, 0, 0, 0);
    static final Reader READER = new Reader();
    static final OFOplinkChannelPowerVer13Funnel FUNNEL = new OFOplinkChannelPowerVer13Funnel();
    static final Writer WRITER = new Writer();

    OFOplinkChannelPowerVer13(int inPort, int outPort, int channel, int powerValue) {
        this.inPort = inPort;
        this.outPort = outPort;
        this.channel = channel;
        this.powerValue = powerValue;
    }

    @Override
    public int getInPort() {
        return this.inPort;
    }

    @Override
    public int getOutPort() {
        return this.outPort;
    }

    @Override
    public int getChannel() {
        return this.channel;
    }

    @Override
    public int getPowerValue() {
        return this.powerValue;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFOplinkChannelPower.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOplinkChannelPowerVer13(");
        b.append("inPort=").append(this.inPort);
        b.append(", ");
        b.append("outPort=").append(this.outPort);
        b.append(", ");
        b.append("channel=").append(this.channel);
        b.append(", ");
        b.append("powerValue=").append(this.powerValue);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOplinkChannelPowerVer13 other = (OFOplinkChannelPowerVer13)obj;
        if (this.inPort != other.inPort) {
            return false;
        }
        if (this.outPort != other.outPort) {
            return false;
        }
        if (this.channel != other.channel) {
            return false;
        }
        return this.powerValue == other.powerValue;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.inPort;
        result = 31 * result + this.outPort;
        result = 31 * result + this.channel;
        result = 31 * result + this.powerValue;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOplinkChannelPowerVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFOplinkChannelPowerVer13 message) {
            bb.writeShort((int)U16.t(message.inPort));
            bb.writeShort((int)U16.t(message.outPort));
            bb.writeShort((int)U16.t(message.channel));
            bb.writeShort((int)U16.t(message.powerValue));
        }
    }

    static class OFOplinkChannelPowerVer13Funnel
    implements Funnel<OFOplinkChannelPowerVer13> {
        private static final long serialVersionUID = 1L;

        OFOplinkChannelPowerVer13Funnel() {
        }

        public void funnel(OFOplinkChannelPowerVer13 message, PrimitiveSink sink) {
            sink.putInt(message.inPort);
            sink.putInt(message.outPort);
            sink.putInt(message.channel);
            sink.putInt(message.powerValue);
        }
    }

    static class Reader
    implements OFMessageReader<OFOplinkChannelPower> {
        Reader() {
        }

        @Override
        public OFOplinkChannelPower readFrom(ChannelBuffer bb) throws OFParseError {
            int inPort = U16.f(bb.readShort());
            int outPort = U16.f(bb.readShort());
            int channel = U16.f(bb.readShort());
            int powerValue = U16.f(bb.readShort());
            OFOplinkChannelPowerVer13 oplinkChannelPowerVer13 = new OFOplinkChannelPowerVer13(inPort, outPort, channel, powerValue);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oplinkChannelPowerVer13);
            }
            return oplinkChannelPowerVer13;
        }
    }

    static class Builder
    implements OFOplinkChannelPower.Builder {
        private boolean inPortSet;
        private int inPort;
        private boolean outPortSet;
        private int outPort;
        private boolean channelSet;
        private int channel;
        private boolean powerValueSet;
        private int powerValue;

        Builder() {
        }

        @Override
        public int getInPort() {
            return this.inPort;
        }

        @Override
        public OFOplinkChannelPower.Builder setInPort(int inPort) {
            this.inPort = inPort;
            this.inPortSet = true;
            return this;
        }

        @Override
        public int getOutPort() {
            return this.outPort;
        }

        @Override
        public OFOplinkChannelPower.Builder setOutPort(int outPort) {
            this.outPort = outPort;
            this.outPortSet = true;
            return this;
        }

        @Override
        public int getChannel() {
            return this.channel;
        }

        @Override
        public OFOplinkChannelPower.Builder setChannel(int channel) {
            this.channel = channel;
            this.channelSet = true;
            return this;
        }

        @Override
        public int getPowerValue() {
            return this.powerValue;
        }

        @Override
        public OFOplinkChannelPower.Builder setPowerValue(int powerValue) {
            this.powerValue = powerValue;
            this.powerValueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOplinkChannelPower build() {
            int inPort = this.inPortSet ? this.inPort : 0;
            int outPort = this.outPortSet ? this.outPort : 0;
            int channel = this.channelSet ? this.channel : 0;
            int powerValue = this.powerValueSet ? this.powerValue : 0;
            return new OFOplinkChannelPowerVer13(inPort, outPort, channel, powerValue);
        }
    }

    static class BuilderWithParent
    implements OFOplinkChannelPower.Builder {
        final OFOplinkChannelPowerVer13 parentMessage;
        private boolean inPortSet;
        private int inPort;
        private boolean outPortSet;
        private int outPort;
        private boolean channelSet;
        private int channel;
        private boolean powerValueSet;
        private int powerValue;

        BuilderWithParent(OFOplinkChannelPowerVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getInPort() {
            return this.inPort;
        }

        @Override
        public OFOplinkChannelPower.Builder setInPort(int inPort) {
            this.inPort = inPort;
            this.inPortSet = true;
            return this;
        }

        @Override
        public int getOutPort() {
            return this.outPort;
        }

        @Override
        public OFOplinkChannelPower.Builder setOutPort(int outPort) {
            this.outPort = outPort;
            this.outPortSet = true;
            return this;
        }

        @Override
        public int getChannel() {
            return this.channel;
        }

        @Override
        public OFOplinkChannelPower.Builder setChannel(int channel) {
            this.channel = channel;
            this.channelSet = true;
            return this;
        }

        @Override
        public int getPowerValue() {
            return this.powerValue;
        }

        @Override
        public OFOplinkChannelPower.Builder setPowerValue(int powerValue) {
            this.powerValue = powerValue;
            this.powerValueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOplinkChannelPower build() {
            int inPort = this.inPortSet ? this.inPort : this.parentMessage.inPort;
            int outPort = this.outPortSet ? this.outPort : this.parentMessage.outPort;
            int channel = this.channelSet ? this.channel : this.parentMessage.channel;
            int powerValue = this.powerValueSet ? this.powerValue : this.parentMessage.powerValue;
            return new OFOplinkChannelPowerVer13(inPort, outPort, channel, powerValue);
        }
    }
}

