/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmExpOchSigtype;
import org.projectfloodlight.openflow.types.U8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmExpOchSigtypeVer13
implements OFOxmExpOchSigtype {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmExpOchSigtypeVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 9;
    private static final U8 DEFAULT_VALUE = U8.ZERO;
    private final U8 value;
    static final OFOxmExpOchSigtypeVer13 DEFAULT = new OFOxmExpOchSigtypeVer13(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmExpOchSigtypeVer13Funnel FUNNEL = new OFOxmExpOchSigtypeVer13Funnel();
    static final Writer WRITER = new Writer();

    OFOxmExpOchSigtypeVer13(U8 value) {
        if (value == null) {
            throw new NullPointerException("OFOxmExpOchSigtypeVer13: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 4294903809L;
    }

    @Override
    public long getExperimenter() {
        return 0xFF000007L;
    }

    @Override
    public U8 getValue() {
        return this.value;
    }

    @Override
    public MatchField<U8> getMatchField() {
        return MatchField.EXP_OCH_SIGTYPE;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<U8> getCanonical() {
        return this;
    }

    @Override
    public U8 getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.3");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFOxmExpOchSigtype.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmExpOchSigtypeVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmExpOchSigtypeVer13 other = (OFOxmExpOchSigtypeVer13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmExpOchSigtypeVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFOxmExpOchSigtypeVer13 message) {
            bb.writeInt(-63487);
            bb.writeInt(-16777209);
            bb.writeByte((int)message.value.getRaw());
        }
    }

    static class OFOxmExpOchSigtypeVer13Funnel
    implements Funnel<OFOxmExpOchSigtypeVer13> {
        private static final long serialVersionUID = 1L;

        OFOxmExpOchSigtypeVer13Funnel() {
        }

        public void funnel(OFOxmExpOchSigtypeVer13 message, PrimitiveSink sink) {
            sink.putInt(-63487);
            sink.putInt(-16777209);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmExpOchSigtype> {
        Reader() {
        }

        @Override
        public OFOxmExpOchSigtype readFrom(ChannelBuffer bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -63487) {
                throw new OFParseError("Wrong typeLen: Expected=0xffff0801L(0xffff0801L), got=" + typeLen);
            }
            int experimenter = bb.readInt();
            if (experimenter != -16777209) {
                throw new OFParseError("Wrong experimenter: Expected=0xff000007L(0xff000007L), got=" + experimenter);
            }
            U8 value = U8.of(bb.readByte());
            OFOxmExpOchSigtypeVer13 oxmExpOchSigtypeVer13 = new OFOxmExpOchSigtypeVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmExpOchSigtypeVer13);
            }
            return oxmExpOchSigtypeVer13;
        }
    }

    static class Builder
    implements OFOxmExpOchSigtype.Builder {
        private boolean valueSet;
        private U8 value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 4294903809L;
        }

        @Override
        public long getExperimenter() {
            return 0xFF000007L;
        }

        @Override
        public U8 getValue() {
            return this.value;
        }

        @Override
        public OFOxmExpOchSigtype.Builder setValue(U8 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U8> getMatchField() {
            return MatchField.EXP_OCH_SIGTYPE;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U8> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public U8 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmExpOchSigtype build() {
            U8 value;
            U8 u8 = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmExpOchSigtypeVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmExpOchSigtype.Builder {
        final OFOxmExpOchSigtypeVer13 parentMessage;
        private boolean valueSet;
        private U8 value;

        BuilderWithParent(OFOxmExpOchSigtypeVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 4294903809L;
        }

        @Override
        public long getExperimenter() {
            return 0xFF000007L;
        }

        @Override
        public U8 getValue() {
            return this.value;
        }

        @Override
        public OFOxmExpOchSigtype.Builder setValue(U8 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U8> getMatchField() {
            return MatchField.EXP_OCH_SIGTYPE;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U8> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public U8 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmExpOchSigtype build() {
            U8 value;
            U8 u8 = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmExpOchSigtypeVer13(value);
        }
    }
}

