/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmExpOduSigId;
import org.projectfloodlight.openflow.types.OduSignalID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmExpOduSigIdVer13
implements OFOxmExpOduSigId {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmExpOduSigIdVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 24;
    private static final OduSignalID DEFAULT_VALUE = OduSignalID.DEFAULT;
    private final OduSignalID value;
    static final OFOxmExpOduSigIdVer13 DEFAULT = new OFOxmExpOduSigIdVer13(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmExpOduSigIdVer13Funnel FUNNEL = new OFOxmExpOduSigIdVer13Funnel();
    static final Writer WRITER = new Writer();

    OFOxmExpOduSigIdVer13(OduSignalID value) {
        if (value == null) {
            throw new NullPointerException("OFOxmExpOduSigIdVer13: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 4294903312L;
    }

    @Override
    public long getExperimenter() {
        return 0xFF000007L;
    }

    @Override
    public OduSignalID getValue() {
        return this.value;
    }

    @Override
    public MatchField<OduSignalID> getMatchField() {
        return MatchField.EXP_ODU_SIG_ID;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<OduSignalID> getCanonical() {
        return this;
    }

    @Override
    public OduSignalID getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.3");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFOxmExpOduSigId.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmExpOduSigIdVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmExpOduSigIdVer13 other = (OFOxmExpOduSigIdVer13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmExpOduSigIdVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFOxmExpOduSigIdVer13 message) {
            bb.writeInt(-63984);
            bb.writeInt(-16777209);
            message.value.writeTo(bb);
        }
    }

    static class OFOxmExpOduSigIdVer13Funnel
    implements Funnel<OFOxmExpOduSigIdVer13> {
        private static final long serialVersionUID = 1L;

        OFOxmExpOduSigIdVer13Funnel() {
        }

        public void funnel(OFOxmExpOduSigIdVer13 message, PrimitiveSink sink) {
            sink.putInt(-63984);
            sink.putInt(-16777209);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmExpOduSigId> {
        Reader() {
        }

        @Override
        public OFOxmExpOduSigId readFrom(ChannelBuffer bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -63984) {
                throw new OFParseError("Wrong typeLen: Expected=0xffff0610L(0xffff0610L), got=" + typeLen);
            }
            int experimenter = bb.readInt();
            if (experimenter != -16777209) {
                throw new OFParseError("Wrong experimenter: Expected=0xff000007L(0xff000007L), got=" + experimenter);
            }
            OduSignalID value = OduSignalID.readFrom(bb);
            OFOxmExpOduSigIdVer13 oxmExpOduSigIdVer13 = new OFOxmExpOduSigIdVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmExpOduSigIdVer13);
            }
            return oxmExpOduSigIdVer13;
        }
    }

    static class Builder
    implements OFOxmExpOduSigId.Builder {
        private boolean valueSet;
        private OduSignalID value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 4294903312L;
        }

        @Override
        public long getExperimenter() {
            return 0xFF000007L;
        }

        @Override
        public OduSignalID getValue() {
            return this.value;
        }

        @Override
        public OFOxmExpOduSigId.Builder setValue(OduSignalID value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<OduSignalID> getMatchField() {
            return MatchField.EXP_ODU_SIG_ID;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<OduSignalID> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public OduSignalID getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmExpOduSigId build() {
            OduSignalID value;
            OduSignalID oduSignalID = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmExpOduSigIdVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmExpOduSigId.Builder {
        final OFOxmExpOduSigIdVer13 parentMessage;
        private boolean valueSet;
        private OduSignalID value;

        BuilderWithParent(OFOxmExpOduSigIdVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 4294903312L;
        }

        @Override
        public long getExperimenter() {
            return 0xFF000007L;
        }

        @Override
        public OduSignalID getValue() {
            return this.value;
        }

        @Override
        public OFOxmExpOduSigId.Builder setValue(OduSignalID value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<OduSignalID> getMatchField() {
            return MatchField.EXP_ODU_SIG_ID;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<OduSignalID> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public OduSignalID getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmExpOduSigId build() {
            OduSignalID value;
            OduSignalID oduSignalID = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmExpOduSigIdVer13(value);
        }
    }
}

