/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFActionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFActionNiciraPopNsh;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFActionNiciraPopNshVer14
implements OFActionNiciraPopNsh {
    private static final Logger logger = LoggerFactory.getLogger(OFActionNiciraPopNshVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 16;
    static final OFActionNiciraPopNshVer14 DEFAULT = new OFActionNiciraPopNshVer14();
    static final OFActionNiciraPopNshVer14 INSTANCE = new OFActionNiciraPopNshVer14();
    static final Reader READER = new Reader();
    static final OFActionNiciraPopNshVer14Funnel FUNNEL = new OFActionNiciraPopNshVer14Funnel();
    static final Writer WRITER = new Writer();

    private OFActionNiciraPopNshVer14() {
    }

    @Override
    public OFActionType getType() {
        return OFActionType.EXPERIMENTER;
    }

    @Override
    public long getExperimenter() {
        return 8992L;
    }

    @Override
    public int getSubtype() {
        return 39;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFActionNiciraPopNsh.Builder createBuilder() {
        throw new UnsupportedOperationException("OFActionNiciraPopNshVer14 has no mutable properties -- builder unneeded");
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFActionNiciraPopNshVer14(");
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFActionNiciraPopNshVer14> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFActionNiciraPopNshVer14 message) {
            bb.writeShort(-1);
            bb.writeShort(16);
            bb.writeInt(8992);
            bb.writeShort(39);
            bb.writeZero(2);
            bb.writeZero(4);
        }
    }

    static class OFActionNiciraPopNshVer14Funnel
    implements Funnel<OFActionNiciraPopNshVer14> {
        private static final long serialVersionUID = 1L;

        OFActionNiciraPopNshVer14Funnel() {
        }

        public void funnel(OFActionNiciraPopNshVer14 message, PrimitiveSink sink) {
            sink.putShort((short)-1);
            sink.putShort((short)16);
            sink.putInt(8992);
            sink.putShort((short)39);
        }
    }

    static class Reader
    implements OFMessageReader<OFActionNiciraPopNsh> {
        Reader() {
        }

        @Override
        public OFActionNiciraPopNsh readFrom(ChannelBuffer bb) throws OFParseError {
            int experimenter;
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != -1) {
                throw new OFParseError("Wrong type: Expected=OFActionType.EXPERIMENTER(65535), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 16) {
                throw new OFParseError("Wrong length: Expected=16(16), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            if ((experimenter = bb.readInt()) != 8992) {
                throw new OFParseError("Wrong experimenter: Expected=0x2320L(0x2320L), got=" + experimenter);
            }
            short subtype = bb.readShort();
            if (subtype != 39) {
                throw new OFParseError("Wrong subtype: Expected=0x27(0x27), got=" + subtype);
            }
            bb.skipBytes(2);
            bb.skipBytes(4);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - returning shared instance={}", (Object)INSTANCE);
            }
            return INSTANCE;
        }
    }
}

