/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.Arrays;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvName;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvNameVer14
implements OFBsnTlvName {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvNameVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int MINIMUM_LENGTH = 4;
    private static final byte[] DEFAULT_VALUE = new byte[0];
    private final byte[] value;
    static final OFBsnTlvNameVer14 DEFAULT = new OFBsnTlvNameVer14(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFBsnTlvNameVer14Funnel FUNNEL = new OFBsnTlvNameVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvNameVer14(byte[] value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvNameVer14: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 52;
    }

    @Override
    public byte[] getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnTlvName.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvNameVer14(");
        b.append("value=").append(Arrays.toString(this.value));
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvNameVer14 other = (OFBsnTlvNameVer14)obj;
        return Arrays.equals(this.value, other.value);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.value);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvNameVer14> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFBsnTlvNameVer14 message) {
            int startIndex = bb.writerIndex();
            bb.writeShort(52);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeBytes(message.value);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFBsnTlvNameVer14Funnel
    implements Funnel<OFBsnTlvNameVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvNameVer14Funnel() {
        }

        public void funnel(OFBsnTlvNameVer14 message, PrimitiveSink sink) {
            sink.putShort((short)52);
            sink.putBytes(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvName> {
        Reader() {
        }

        @Override
        public OFBsnTlvName readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 52) {
                throw new OFParseError("Wrong type: Expected=0x34(0x34), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 4) {
                throw new OFParseError("Wrong length: Expected to be >= 4, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            byte[] value = ChannelUtils.readBytes(bb, length - (bb.readerIndex() - start));
            OFBsnTlvNameVer14 bsnTlvNameVer14 = new OFBsnTlvNameVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvNameVer14);
            }
            return bsnTlvNameVer14;
        }
    }

    static class Builder
    implements OFBsnTlvName.Builder {
        private boolean valueSet;
        private byte[] value;

        Builder() {
        }

        @Override
        public int getType() {
            return 52;
        }

        @Override
        public byte[] getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvName.Builder setValue(byte[] value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvName build() {
            byte[] value;
            byte[] byArray = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvNameVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvName.Builder {
        final OFBsnTlvNameVer14 parentMessage;
        private boolean valueSet;
        private byte[] value;

        BuilderWithParent(OFBsnTlvNameVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 52;
        }

        @Override
        public byte[] getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvName.Builder setValue(byte[] value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvName build() {
            byte[] value;
            byte[] byArray = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvNameVer14(value);
        }
    }
}

