/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvSamplingRate;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvSamplingRateVer14
implements OFBsnTlvSamplingRate {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvSamplingRateVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 8;
    private static final long DEFAULT_VALUE = 0L;
    private final long value;
    static final OFBsnTlvSamplingRateVer14 DEFAULT = new OFBsnTlvSamplingRateVer14(0L);
    static final Reader READER = new Reader();
    static final OFBsnTlvSamplingRateVer14Funnel FUNNEL = new OFBsnTlvSamplingRateVer14Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvSamplingRateVer14(long value) {
        this.value = value;
    }

    @Override
    public int getType() {
        return 30;
    }

    @Override
    public long getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFBsnTlvSamplingRate.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvSamplingRateVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvSamplingRateVer14 other = (OFBsnTlvSamplingRateVer14)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.value ^ this.value >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvSamplingRateVer14> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFBsnTlvSamplingRateVer14 message) {
            bb.writeShort(30);
            bb.writeShort(8);
            bb.writeInt(U32.t(message.value));
        }
    }

    static class OFBsnTlvSamplingRateVer14Funnel
    implements Funnel<OFBsnTlvSamplingRateVer14> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvSamplingRateVer14Funnel() {
        }

        public void funnel(OFBsnTlvSamplingRateVer14 message, PrimitiveSink sink) {
            sink.putShort((short)30);
            sink.putShort((short)8);
            sink.putLong(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvSamplingRate> {
        Reader() {
        }

        @Override
        public OFBsnTlvSamplingRate readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 30) {
                throw new OFParseError("Wrong type: Expected=0x1e(0x1e), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long value = U32.f(bb.readInt());
            OFBsnTlvSamplingRateVer14 bsnTlvSamplingRateVer14 = new OFBsnTlvSamplingRateVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvSamplingRateVer14);
            }
            return bsnTlvSamplingRateVer14;
        }
    }

    static class Builder
    implements OFBsnTlvSamplingRate.Builder {
        private boolean valueSet;
        private long value;

        Builder() {
        }

        @Override
        public int getType() {
            return 30;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvSamplingRate.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvSamplingRate build() {
            long value = this.valueSet ? this.value : 0L;
            return new OFBsnTlvSamplingRateVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvSamplingRate.Builder {
        final OFBsnTlvSamplingRateVer14 parentMessage;
        private boolean valueSet;
        private long value;

        BuilderWithParent(OFBsnTlvSamplingRateVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 30;
        }

        @Override
        public long getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvSamplingRate.Builder setValue(long value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFBsnTlvSamplingRate build() {
            long value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvSamplingRateVer14(value);
        }
    }
}

