/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFInstructionType;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.instruction.OFInstructionWriteMetadata;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFInstructionWriteMetadataVer14
implements OFInstructionWriteMetadata {
    private static final Logger logger = LoggerFactory.getLogger(OFInstructionWriteMetadataVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 24;
    private static final U64 DEFAULT_METADATA = U64.ZERO;
    private static final U64 DEFAULT_METADATA_MASK = U64.ZERO;
    private final U64 metadata;
    private final U64 metadataMask;
    static final OFInstructionWriteMetadataVer14 DEFAULT = new OFInstructionWriteMetadataVer14(DEFAULT_METADATA, DEFAULT_METADATA_MASK);
    static final Reader READER = new Reader();
    static final OFInstructionWriteMetadataVer14Funnel FUNNEL = new OFInstructionWriteMetadataVer14Funnel();
    static final Writer WRITER = new Writer();

    OFInstructionWriteMetadataVer14(U64 metadata, U64 metadataMask) {
        if (metadata == null) {
            throw new NullPointerException("OFInstructionWriteMetadataVer14: property metadata cannot be null");
        }
        if (metadataMask == null) {
            throw new NullPointerException("OFInstructionWriteMetadataVer14: property metadataMask cannot be null");
        }
        this.metadata = metadata;
        this.metadataMask = metadataMask;
    }

    @Override
    public OFInstructionType getType() {
        return OFInstructionType.WRITE_METADATA;
    }

    @Override
    public U64 getMetadata() {
        return this.metadata;
    }

    @Override
    public U64 getMetadataMask() {
        return this.metadataMask;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFInstructionWriteMetadata.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFInstructionWriteMetadataVer14(");
        b.append("metadata=").append(this.metadata);
        b.append(", ");
        b.append("metadataMask=").append(this.metadataMask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFInstructionWriteMetadataVer14 other = (OFInstructionWriteMetadataVer14)obj;
        if (this.metadata == null ? other.metadata != null : !this.metadata.equals(other.metadata)) {
            return false;
        }
        return !(this.metadataMask == null ? other.metadataMask != null : !this.metadataMask.equals(other.metadataMask));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.metadata == null ? 0 : this.metadata.hashCode());
        result = 31 * result + (this.metadataMask == null ? 0 : this.metadataMask.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFInstructionWriteMetadataVer14> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFInstructionWriteMetadataVer14 message) {
            bb.writeShort(2);
            bb.writeShort(24);
            bb.writeZero(4);
            bb.writeLong(message.metadata.getValue());
            bb.writeLong(message.metadataMask.getValue());
        }
    }

    static class OFInstructionWriteMetadataVer14Funnel
    implements Funnel<OFInstructionWriteMetadataVer14> {
        private static final long serialVersionUID = 1L;

        OFInstructionWriteMetadataVer14Funnel() {
        }

        public void funnel(OFInstructionWriteMetadataVer14 message, PrimitiveSink sink) {
            sink.putShort((short)2);
            sink.putShort((short)24);
            message.metadata.putTo(sink);
            message.metadataMask.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFInstructionWriteMetadata> {
        Reader() {
        }

        @Override
        public OFInstructionWriteMetadata readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 2) {
                throw new OFParseError("Wrong type: Expected=OFInstructionType.WRITE_METADATA(2), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 24) {
                throw new OFParseError("Wrong length: Expected=24(24), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            bb.skipBytes(4);
            U64 metadata = U64.ofRaw(bb.readLong());
            U64 metadataMask = U64.ofRaw(bb.readLong());
            OFInstructionWriteMetadataVer14 instructionWriteMetadataVer14 = new OFInstructionWriteMetadataVer14(metadata, metadataMask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)instructionWriteMetadataVer14);
            }
            return instructionWriteMetadataVer14;
        }
    }

    static class Builder
    implements OFInstructionWriteMetadata.Builder {
        private boolean metadataSet;
        private U64 metadata;
        private boolean metadataMaskSet;
        private U64 metadataMask;

        Builder() {
        }

        @Override
        public OFInstructionType getType() {
            return OFInstructionType.WRITE_METADATA;
        }

        @Override
        public U64 getMetadata() {
            return this.metadata;
        }

        @Override
        public OFInstructionWriteMetadata.Builder setMetadata(U64 metadata) {
            this.metadata = metadata;
            this.metadataSet = true;
            return this;
        }

        @Override
        public U64 getMetadataMask() {
            return this.metadataMask;
        }

        @Override
        public OFInstructionWriteMetadata.Builder setMetadataMask(U64 metadataMask) {
            this.metadataMask = metadataMask;
            this.metadataMaskSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFInstructionWriteMetadata build() {
            U64 metadataMask;
            U64 metadata;
            U64 u64 = metadata = this.metadataSet ? this.metadata : DEFAULT_METADATA;
            if (metadata == null) {
                throw new NullPointerException("Property metadata must not be null");
            }
            U64 u642 = metadataMask = this.metadataMaskSet ? this.metadataMask : DEFAULT_METADATA_MASK;
            if (metadataMask == null) {
                throw new NullPointerException("Property metadataMask must not be null");
            }
            return new OFInstructionWriteMetadataVer14(metadata, metadataMask);
        }
    }

    static class BuilderWithParent
    implements OFInstructionWriteMetadata.Builder {
        final OFInstructionWriteMetadataVer14 parentMessage;
        private boolean metadataSet;
        private U64 metadata;
        private boolean metadataMaskSet;
        private U64 metadataMask;

        BuilderWithParent(OFInstructionWriteMetadataVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFInstructionType getType() {
            return OFInstructionType.WRITE_METADATA;
        }

        @Override
        public U64 getMetadata() {
            return this.metadata;
        }

        @Override
        public OFInstructionWriteMetadata.Builder setMetadata(U64 metadata) {
            this.metadata = metadata;
            this.metadataSet = true;
            return this;
        }

        @Override
        public U64 getMetadataMask() {
            return this.metadataMask;
        }

        @Override
        public OFInstructionWriteMetadata.Builder setMetadataMask(U64 metadataMask) {
            this.metadataMask = metadataMask;
            this.metadataMaskSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFInstructionWriteMetadata build() {
            U64 metadataMask;
            U64 metadata;
            U64 u64 = metadata = this.metadataSet ? this.metadata : this.parentMessage.metadata;
            if (metadata == null) {
                throw new NullPointerException("Property metadata must not be null");
            }
            U64 u642 = metadataMask = this.metadataMaskSet ? this.metadataMask : this.parentMessage.metadataMask;
            if (metadataMask == null) {
                throw new NullPointerException("Property metadataMask must not be null");
            }
            return new OFInstructionWriteMetadataVer14(metadata, metadataMask);
        }
    }
}

