/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmEncapEthDstMasked;
import org.projectfloodlight.openflow.protocol.ver14.OFOxmEncapEthDstVer14;
import org.projectfloodlight.openflow.types.MacAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmEncapEthDstMaskedVer14
implements OFOxmEncapEthDstMasked {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmEncapEthDstMaskedVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 16;
    private static final MacAddress DEFAULT_VALUE = MacAddress.NONE;
    private static final MacAddress DEFAULT_VALUE_MASK = MacAddress.NONE;
    private final MacAddress value;
    private final MacAddress mask;
    static final OFOxmEncapEthDstMaskedVer14 DEFAULT = new OFOxmEncapEthDstMaskedVer14(DEFAULT_VALUE, DEFAULT_VALUE_MASK);
    static final Reader READER = new Reader();
    static final OFOxmEncapEthDstMaskedVer14Funnel FUNNEL = new OFOxmEncapEthDstMaskedVer14Funnel();
    static final Writer WRITER = new Writer();

    OFOxmEncapEthDstMaskedVer14(MacAddress value, MacAddress mask) {
        if (value == null) {
            throw new NullPointerException("OFOxmEncapEthDstMaskedVer14: property value cannot be null");
        }
        if (mask == null) {
            throw new NullPointerException("OFOxmEncapEthDstMaskedVer14: property mask cannot be null");
        }
        this.value = value;
        this.mask = mask;
    }

    @Override
    public long getTypeLen() {
        return 128268L;
    }

    @Override
    public MacAddress getValue() {
        return this.value;
    }

    @Override
    public MacAddress getMask() {
        return this.mask;
    }

    @Override
    public MatchField<MacAddress> getMatchField() {
        return MatchField.ENCAP_ETH_DST;
    }

    @Override
    public boolean isMasked() {
        return true;
    }

    @Override
    public OFOxm<MacAddress> getCanonical() {
        if (MacAddress.NO_MASK.equals(this.mask)) {
            return new OFOxmEncapEthDstVer14(this.value);
        }
        if (MacAddress.FULL_MASK.equals(this.mask)) {
            return null;
        }
        return this;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFOxmEncapEthDstMasked.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmEncapEthDstMaskedVer14(");
        b.append("value=").append(this.value);
        b.append(", ");
        b.append("mask=").append(this.mask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmEncapEthDstMaskedVer14 other = (OFOxmEncapEthDstMaskedVer14)obj;
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.mask == null ? other.mask != null : !this.mask.equals(other.mask));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.mask == null ? 0 : this.mask.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmEncapEthDstMaskedVer14> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFOxmEncapEthDstMaskedVer14 message) {
            bb.writeInt(128268);
            message.value.write6Bytes(bb);
            message.mask.write6Bytes(bb);
        }
    }

    static class OFOxmEncapEthDstMaskedVer14Funnel
    implements Funnel<OFOxmEncapEthDstMaskedVer14> {
        private static final long serialVersionUID = 1L;

        OFOxmEncapEthDstMaskedVer14Funnel() {
        }

        public void funnel(OFOxmEncapEthDstMaskedVer14 message, PrimitiveSink sink) {
            sink.putInt(128268);
            message.value.putTo(sink);
            message.mask.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmEncapEthDstMasked> {
        Reader() {
        }

        @Override
        public OFOxmEncapEthDstMasked readFrom(ChannelBuffer bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 128268) {
                throw new OFParseError("Wrong typeLen: Expected=0x1f50cL(0x1f50cL), got=" + typeLen);
            }
            MacAddress value = MacAddress.read6Bytes(bb);
            MacAddress mask = MacAddress.read6Bytes(bb);
            OFOxmEncapEthDstMaskedVer14 oxmEncapEthDstMaskedVer14 = new OFOxmEncapEthDstMaskedVer14(value, mask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmEncapEthDstMaskedVer14);
            }
            return oxmEncapEthDstMaskedVer14;
        }
    }

    static class Builder
    implements OFOxmEncapEthDstMasked.Builder {
        private boolean valueSet;
        private MacAddress value;
        private boolean maskSet;
        private MacAddress mask;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 128268L;
        }

        @Override
        public MacAddress getValue() {
            return this.value;
        }

        @Override
        public OFOxmEncapEthDstMasked.Builder setValue(MacAddress value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MacAddress getMask() {
            return this.mask;
        }

        @Override
        public OFOxmEncapEthDstMasked.Builder setMask(MacAddress mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<MacAddress> getMatchField() {
            return MatchField.ENCAP_ETH_DST;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<MacAddress> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmEncapEthDstMasked build() {
            MacAddress mask;
            MacAddress value;
            MacAddress macAddress = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            MacAddress macAddress2 = mask = this.maskSet ? this.mask : DEFAULT_VALUE_MASK;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmEncapEthDstMaskedVer14(value, mask);
        }
    }

    static class BuilderWithParent
    implements OFOxmEncapEthDstMasked.Builder {
        final OFOxmEncapEthDstMaskedVer14 parentMessage;
        private boolean valueSet;
        private MacAddress value;
        private boolean maskSet;
        private MacAddress mask;

        BuilderWithParent(OFOxmEncapEthDstMaskedVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 128268L;
        }

        @Override
        public MacAddress getValue() {
            return this.value;
        }

        @Override
        public OFOxmEncapEthDstMasked.Builder setValue(MacAddress value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MacAddress getMask() {
            return this.mask;
        }

        @Override
        public OFOxmEncapEthDstMasked.Builder setMask(MacAddress mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<MacAddress> getMatchField() {
            return MatchField.ENCAP_ETH_DST;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<MacAddress> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmEncapEthDstMasked build() {
            MacAddress mask;
            MacAddress value;
            MacAddress macAddress = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            MacAddress macAddress2 = mask = this.maskSet ? this.mask : this.parentMessage.mask;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmEncapEthDstMaskedVer14(value, mask);
        }
    }
}

