/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmIpv6NdSll;
import org.projectfloodlight.openflow.types.MacAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmIpv6NdSllVer14
implements OFOxmIpv6NdSll {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmIpv6NdSllVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 10;
    private static final MacAddress DEFAULT_VALUE = MacAddress.NONE;
    private final MacAddress value;
    static final OFOxmIpv6NdSllVer14 DEFAULT = new OFOxmIpv6NdSllVer14(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmIpv6NdSllVer14Funnel FUNNEL = new OFOxmIpv6NdSllVer14Funnel();
    static final Writer WRITER = new Writer();

    OFOxmIpv6NdSllVer14(MacAddress value) {
        if (value == null) {
            throw new NullPointerException("OFOxmIpv6NdSllVer14: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 2147500038L;
    }

    @Override
    public MacAddress getValue() {
        return this.value;
    }

    @Override
    public MatchField<MacAddress> getMatchField() {
        return MatchField.IPV6_ND_SLL;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<MacAddress> getCanonical() {
        return this;
    }

    @Override
    public MacAddress getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.4");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFOxmIpv6NdSll.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmIpv6NdSllVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmIpv6NdSllVer14 other = (OFOxmIpv6NdSllVer14)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmIpv6NdSllVer14> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFOxmIpv6NdSllVer14 message) {
            bb.writeInt(-2147467258);
            message.value.write6Bytes(bb);
        }
    }

    static class OFOxmIpv6NdSllVer14Funnel
    implements Funnel<OFOxmIpv6NdSllVer14> {
        private static final long serialVersionUID = 1L;

        OFOxmIpv6NdSllVer14Funnel() {
        }

        public void funnel(OFOxmIpv6NdSllVer14 message, PrimitiveSink sink) {
            sink.putInt(-2147467258);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmIpv6NdSll> {
        Reader() {
        }

        @Override
        public OFOxmIpv6NdSll readFrom(ChannelBuffer bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -2147467258) {
                throw new OFParseError("Wrong typeLen: Expected=0x80004006L(0x80004006L), got=" + typeLen);
            }
            MacAddress value = MacAddress.read6Bytes(bb);
            OFOxmIpv6NdSllVer14 oxmIpv6NdSllVer14 = new OFOxmIpv6NdSllVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmIpv6NdSllVer14);
            }
            return oxmIpv6NdSllVer14;
        }
    }

    static class Builder
    implements OFOxmIpv6NdSll.Builder {
        private boolean valueSet;
        private MacAddress value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 2147500038L;
        }

        @Override
        public MacAddress getValue() {
            return this.value;
        }

        @Override
        public OFOxmIpv6NdSll.Builder setValue(MacAddress value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<MacAddress> getMatchField() {
            return MatchField.IPV6_ND_SLL;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<MacAddress> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public MacAddress getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmIpv6NdSll build() {
            MacAddress value;
            MacAddress macAddress = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmIpv6NdSllVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmIpv6NdSll.Builder {
        final OFOxmIpv6NdSllVer14 parentMessage;
        private boolean valueSet;
        private MacAddress value;

        BuilderWithParent(OFOxmIpv6NdSllVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 2147500038L;
        }

        @Override
        public MacAddress getValue() {
            return this.value;
        }

        @Override
        public OFOxmIpv6NdSll.Builder setValue(MacAddress value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<MacAddress> getMatchField() {
            return MatchField.IPV6_ND_SLL;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<MacAddress> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public MacAddress getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmIpv6NdSll build() {
            MacAddress value;
            MacAddress macAddress = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmIpv6NdSllVer14(value);
        }
    }
}

