/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmTunGbpId;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmTunGbpIdVer14
implements OFOxmTunGbpId {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmTunGbpIdVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 6;
    private static final U16 DEFAULT_VALUE = U16.ZERO;
    private final U16 value;
    static final OFOxmTunGbpIdVer14 DEFAULT = new OFOxmTunGbpIdVer14(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmTunGbpIdVer14Funnel FUNNEL = new OFOxmTunGbpIdVer14Funnel();
    static final Writer WRITER = new Writer();

    OFOxmTunGbpIdVer14(U16 value) {
        if (value == null) {
            throw new NullPointerException("OFOxmTunGbpIdVer14: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 84994L;
    }

    @Override
    public U16 getValue() {
        return this.value;
    }

    @Override
    public MatchField<U16> getMatchField() {
        return MatchField.TUN_GBP_ID;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<U16> getCanonical() {
        return this;
    }

    @Override
    public U16 getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.4");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFOxmTunGbpId.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmTunGbpIdVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmTunGbpIdVer14 other = (OFOxmTunGbpIdVer14)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmTunGbpIdVer14> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFOxmTunGbpIdVer14 message) {
            bb.writeInt(84994);
            bb.writeShort((int)message.value.getRaw());
        }
    }

    static class OFOxmTunGbpIdVer14Funnel
    implements Funnel<OFOxmTunGbpIdVer14> {
        private static final long serialVersionUID = 1L;

        OFOxmTunGbpIdVer14Funnel() {
        }

        public void funnel(OFOxmTunGbpIdVer14 message, PrimitiveSink sink) {
            sink.putInt(84994);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmTunGbpId> {
        Reader() {
        }

        @Override
        public OFOxmTunGbpId readFrom(ChannelBuffer bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 84994) {
                throw new OFParseError("Wrong typeLen: Expected=0x14c02L(0x14c02L), got=" + typeLen);
            }
            U16 value = U16.of(bb.readShort());
            OFOxmTunGbpIdVer14 oxmTunGbpIdVer14 = new OFOxmTunGbpIdVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmTunGbpIdVer14);
            }
            return oxmTunGbpIdVer14;
        }
    }

    static class Builder
    implements OFOxmTunGbpId.Builder {
        private boolean valueSet;
        private U16 value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 84994L;
        }

        @Override
        public U16 getValue() {
            return this.value;
        }

        @Override
        public OFOxmTunGbpId.Builder setValue(U16 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U16> getMatchField() {
            return MatchField.TUN_GBP_ID;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U16> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public U16 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmTunGbpId build() {
            U16 value;
            U16 u16 = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmTunGbpIdVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmTunGbpId.Builder {
        final OFOxmTunGbpIdVer14 parentMessage;
        private boolean valueSet;
        private U16 value;

        BuilderWithParent(OFOxmTunGbpIdVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 84994L;
        }

        @Override
        public U16 getValue() {
            return this.value;
        }

        @Override
        public OFOxmTunGbpId.Builder setValue(U16 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U16> getMatchField() {
            return MatchField.TUN_GBP_ID;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U16> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public U16 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmTunGbpId build() {
            U16 value;
            U16 u16 = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmTunGbpIdVer14(value);
        }
    }
}

