/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.types;

import com.google.common.collect.ComparisonChain;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.types.OFValueType;

public class CircuitSignalID
implements OFValueType<CircuitSignalID> {
    static final int length = 6;
    private byte gridType;
    private byte channelSpacing;
    private short channelNumber;
    private short spectralWidth;
    public static final CircuitSignalID NONE = new CircuitSignalID(0, 0, 0, 0);

    public CircuitSignalID(byte gridType, byte channelSpacing, short channelNumber, short spectralWidth) {
        this.gridType = gridType;
        this.channelSpacing = channelSpacing;
        this.channelNumber = channelNumber;
        this.spectralWidth = spectralWidth;
    }

    @Override
    public int getLength() {
        return 6;
    }

    public byte getGridType() {
        return this.gridType;
    }

    public byte getChannelSpacing() {
        return this.channelSpacing;
    }

    public short getChannelNumber() {
        return this.channelNumber;
    }

    public short getSpectralWidth() {
        return this.spectralWidth;
    }

    public void write6Bytes(ChannelBuffer c) {
        c.writeByte((int)this.gridType);
        c.writeByte((int)this.channelSpacing);
        c.writeShort((int)this.channelNumber);
        c.writeShort((int)this.spectralWidth);
    }

    public static CircuitSignalID read6Bytes(ChannelBuffer c) throws OFParseError {
        return new CircuitSignalID((byte)c.readUnsignedByte(), (byte)c.readUnsignedByte(), (short)c.readUnsignedShort(), (short)c.readUnsignedShort());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CircuitSignalID that = (CircuitSignalID)o;
        if (this.channelNumber != that.channelNumber) {
            return false;
        }
        if (this.channelSpacing != that.channelSpacing) {
            return false;
        }
        if (this.gridType != that.gridType) {
            return false;
        }
        return this.spectralWidth == that.spectralWidth;
    }

    public int hashCode() {
        int result = this.gridType;
        result = 31 * result + this.channelSpacing;
        result = 31 * result + this.channelNumber;
        result = 31 * result + this.spectralWidth;
        return result;
    }

    public String toString() {
        return "CircuitSignalID{gridType=" + this.gridType + ", channelSpacing=" + this.channelSpacing + ", channelNumber=" + this.channelNumber + ", spectralWidth=" + this.spectralWidth + '}';
    }

    @Override
    public CircuitSignalID applyMask(CircuitSignalID mask) {
        return new CircuitSignalID((byte)(this.gridType & mask.gridType), (byte)(this.channelSpacing & mask.channelSpacing), (short)(this.channelNumber & mask.channelNumber), (short)(this.spectralWidth & mask.spectralWidth));
    }

    @Override
    public int compareTo(CircuitSignalID o) {
        return ComparisonChain.start().compare((int)this.gridType, (int)o.gridType).compare((int)this.channelSpacing, (int)o.channelSpacing).compare((int)this.channelNumber, (int)o.channelNumber).compare((int)this.spectralWidth, (int)o.spectralWidth).result();
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        sink.putByte(this.gridType);
        sink.putByte(this.channelSpacing);
        sink.putShort(this.channelNumber);
        sink.putShort(this.spectralWidth);
    }
}

