/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.types;

import com.google.common.hash.PrimitiveSink;
import com.google.common.primitives.Shorts;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.types.OFValueType;

public class ICMPv4Type
implements OFValueType<ICMPv4Type> {
    static final int LENGTH = 1;
    private static final short VAL_ECHO_REPLY = 0;
    private static final short VAL_DESTINATION_UNREACHABLE = 3;
    private static final short VAL_SOURCE_QUENCH = 4;
    private static final short VAL_REDIRECT = 5;
    private static final short VAL_ALTERNATE_HOST_ADDRESS = 6;
    private static final short VAL_ECHO = 8;
    private static final short VAL_ROUTER_ADVERTISEMENT = 9;
    private static final short VAL_ROUTER_SOLICITATION = 10;
    private static final short VAL_TIME_EXCEEDED = 11;
    private static final short VAL_PARAMETER_PROBLEM = 12;
    private static final short VAL_TIMESTAMP = 13;
    private static final short VAL_TIMESTAMP_REPLY = 14;
    private static final short VAL_INFORMATION_REQUEST = 15;
    private static final short VAL_INFORMATION_REPLY = 16;
    private static final short VAL_ADDRESS_MASK_REQUEST = 17;
    private static final short VAL_ADDRESS_MASK_REPLY = 18;
    private static final short VAL_TRACEROUTE = 30;
    private static final short VAL_DATAGRAM_CONVERSION_ERROR = 31;
    private static final short VAL_MOBILE_HOST_REDIRECT = 32;
    private static final short VAL_IPV6_WHERE_ARE_YOU = 33;
    private static final short VAL_IPV6_I_AM_HERE = 34;
    private static final short VAL_MOBILE_REGISTRATION_REQUEST = 35;
    private static final short VAL_MOBILE_REGISTRATION_REPLY = 36;
    private static final short VAL_DOMAIN_NAME_REQUEST = 37;
    private static final short VAL_DOMAIN_NAME_REPLY = 38;
    private static final short VAL_SKIP = 39;
    private static final short VAL_PHOTURIS = 40;
    private static final short VAL_EXPERIMENTAL_MOBILITY = 41;
    public static final ICMPv4Type ECHO_REPLY = new ICMPv4Type(0);
    public static final ICMPv4Type DESTINATION_UNREACHABLE = new ICMPv4Type(3);
    public static final ICMPv4Type SOURCE_QUENCH = new ICMPv4Type(4);
    public static final ICMPv4Type REDIRECT = new ICMPv4Type(5);
    public static final ICMPv4Type ALTERNATE_HOST_ADDRESS = new ICMPv4Type(6);
    public static final ICMPv4Type ECHO = new ICMPv4Type(8);
    public static final ICMPv4Type ROUTER_ADVERTISEMENT = new ICMPv4Type(9);
    public static final ICMPv4Type ROUTER_SOLICITATION = new ICMPv4Type(10);
    public static final ICMPv4Type TIME_EXCEEDED = new ICMPv4Type(11);
    public static final ICMPv4Type PARAMETER_PROBLEM = new ICMPv4Type(12);
    public static final ICMPv4Type TIMESTAMP = new ICMPv4Type(13);
    public static final ICMPv4Type TIMESTAMP_REPLY = new ICMPv4Type(14);
    public static final ICMPv4Type INFORMATION_REQUEST = new ICMPv4Type(15);
    public static final ICMPv4Type INFORMATION_REPLY = new ICMPv4Type(16);
    public static final ICMPv4Type ADDRESS_MASK_REQUEST = new ICMPv4Type(17);
    public static final ICMPv4Type ADDRESS_MASK_REPLY = new ICMPv4Type(18);
    public static final ICMPv4Type TRACEROUTE = new ICMPv4Type(30);
    public static final ICMPv4Type DATAGRAM_CONVERSION_ERROR = new ICMPv4Type(31);
    public static final ICMPv4Type MOBILE_HOST_REDIRECT = new ICMPv4Type(32);
    public static final ICMPv4Type IPV6_WHERE_ARE_YOU = new ICMPv4Type(33);
    public static final ICMPv4Type IPV6_I_AM_HERE = new ICMPv4Type(34);
    public static final ICMPv4Type MOBILE_REGISTRATION_REQUEST = new ICMPv4Type(35);
    public static final ICMPv4Type MOBILE_REGISTRATION_REPLY = new ICMPv4Type(36);
    public static final ICMPv4Type DOMAIN_NAME_REQUEST = new ICMPv4Type(37);
    public static final ICMPv4Type DOMAIN_NAME_REPLY = new ICMPv4Type(38);
    public static final ICMPv4Type SKIP = new ICMPv4Type(39);
    public static final ICMPv4Type PHOTURIS = new ICMPv4Type(40);
    public static final ICMPv4Type EXPERIMENTAL_MOBILITY = new ICMPv4Type(41);
    public static final ICMPv4Type NONE = ECHO_REPLY;
    public static final ICMPv4Type NO_MASK = new ICMPv4Type(-1);
    public static final ICMPv4Type FULL_MASK = new ICMPv4Type(0);
    private final short type;
    private static final int MIN_TYPE = 0;
    private static final int MAX_TYPE = 255;

    private ICMPv4Type(short type) {
        this.type = type;
    }

    public static ICMPv4Type of(short type) {
        if (type < 0 || type > 255) {
            throw new IllegalArgumentException("Invalid ICMPv4 type: " + type);
        }
        switch (type) {
            case 0: {
                return ECHO_REPLY;
            }
            case 3: {
                return DESTINATION_UNREACHABLE;
            }
            case 4: {
                return SOURCE_QUENCH;
            }
            case 5: {
                return REDIRECT;
            }
            case 6: {
                return ALTERNATE_HOST_ADDRESS;
            }
            case 8: {
                return ECHO;
            }
            case 9: {
                return ROUTER_ADVERTISEMENT;
            }
            case 10: {
                return ROUTER_SOLICITATION;
            }
            case 11: {
                return TIME_EXCEEDED;
            }
            case 12: {
                return PARAMETER_PROBLEM;
            }
            case 13: {
                return TIMESTAMP;
            }
            case 14: {
                return TIMESTAMP_REPLY;
            }
            case 15: {
                return INFORMATION_REQUEST;
            }
            case 16: {
                return INFORMATION_REPLY;
            }
            case 17: {
                return ADDRESS_MASK_REQUEST;
            }
            case 18: {
                return ADDRESS_MASK_REPLY;
            }
            case 30: {
                return TRACEROUTE;
            }
            case 31: {
                return DATAGRAM_CONVERSION_ERROR;
            }
            case 32: {
                return MOBILE_HOST_REDIRECT;
            }
            case 33: {
                return IPV6_WHERE_ARE_YOU;
            }
            case 34: {
                return IPV6_I_AM_HERE;
            }
            case 35: {
                return MOBILE_REGISTRATION_REQUEST;
            }
            case 36: {
                return MOBILE_REGISTRATION_REPLY;
            }
            case 37: {
                return DOMAIN_NAME_REQUEST;
            }
            case 38: {
                return DOMAIN_NAME_REPLY;
            }
            case 39: {
                return SKIP;
            }
            case 40: {
                return PHOTURIS;
            }
            case 41: {
                return EXPERIMENTAL_MOBILITY;
            }
        }
        return new ICMPv4Type(type);
    }

    @Override
    public int getLength() {
        return 1;
    }

    public short getType() {
        return this.type;
    }

    public void writeByte(ChannelBuffer c) {
        c.writeByte((int)this.type);
    }

    public static ICMPv4Type readByte(ChannelBuffer c) {
        return ICMPv4Type.of(c.readUnsignedByte());
    }

    @Override
    public ICMPv4Type applyMask(ICMPv4Type mask) {
        return ICMPv4Type.of((short)(this.type & mask.type));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.type;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ICMPv4Type other = (ICMPv4Type)obj;
        return this.type == other.type;
    }

    @Override
    public int compareTo(ICMPv4Type o) {
        return Shorts.compare((short)this.type, (short)o.type);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        sink.putShort(this.type);
    }

    public String toString() {
        return String.valueOf(this.type);
    }
}

