/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.types;

import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.Writeable;
import org.projectfloodlight.openflow.types.OFValueType;

public class OFBooleanValue
implements Writeable,
OFValueType<OFBooleanValue> {
    public static final OFBooleanValue TRUE = new OFBooleanValue(true);
    public static final OFBooleanValue FALSE = new OFBooleanValue(false);
    public static final OFBooleanValue NO_MASK = TRUE;
    public static final OFBooleanValue FULL_MASK = FALSE;
    public static final Reader READER_INSTANCE = new Reader();
    private final boolean value;

    private OFBooleanValue(boolean value) {
        this.value = value;
    }

    public static OFBooleanValue of(boolean value) {
        return value ? TRUE : FALSE;
    }

    public boolean getValue() {
        return this.value;
    }

    public int getInt() {
        return this.value ? 1 : 0;
    }

    public String toString() {
        return "" + this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getInt();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBooleanValue other = (OFBooleanValue)obj;
        return this.value == other.value;
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        bb.writeByte(this.getInt());
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public OFBooleanValue applyMask(OFBooleanValue mask) {
        return OFBooleanValue.of(this.value && mask.value);
    }

    @Override
    public int compareTo(OFBooleanValue o) {
        return this.getInt() - o.getInt();
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        sink.putByte((byte)this.getInt());
    }

    private static class Reader
    implements OFMessageReader<OFBooleanValue> {
        private Reader() {
        }

        @Override
        public OFBooleanValue readFrom(ChannelBuffer bb) throws OFParseError {
            return OFBooleanValue.of(bb.readByte() != 0);
        }
    }
}

