/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver10;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFFlowStatsEntry;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.ver10.OFFactoryVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFFlowStatsEntryVer10;
import org.projectfloodlight.openflow.types.EthType;
import org.projectfloodlight.openflow.types.IPv4Address;
import org.projectfloodlight.openflow.types.MacAddress;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.OFValueType;
import org.projectfloodlight.openflow.types.TableId;
import org.projectfloodlight.openflow.types.U64;

public class OFFlowStatsEntryVer10Test {
    OFFactory factory;
    static final byte[] FLOW_STATS_ENTRY_SERIALIZED = new byte[]{0, 104, 3, 0, 0, 48, 0, -30, 0, 3, 1, 35, 69, 103, -119, -85, -51, -17, 1, 35, 69, 103, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0, -64, -88, 3, 127, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 2, 0, 100, 0, 5, 0, 10, 0, 0, 0, 0, 0, 0, 1, 35, 69, 103, -119, -85, -51, -17, 0, 0, 0, 0, 0, 0, 0, 10, 0, 0, 0, 0, 0, 0, 3, -24, 0, 0, 0, 8, 0, 1, 0, 0, 0, 0, 0, 8, 0, 2, 0, 0};

    @Before
    public void setup() {
        this.factory = OFFactoryVer10.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFFlowStatsEntry.Builder builder = this.factory.buildFlowStatsEntry();
        builder.setTableId(TableId.of((int)3)).setMatch(this.factory.buildMatch().setExact(MatchField.IN_PORT, (OFValueType)OFPort.of((int)3)).setExact(MatchField.ETH_TYPE, (OFValueType)EthType.IPv4).setExact(MatchField.IPV4_SRC, (OFValueType)IPv4Address.of((int)-1062730881)).setExact(MatchField.IPV4_DST, (OFValueType)IPv4Address.of((int)-1)).setExact(MatchField.ETH_SRC, (OFValueType)MacAddress.of((String)"01:23:45:67:89:ab")).setExact(MatchField.ETH_DST, (OFValueType)MacAddress.of((String)"cd:ef:01:23:45:67")).build()).setDurationSec(1L).setDurationNsec(2L).setPriority(100).setIdleTimeout(5).setHardTimeout(10).setCookie(U64.of((long)81985529216486895L)).setPacketCount(U64.of((long)10L)).setByteCount(U64.of((long)1000L)).setActions((List)ImmutableList.of((Object)this.factory.actions().output(OFPort.of((int)1), 0), (Object)this.factory.actions().output(OFPort.of((int)2), 0)));
        OFFlowStatsEntry flowStatsEntry = builder.build();
        ChannelBuffer bb = ChannelBuffers.dynamicBuffer();
        flowStatsEntry.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)FLOW_STATS_ENTRY_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFFlowStatsEntry.Builder builder = this.factory.buildFlowStatsEntry();
        builder.setTableId(TableId.of((int)3)).setMatch(this.factory.buildMatch().setExact(MatchField.IN_PORT, (OFValueType)OFPort.of((int)3)).setExact(MatchField.ETH_TYPE, (OFValueType)EthType.IPv4).setExact(MatchField.IPV4_SRC, (OFValueType)IPv4Address.of((int)-1062730881)).setExact(MatchField.IPV4_DST, (OFValueType)IPv4Address.of((int)-1)).setExact(MatchField.ETH_SRC, (OFValueType)MacAddress.of((String)"01:23:45:67:89:ab")).setExact(MatchField.ETH_DST, (OFValueType)MacAddress.of((String)"cd:ef:01:23:45:67")).build()).setDurationSec(1L).setDurationNsec(2L).setPriority(100).setIdleTimeout(5).setHardTimeout(10).setCookie(U64.of((long)81985529216486895L)).setPacketCount(U64.of((long)10L)).setByteCount(U64.of((long)1000L)).setActions((List)ImmutableList.of((Object)this.factory.actions().output(OFPort.of((int)1), 0), (Object)this.factory.actions().output(OFPort.of((int)2), 0)));
        OFFlowStatsEntry flowStatsEntryBuilt = builder.build();
        ChannelBuffer input = ChannelBuffers.copiedBuffer((byte[])FLOW_STATS_ENTRY_SERIALIZED);
        OFFlowStatsEntry flowStatsEntryRead = OFFlowStatsEntryVer10.READER.readFrom(input);
        Assert.assertEquals((long)FLOW_STATS_ENTRY_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)flowStatsEntryBuilt, (Object)flowStatsEntryRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ChannelBuffer input = ChannelBuffers.copiedBuffer((byte[])FLOW_STATS_ENTRY_SERIALIZED);
        OFFlowStatsEntry flowStatsEntry = OFFlowStatsEntryVer10.READER.readFrom(input);
        Assert.assertEquals((long)FLOW_STATS_ENTRY_SERIALIZED.length, (long)input.readerIndex());
        ChannelBuffer bb = ChannelBuffers.dynamicBuffer();
        flowStatsEntry.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)FLOW_STATS_ENTRY_SERIALIZED));
    }
}

