/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver10;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFPacketIn;
import org.projectfloodlight.openflow.protocol.OFPacketInReason;
import org.projectfloodlight.openflow.protocol.ver10.OFFactoryVer10;
import org.projectfloodlight.openflow.protocol.ver10.OFPacketInVer10;
import org.projectfloodlight.openflow.types.OFBufferId;
import org.projectfloodlight.openflow.types.OFPort;

public class OFPacketInVer10Test {
    OFFactory factory;
    static final byte[] PACKET_IN_SERIALIZED = new byte[]{1, 10, 0, 21, 18, 52, 86, 120, -85, -51, -17, 1, 0, 9, -1, -2, 1, 0, 97, 98, 99};

    @Before
    public void setup() {
        this.factory = OFFactoryVer10.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFPacketIn.Builder builder = this.factory.buildPacketIn();
        builder.setXid(305419896L).setBufferId(OFBufferId.of((int)-1412567295)).setTotalLen(9).setInPort(OFPort.LOCAL).setReason(OFPacketInReason.ACTION).setData(new byte[]{97, 98, 99});
        OFPacketIn packetIn = builder.build();
        ChannelBuffer bb = ChannelBuffers.dynamicBuffer();
        packetIn.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)PACKET_IN_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFPacketIn.Builder builder = this.factory.buildPacketIn();
        builder.setXid(305419896L).setBufferId(OFBufferId.of((int)-1412567295)).setTotalLen(9).setInPort(OFPort.LOCAL).setReason(OFPacketInReason.ACTION).setData(new byte[]{97, 98, 99});
        OFPacketIn packetInBuilt = builder.build();
        ChannelBuffer input = ChannelBuffers.copiedBuffer((byte[])PACKET_IN_SERIALIZED);
        OFPacketIn packetInRead = OFPacketInVer10.READER.readFrom(input);
        Assert.assertEquals((long)PACKET_IN_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)packetInBuilt, (Object)packetInRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ChannelBuffer input = ChannelBuffers.copiedBuffer((byte[])PACKET_IN_SERIALIZED);
        OFPacketIn packetIn = OFPacketInVer10.READER.readFrom(input);
        Assert.assertEquals((long)PACKET_IN_SERIALIZED.length, (long)input.readerIndex());
        ChannelBuffer bb = ChannelBuffers.dynamicBuffer();
        packetIn.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)PACKET_IN_SERIALIZED));
    }
}

