/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFBsnGentableBucketStatsReply;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.ver13.OFBsnGentableBucketStatsReplyVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFFactoryVer13;
import org.projectfloodlight.openflow.types.U128;

public class OFBsnGentableBucketStatsReplyVer13Test {
    OFFactory factory;
    static final byte[] BSN_GENTABLE_BUCKET_STATS_REPLY_SERIALIZED = new byte[]{4, 19, 0, 56, 18, 52, 86, 120, -1, -1, 0, 0, 0, 0, 0, 0, 0, 92, 22, -57, 0, 0, 0, 5, -120, 119, 102, 85, 68, 51, 34, 17, -1, -18, -35, -52, -69, -86, -103, -120, 18, 52, 35, 69, 52, 86, 69, 103, 86, 120, 103, -119, 120, -102, -119, -85};

    @Before
    public void setup() {
        this.factory = OFFactoryVer13.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFBsnGentableBucketStatsReply.Builder builder = this.factory.buildBsnGentableBucketStatsReply();
        builder.setXid(305419896L).setEntries((List)ImmutableList.of((Object)this.factory.bsnGentableBucketStatsEntry(U128.of((long)-8613303245920329199L, (long)-4822678189205112L)), (Object)this.factory.bsnGentableBucketStatsEntry(U128.of((long)1311712171609441639L, (long)6230843924598655403L))));
        OFBsnGentableBucketStatsReply bsnGentableBucketStatsReply = builder.build();
        ChannelBuffer bb = ChannelBuffers.dynamicBuffer();
        bsnGentableBucketStatsReply.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)BSN_GENTABLE_BUCKET_STATS_REPLY_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFBsnGentableBucketStatsReply.Builder builder = this.factory.buildBsnGentableBucketStatsReply();
        builder.setXid(305419896L).setEntries((List)ImmutableList.of((Object)this.factory.bsnGentableBucketStatsEntry(U128.of((long)-8613303245920329199L, (long)-4822678189205112L)), (Object)this.factory.bsnGentableBucketStatsEntry(U128.of((long)1311712171609441639L, (long)6230843924598655403L))));
        OFBsnGentableBucketStatsReply bsnGentableBucketStatsReplyBuilt = builder.build();
        ChannelBuffer input = ChannelBuffers.copiedBuffer((byte[])BSN_GENTABLE_BUCKET_STATS_REPLY_SERIALIZED);
        OFBsnGentableBucketStatsReply bsnGentableBucketStatsReplyRead = OFBsnGentableBucketStatsReplyVer13.READER.readFrom(input);
        Assert.assertEquals((long)BSN_GENTABLE_BUCKET_STATS_REPLY_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)bsnGentableBucketStatsReplyBuilt, (Object)bsnGentableBucketStatsReplyRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ChannelBuffer input = ChannelBuffers.copiedBuffer((byte[])BSN_GENTABLE_BUCKET_STATS_REPLY_SERIALIZED);
        OFBsnGentableBucketStatsReply bsnGentableBucketStatsReply = OFBsnGentableBucketStatsReplyVer13.READER.readFrom(input);
        Assert.assertEquals((long)BSN_GENTABLE_BUCKET_STATS_REPLY_SERIALIZED.length, (long)input.readerIndex());
        ChannelBuffer bb = ChannelBuffers.dynamicBuffer();
        bsnGentableBucketStatsReply.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)BSN_GENTABLE_BUCKET_STATS_REPLY_SERIALIZED));
    }
}

