/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFBsnGentableClearRequest;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.ver13.OFBsnGentableClearRequestVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFFactoryVer13;
import org.projectfloodlight.openflow.types.GenTableId;
import org.projectfloodlight.openflow.types.U128;

public class OFBsnGentableClearRequestVer13Test {
    OFFactory factory;
    static final byte[] BSN_GENTABLE_CLEAR_REQUEST_SERIALIZED = new byte[]{4, 4, 0, 52, 18, 52, 86, 120, 0, 92, 22, -57, 0, 0, 0, 48, 0, 20, 0, 0, -2, -36, -70, -104, 118, 84, 50, 16, -1, -18, -52, -69, -86, -103, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0};

    @Before
    public void setup() {
        this.factory = OFFactoryVer13.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFBsnGentableClearRequest.Builder builder = this.factory.buildBsnGentableClearRequest();
        builder.setXid(305419896L).setChecksum(U128.of((long)-81985529216486896L, (long)-4841443187687424L)).setChecksumMask(U128.of((long)-1L, (long)-65536L)).setTableId(GenTableId.of((int)20));
        OFBsnGentableClearRequest bsnGentableClearRequest = builder.build();
        ChannelBuffer bb = ChannelBuffers.dynamicBuffer();
        bsnGentableClearRequest.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)BSN_GENTABLE_CLEAR_REQUEST_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFBsnGentableClearRequest.Builder builder = this.factory.buildBsnGentableClearRequest();
        builder.setXid(305419896L).setChecksum(U128.of((long)-81985529216486896L, (long)-4841443187687424L)).setChecksumMask(U128.of((long)-1L, (long)-65536L)).setTableId(GenTableId.of((int)20));
        OFBsnGentableClearRequest bsnGentableClearRequestBuilt = builder.build();
        ChannelBuffer input = ChannelBuffers.copiedBuffer((byte[])BSN_GENTABLE_CLEAR_REQUEST_SERIALIZED);
        OFBsnGentableClearRequest bsnGentableClearRequestRead = OFBsnGentableClearRequestVer13.READER.readFrom(input);
        Assert.assertEquals((long)BSN_GENTABLE_CLEAR_REQUEST_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)bsnGentableClearRequestBuilt, (Object)bsnGentableClearRequestRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ChannelBuffer input = ChannelBuffers.copiedBuffer((byte[])BSN_GENTABLE_CLEAR_REQUEST_SERIALIZED);
        OFBsnGentableClearRequest bsnGentableClearRequest = OFBsnGentableClearRequestVer13.READER.readFrom(input);
        Assert.assertEquals((long)BSN_GENTABLE_CLEAR_REQUEST_SERIALIZED.length, (long)input.readerIndex());
        ChannelBuffer bb = ChannelBuffers.dynamicBuffer();
        bsnGentableClearRequest.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)BSN_GENTABLE_CLEAR_REQUEST_SERIALIZED));
    }
}

