/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFBsnLacpStatsRequest;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.ver13.OFBsnLacpStatsRequestVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFFactoryVer13;

public class OFBsnLacpStatsRequestVer13Test {
    OFFactory factory;
    static final byte[] BSN_LACP_STATS_REQUEST_SERIALIZED = new byte[]{4, 18, 0, 24, 18, 52, 86, 120, -1, -1, 0, 0, 0, 0, 0, 0, 0, 92, 22, -57, 0, 0, 0, 1};

    @Before
    public void setup() {
        this.factory = OFFactoryVer13.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFBsnLacpStatsRequest.Builder builder = this.factory.buildBsnLacpStatsRequest();
        builder.setXid(305419896L);
        OFBsnLacpStatsRequest bsnLacpStatsRequest = builder.build();
        ChannelBuffer bb = ChannelBuffers.dynamicBuffer();
        bsnLacpStatsRequest.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)BSN_LACP_STATS_REQUEST_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFBsnLacpStatsRequest.Builder builder = this.factory.buildBsnLacpStatsRequest();
        builder.setXid(305419896L);
        OFBsnLacpStatsRequest bsnLacpStatsRequestBuilt = builder.build();
        ChannelBuffer input = ChannelBuffers.copiedBuffer((byte[])BSN_LACP_STATS_REQUEST_SERIALIZED);
        OFBsnLacpStatsRequest bsnLacpStatsRequestRead = OFBsnLacpStatsRequestVer13.READER.readFrom(input);
        Assert.assertEquals((long)BSN_LACP_STATS_REQUEST_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)bsnLacpStatsRequestBuilt, (Object)bsnLacpStatsRequestRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ChannelBuffer input = ChannelBuffers.copiedBuffer((byte[])BSN_LACP_STATS_REQUEST_SERIALIZED);
        OFBsnLacpStatsRequest bsnLacpStatsRequest = OFBsnLacpStatsRequestVer13.READER.readFrom(input);
        Assert.assertEquals((long)BSN_LACP_STATS_REQUEST_SERIALIZED.length, (long)input.readerIndex());
        ChannelBuffer bb = ChannelBuffers.dynamicBuffer();
        bsnLacpStatsRequest.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)BSN_LACP_STATS_REQUEST_SERIALIZED));
    }
}

