/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFBsnSetAuxCxnsRequest;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.ver13.OFBsnSetAuxCxnsRequestVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFFactoryVer13;

public class OFBsnSetAuxCxnsRequestVer13Test {
    OFFactory factory;
    static final byte[] BSN_SET_AUX_CXNS_REQUEST_SERIALIZED = new byte[]{4, 4, 0, 20, 18, 52, 86, 120, 0, 92, 22, -57, 0, 0, 0, 58, 0, 0, 0, 1};

    @Before
    public void setup() {
        this.factory = OFFactoryVer13.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFBsnSetAuxCxnsRequest.Builder builder = this.factory.buildBsnSetAuxCxnsRequest();
        builder.setXid(305419896L).setNumAux(1L);
        OFBsnSetAuxCxnsRequest bsnSetAuxCxnsRequest = builder.build();
        ChannelBuffer bb = ChannelBuffers.dynamicBuffer();
        bsnSetAuxCxnsRequest.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)BSN_SET_AUX_CXNS_REQUEST_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFBsnSetAuxCxnsRequest.Builder builder = this.factory.buildBsnSetAuxCxnsRequest();
        builder.setXid(305419896L).setNumAux(1L);
        OFBsnSetAuxCxnsRequest bsnSetAuxCxnsRequestBuilt = builder.build();
        ChannelBuffer input = ChannelBuffers.copiedBuffer((byte[])BSN_SET_AUX_CXNS_REQUEST_SERIALIZED);
        OFBsnSetAuxCxnsRequest bsnSetAuxCxnsRequestRead = OFBsnSetAuxCxnsRequestVer13.READER.readFrom(input);
        Assert.assertEquals((long)BSN_SET_AUX_CXNS_REQUEST_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)bsnSetAuxCxnsRequestBuilt, (Object)bsnSetAuxCxnsRequestRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ChannelBuffer input = ChannelBuffers.copiedBuffer((byte[])BSN_SET_AUX_CXNS_REQUEST_SERIALIZED);
        OFBsnSetAuxCxnsRequest bsnSetAuxCxnsRequest = OFBsnSetAuxCxnsRequestVer13.READER.readFrom(input);
        Assert.assertEquals((long)BSN_SET_AUX_CXNS_REQUEST_SERIALIZED.length, (long)input.readerIndex());
        ChannelBuffer bb = ChannelBuffers.dynamicBuffer();
        bsnSetAuxCxnsRequest.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)BSN_SET_AUX_CXNS_REQUEST_SERIALIZED));
    }
}

