/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.OFFactory;
import org.projectfloodlight.openflow.protocol.OFFlowModifyStrict;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.ver13.OFFactoryVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFFlowModifyStrictVer13;
import org.projectfloodlight.openflow.types.EthType;
import org.projectfloodlight.openflow.types.IPv6Address;
import org.projectfloodlight.openflow.types.IpProtocol;
import org.projectfloodlight.openflow.types.OFBufferId;
import org.projectfloodlight.openflow.types.OFGroup;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.OFValueType;
import org.projectfloodlight.openflow.types.TableId;
import org.projectfloodlight.openflow.types.U64;

public class OFFlowModifyStrictVer13Test {
    OFFactory factory;
    static final byte[] FLOW_MODIFY_STRICT_SERIALIZED = new byte[]{4, 14, 0, -128, 18, 52, 86, 120, -2, -36, -70, -104, 118, 84, 50, 16, -1, 0, -1, 0, -1, 0, -1, 0, 3, 2, 0, 5, 0, 10, 23, 112, 0, 0, 0, 50, 0, 0, 0, 6, 0, 0, 0, 8, 0, 0, 0, 0, 0, 1, 0, 63, -128, 0, 1, 8, 0, 0, 0, 4, 0, 0, 0, 5, -128, 0, 10, 2, -122, -35, -128, 0, 20, 1, 6, -128, 0, 53, 32, 28, -54, -2, 28, -79, 16, 28, 0, 0, 40, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -16, -1, -1, 28, 44, 60, 0, 0, 0, 0, 0, 0, 0, 1, 0, 8, 4, 0, 0, 0, 0, 1, 0, 8, 7, 0, 0, 0};

    @Before
    public void setup() {
        this.factory = OFFactoryVer13.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFFlowModifyStrict.Builder builder = this.factory.buildFlowModifyStrict();
        builder.setXid(305419896L).setCookie(U64.parseHex((String)"FEDCBA9876543210")).setCookieMask(U64.parseHex((String)"FF00FF00FF00FF00")).setTableId(TableId.of((int)3)).setIdleTimeout(5).setHardTimeout(10).setPriority(6000).setBufferId(OFBufferId.of((int)50)).setOutPort(OFPort.of((int)6)).setOutGroup(OFGroup.of((int)8)).setFlags((Set)ImmutableSet.of()).setMatch(this.factory.buildMatch().setMasked(MatchField.IN_PORT, (OFValueType)OFPort.of((int)4), (OFValueType)OFPort.of((int)5)).setExact(MatchField.ETH_TYPE, (OFValueType)EthType.IPv6).setExact(MatchField.IP_PROTO, (OFValueType)IpProtocol.TCP).setMasked(MatchField.IPV6_SRC, (OFValueType)IPv6Address.of((long)2074749977540697088L, (long)0x28000000000000L), (OFValueType)IPv6Address.of((long)-983041L, (long)2030063502734917632L)).build()).setInstructions((List)ImmutableList.of((Object)this.factory.instructions().gotoTable(TableId.of((int)4)), (Object)this.factory.instructions().gotoTable(TableId.of((int)7))));
        OFFlowModifyStrict flowModifyStrict = builder.build();
        ChannelBuffer bb = ChannelBuffers.dynamicBuffer();
        flowModifyStrict.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)FLOW_MODIFY_STRICT_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFFlowModifyStrict.Builder builder = this.factory.buildFlowModifyStrict();
        builder.setXid(305419896L).setCookie(U64.parseHex((String)"FEDCBA9876543210")).setCookieMask(U64.parseHex((String)"FF00FF00FF00FF00")).setTableId(TableId.of((int)3)).setIdleTimeout(5).setHardTimeout(10).setPriority(6000).setBufferId(OFBufferId.of((int)50)).setOutPort(OFPort.of((int)6)).setOutGroup(OFGroup.of((int)8)).setFlags((Set)ImmutableSet.of()).setMatch(this.factory.buildMatch().setMasked(MatchField.IN_PORT, (OFValueType)OFPort.of((int)4), (OFValueType)OFPort.of((int)5)).setExact(MatchField.ETH_TYPE, (OFValueType)EthType.IPv6).setExact(MatchField.IP_PROTO, (OFValueType)IpProtocol.TCP).setMasked(MatchField.IPV6_SRC, (OFValueType)IPv6Address.of((long)2074749977540697088L, (long)0x28000000000000L), (OFValueType)IPv6Address.of((long)-983041L, (long)2030063502734917632L)).build()).setInstructions((List)ImmutableList.of((Object)this.factory.instructions().gotoTable(TableId.of((int)4)), (Object)this.factory.instructions().gotoTable(TableId.of((int)7))));
        OFFlowModifyStrict flowModifyStrictBuilt = builder.build();
        ChannelBuffer input = ChannelBuffers.copiedBuffer((byte[])FLOW_MODIFY_STRICT_SERIALIZED);
        OFFlowModifyStrict flowModifyStrictRead = OFFlowModifyStrictVer13.READER.readFrom(input);
        Assert.assertEquals((long)FLOW_MODIFY_STRICT_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)flowModifyStrictBuilt, (Object)flowModifyStrictRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ChannelBuffer input = ChannelBuffers.copiedBuffer((byte[])FLOW_MODIFY_STRICT_SERIALIZED);
        OFFlowModifyStrict flowModifyStrict = OFFlowModifyStrictVer13.READER.readFrom(input);
        Assert.assertEquals((long)FLOW_MODIFY_STRICT_SERIALIZED.length, (long)input.readerIndex());
        ChannelBuffer bb = ChannelBuffers.dynamicBuffer();
        flowModifyStrict.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)FLOW_MODIFY_STRICT_SERIALIZED));
    }
}

