/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmBsnGlobalVrfAllowed;
import org.projectfloodlight.openflow.protocol.oxm.OFOxms;
import org.projectfloodlight.openflow.protocol.ver13.OFOxmBsnGlobalVrfAllowedVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFOxmsVer13;
import org.projectfloodlight.openflow.types.OFBooleanValue;

public class OFOxmBsnGlobalVrfAllowedVer13Test {
    OFOxms factory;
    static final byte[] OXM_BSN_GLOBAL_VRF_ALLOWED_SERIALIZED = new byte[]{0, 3, 6, 1, 1};

    @Before
    public void setup() {
        this.factory = OFOxmsVer13.INSTANCE;
    }

    @Test
    public void testWrite() {
        OFOxmBsnGlobalVrfAllowed.Builder builder = this.factory.buildBsnGlobalVrfAllowed();
        builder.setValue(OFBooleanValue.TRUE);
        OFOxmBsnGlobalVrfAllowed oxmBsnGlobalVrfAllowed = builder.build();
        ChannelBuffer bb = ChannelBuffers.dynamicBuffer();
        oxmBsnGlobalVrfAllowed.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)OXM_BSN_GLOBAL_VRF_ALLOWED_SERIALIZED));
    }

    @Test
    public void testRead() throws Exception {
        OFOxmBsnGlobalVrfAllowed.Builder builder = this.factory.buildBsnGlobalVrfAllowed();
        builder.setValue(OFBooleanValue.TRUE);
        OFOxmBsnGlobalVrfAllowed oxmBsnGlobalVrfAllowedBuilt = builder.build();
        ChannelBuffer input = ChannelBuffers.copiedBuffer((byte[])OXM_BSN_GLOBAL_VRF_ALLOWED_SERIALIZED);
        OFOxmBsnGlobalVrfAllowed oxmBsnGlobalVrfAllowedRead = OFOxmBsnGlobalVrfAllowedVer13.READER.readFrom(input);
        Assert.assertEquals((long)OXM_BSN_GLOBAL_VRF_ALLOWED_SERIALIZED.length, (long)input.readerIndex());
        Assert.assertEquals((Object)oxmBsnGlobalVrfAllowedBuilt, (Object)oxmBsnGlobalVrfAllowedRead);
    }

    @Test
    public void testReadWrite() throws Exception {
        ChannelBuffer input = ChannelBuffers.copiedBuffer((byte[])OXM_BSN_GLOBAL_VRF_ALLOWED_SERIALIZED);
        OFOxmBsnGlobalVrfAllowed oxmBsnGlobalVrfAllowed = OFOxmBsnGlobalVrfAllowedVer13.READER.readFrom(input);
        Assert.assertEquals((long)OXM_BSN_GLOBAL_VRF_ALLOWED_SERIALIZED.length, (long)input.readerIndex());
        ChannelBuffer bb = ChannelBuffers.dynamicBuffer();
        oxmBsnGlobalVrfAllowed.writeTo(bb);
        byte[] written = new byte[bb.readableBytes()];
        bb.readBytes(written);
        Assert.assertThat((Object)written, (Matcher)CoreMatchers.equalTo((Object)OXM_BSN_GLOBAL_VRF_ALLOWED_SERIALIZED));
    }
}

