/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.util;

import org.junit.Assert;
import org.junit.Test;
import org.projectfloodlight.openflow.util.HexString;

public class HexStringTest {
    @Test
    public void testMarshalling() throws Exception {
        String dpidStr = "00:00:00:23:20:2d:16:71";
        long dpid = HexString.toLong((String)dpidStr);
        String testStr = HexString.toHexString((long)dpid);
        Assert.assertEquals((Object)dpidStr, (Object)testStr);
    }

    @Test
    public void testToLong() {
        String dpidStr = "3e:1f:01:fc:72:8c:63:31";
        long valid = 4476298738394751793L;
        long testLong = HexString.toLong((String)dpidStr);
        Assert.assertEquals((long)valid, (long)testLong);
    }

    @Test
    public void testToLong2() {
        String dpidStr = "1f:1:fc:72:3:f:31";
        long valid = 8727908034219825L;
        long testLong = HexString.toLong((String)dpidStr);
        Assert.assertEquals((long)valid, (long)testLong);
    }

    @Test
    public void testToLongMSB() {
        String dpidStr = "ca:7c:5e:d1:64:7a:95:9b";
        long valid = -3856102927509056101L;
        long testLong = HexString.toLong((String)dpidStr);
        Assert.assertEquals((long)valid, (long)testLong);
    }

    @Test(expected=NumberFormatException.class)
    public void testToLongErrorTooManyBytes() {
        HexString.toLong((String)"09:08:07:06:05:04:03:02:01");
    }

    @Test(expected=NumberFormatException.class)
    public void testToLongErrorByteValueTooLong() {
        HexString.toLong((String)"234:01");
    }

    @Test(expected=NumberFormatException.class)
    public void testToLongErrorEmptyByte() {
        HexString.toLong((String)"03::01");
    }

    @Test(expected=NumberFormatException.class)
    public void testToLongErrorInvalidHexDigit() {
        HexString.toLong((String)"ss:01");
    }

    @Test(expected=NumberFormatException.class)
    public void testToLongErrorEmptyString() {
        HexString.toLong((String)"");
    }

    @Test
    public void testToStringBytes() {
        byte[] dpid = new byte[]{0, 0, 0, 0, 0, 0, 0, -1};
        String valid = "00:00:00:00:00:00:00:ff";
        String testString = HexString.toHexString((byte[])dpid);
        Assert.assertEquals((Object)valid, (Object)testString);
    }

    @Test(expected=NumberFormatException.class)
    public void testFromHexStringError() {
        String invalidStr = "00:00:00:00:00:00:ffff";
        HexString.fromHexString((String)invalidStr);
    }
}

