/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.util;

import com.google.common.collect.ImmutableSortedSet;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.hash.PrimitiveSink;
import java.util.Arrays;
import java.util.SortedSet;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.PrimitiveSinkable;
import org.projectfloodlight.openflow.util.PrimitiveSinkUtils;

public class PrimitiveSinkUtilsTest {
    private HashFunction hash;

    @Before
    public void setup() {
        this.hash = Hashing.murmur3_128();
    }

    @Test
    public void testPutNullableString() {
        HashCode[] hs = new HashCode[]{this.calcPutNullableString(new String[]{null}), this.calcPutNullableString(""), this.calcPutNullableString(null, null), this.calcPutNullableString(null, ""), this.calcPutNullableString("", null), this.calcPutNullableString("a\u0000a", null), this.calcPutNullableString(null, "a\u0000a")};
        this.checkPairwiseDifferent(hs);
    }

    @Test
    public void testPutNullable() {
        HashCode[] hs = new HashCode[]{this.calcPutNullables(new PrimitiveSinkable[0]), this.calcPutNullables(new PrimitiveSinkable[]{OFPort.of((int)1)}), this.calcPutNullables(new PrimitiveSinkable[]{OFPort.of((int)1), null}), this.calcPutNullables(new PrimitiveSinkable[]{OFPort.of((int)1), null, null}), this.calcPutNullables(new PrimitiveSinkable[]{null, OFPort.of((int)1), null}), this.calcPutNullables(new PrimitiveSinkable[]{null, null, OFPort.of((int)1)})};
        this.checkPairwiseDifferent(hs);
    }

    private void checkPairwiseDifferent(HashCode[] hs) {
        for (int i = 0; i < hs.length; ++i) {
            for (int j = i + 1; j < hs.length; ++j) {
                Assert.assertThat((Object)hs[i], (Matcher)CoreMatchers.not((Object)hs[j]));
            }
        }
    }

    @Test
    public void testPutList() {
        HashCode[] hs = new HashCode[]{this.calcPutList(new OFPort[0]), this.calcPutList(OFPort.of((int)1)), this.calcPutList(OFPort.of((int)2)), this.calcPutList(OFPort.of((int)1), OFPort.of((int)2)), this.calcPutList(OFPort.of((int)2), OFPort.of((int)1)), this.calcPutList(OFPort.of((int)1), OFPort.of((int)3)), this.calcPutList(OFPort.of((int)1), OFPort.of((int)2), OFPort.of((int)3))};
        this.checkPairwiseDifferent(hs);
    }

    @Test
    public void testPutSortedSet() {
        HashCode[] hs = new HashCode[]{this.calcPutSortedSet(new OFPort[0]), this.calcPutSortedSet(OFPort.of((int)1)), this.calcPutSortedSet(OFPort.of((int)2)), this.calcPutSortedSet(OFPort.of((int)1), OFPort.of((int)2)), this.calcPutSortedSet(OFPort.of((int)1), OFPort.of((int)3)), this.calcPutSortedSet(OFPort.of((int)1), OFPort.of((int)2), OFPort.of((int)3))};
        this.checkPairwiseDifferent(hs);
        Assert.assertThat((Object)this.calcPutSortedSet(OFPort.of((int)1), OFPort.of((int)2)), (Matcher)CoreMatchers.equalTo((Object)this.calcPutSortedSet(OFPort.of((int)2), OFPort.of((int)1))));
    }

    private HashCode calcPutNullableString(String ... strings) {
        Hasher h = this.hash.newHasher();
        for (String s : strings) {
            PrimitiveSinkUtils.putNullableStringTo((PrimitiveSink)h, (CharSequence)s);
        }
        return h.hash();
    }

    private HashCode calcPutSortedSet(OFPort ... ports) {
        Hasher h = this.hash.newHasher();
        PrimitiveSinkUtils.putSortedSetTo((PrimitiveSink)h, (SortedSet)ImmutableSortedSet.copyOf((Comparable[])ports));
        return h.hash();
    }

    private HashCode calcPutList(OFPort ... ports) {
        Hasher h = this.hash.newHasher();
        PrimitiveSinkUtils.putListTo((PrimitiveSink)h, Arrays.asList(ports));
        return h.hash();
    }

    private HashCode calcPutNullables(PrimitiveSinkable ... ps) {
        Hasher h = this.hash.newHasher();
        for (PrimitiveSinkable p : ps) {
            PrimitiveSinkUtils.putNullableTo((PrimitiveSink)h, (PrimitiveSinkable)p);
        }
        return h.hash();
    }
}

