/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.test;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.primitives.Bytes;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;

public class TestUtils {
    private static final int PER_LINE = 8;

    private TestUtils() {
    }

    public static void betterAssertArrayEquals(byte[] expected, byte[] got) {
        int maxlen = Math.max(expected.length, got.length);
        List<String> expectedList = TestUtils.formatHex(Bytes.asList((byte[])expected));
        List<String> gotList = TestUtils.formatHex(Bytes.asList((byte[])got));
        boolean fail = false;
        for (int i = 0; i < maxlen; i += 8) {
            int maxThisLine = Math.min(maxlen, 8);
            boolean print = false;
            ArrayList<String> changeMarkers = new ArrayList<String>();
            for (int j = i; j < maxThisLine; ++j) {
                if (j >= expected.length || j >= got.length || expected[j] != got[j]) {
                    print = true;
                    fail = true;
                    changeMarkers.add("==");
                    break;
                }
                changeMarkers.add("  ");
            }
            if (!print) continue;
            System.out.println(String.format("%4x: %s", i, Joiner.on((String)" ").join(expectedList.subList(i, Math.min(expectedList.size(), i + 8)))));
            System.out.println(String.format("%4x: %s", i, Joiner.on((String)" ").join(gotList.subList(i, Math.min(gotList.size(), i + 8)))));
            System.out.println(String.format("%4s  %s", "", Joiner.on((String)" ").join(changeMarkers)));
            System.out.println("\n");
        }
        if (fail) {
            Assert.fail((String)"Array comparison failed");
        }
    }

    private static List<String> formatHex(List<Byte> b) {
        return Lists.transform(b, (Function)new Function<Byte, String>(){

            public String apply(Byte input) {
                return String.format("%02x", input);
            }
        });
    }
}

