/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver11;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.Arrays;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFEchoRequest;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFType;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFEchoRequestVer11
implements OFEchoRequest {
    private static final Logger logger = LoggerFactory.getLogger(OFEchoRequestVer11.class);
    static final byte WIRE_VERSION = 2;
    static final int MINIMUM_LENGTH = 8;
    private static final long DEFAULT_XID = 0L;
    private static final byte[] DEFAULT_DATA = new byte[0];
    private final long xid;
    private final byte[] data;
    static final OFEchoRequestVer11 DEFAULT = new OFEchoRequestVer11(0L, DEFAULT_DATA);
    static final Reader READER = new Reader();
    static final OFEchoRequestVer11Funnel FUNNEL = new OFEchoRequestVer11Funnel();
    static final Writer WRITER = new Writer();

    OFEchoRequestVer11(long xid, byte[] data) {
        if (data == null) {
            throw new NullPointerException("OFEchoRequestVer11: property data cannot be null");
        }
        this.xid = xid;
        this.data = data;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_11;
    }

    @Override
    public OFType getType() {
        return OFType.ECHO_REQUEST;
    }

    @Override
    public long getXid() {
        return this.xid;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public OFEchoRequest.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFEchoRequestVer11(");
        b.append("xid=").append(this.xid);
        b.append(", ");
        b.append("data=").append(Arrays.toString(this.data));
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFEchoRequestVer11 other = (OFEchoRequestVer11)obj;
        if (this.xid != other.xid) {
            return false;
        }
        return Arrays.equals(this.data, other.data);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * (int)(this.xid ^ this.xid >>> 32);
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFEchoRequestVer11> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFEchoRequestVer11 message) {
            int startIndex = bb.writerIndex();
            bb.writeByte(2);
            bb.writeByte(2);
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeInt(U32.t(message.xid));
            bb.writeBytes(message.data);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFEchoRequestVer11Funnel
    implements Funnel<OFEchoRequestVer11> {
        private static final long serialVersionUID = 1L;

        OFEchoRequestVer11Funnel() {
        }

        public void funnel(OFEchoRequestVer11 message, PrimitiveSink sink) {
            sink.putByte((byte)2);
            sink.putByte((byte)2);
            sink.putLong(message.xid);
            sink.putBytes(message.data);
        }
    }

    static class Reader
    implements OFMessageReader<OFEchoRequest> {
        Reader() {
        }

        @Override
        public OFEchoRequest readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 2) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_11(2), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 2) {
                throw new OFParseError("Wrong type: Expected=OFType.ECHO_REQUEST(2), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 8) {
                throw new OFParseError("Wrong length: Expected to be >= 8, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            long xid = U32.f(bb.readInt());
            byte[] data = ChannelUtils.readBytes(bb, length - (bb.readerIndex() - start));
            OFEchoRequestVer11 echoRequestVer11 = new OFEchoRequestVer11(xid, data);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)echoRequestVer11);
            }
            return echoRequestVer11;
        }
    }

    static class Builder
    implements OFEchoRequest.Builder {
        private boolean xidSet;
        private long xid;
        private boolean dataSet;
        private byte[] data;

        Builder() {
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFType getType() {
            return OFType.ECHO_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFEchoRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public byte[] getData() {
            return this.data;
        }

        @Override
        public OFEchoRequest.Builder setData(byte[] data) {
            this.data = data;
            this.dataSet = true;
            return this;
        }

        @Override
        public OFEchoRequest build() {
            byte[] data;
            long xid = this.xidSet ? this.xid : 0L;
            byte[] byArray = data = this.dataSet ? this.data : DEFAULT_DATA;
            if (data == null) {
                throw new NullPointerException("Property data must not be null");
            }
            return new OFEchoRequestVer11(xid, data);
        }
    }

    static class BuilderWithParent
    implements OFEchoRequest.Builder {
        final OFEchoRequestVer11 parentMessage;
        private boolean xidSet;
        private long xid;
        private boolean dataSet;
        private byte[] data;

        BuilderWithParent(OFEchoRequestVer11 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_11;
        }

        @Override
        public OFType getType() {
            return OFType.ECHO_REQUEST;
        }

        @Override
        public long getXid() {
            return this.xid;
        }

        @Override
        public OFEchoRequest.Builder setXid(long xid) {
            this.xid = xid;
            this.xidSet = true;
            return this;
        }

        @Override
        public byte[] getData() {
            return this.data;
        }

        @Override
        public OFEchoRequest.Builder setData(byte[] data) {
            this.data = data;
            this.dataSet = true;
            return this;
        }

        @Override
        public OFEchoRequest build() {
            byte[] data;
            long xid = this.xidSet ? this.xid : this.parentMessage.xid;
            byte[] byArray = data = this.dataSet ? this.data : this.parentMessage.data;
            if (data == null) {
                throw new NullPointerException("Property data must not be null");
            }
            return new OFEchoRequestVer11(xid, data);
        }
    }
}

