/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvPartnerSystemPriority;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvPartnerSystemPriorityVer13
implements OFBsnTlvPartnerSystemPriority {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvPartnerSystemPriorityVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 6;
    private static final int DEFAULT_VALUE = 0;
    private final int value;
    static final OFBsnTlvPartnerSystemPriorityVer13 DEFAULT = new OFBsnTlvPartnerSystemPriorityVer13(0);
    static final Reader READER = new Reader();
    static final OFBsnTlvPartnerSystemPriorityVer13Funnel FUNNEL = new OFBsnTlvPartnerSystemPriorityVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvPartnerSystemPriorityVer13(int value) {
        this.value = value;
    }

    @Override
    public int getType() {
        return 47;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvPartnerSystemPriority.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvPartnerSystemPriorityVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvPartnerSystemPriorityVer13 other = (OFBsnTlvPartnerSystemPriorityVer13)obj;
        return this.value == other.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.value;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvPartnerSystemPriorityVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFBsnTlvPartnerSystemPriorityVer13 message) {
            bb.writeShort(47);
            bb.writeShort(6);
            bb.writeShort((int)U16.t(message.value));
        }
    }

    static class OFBsnTlvPartnerSystemPriorityVer13Funnel
    implements Funnel<OFBsnTlvPartnerSystemPriorityVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvPartnerSystemPriorityVer13Funnel() {
        }

        public void funnel(OFBsnTlvPartnerSystemPriorityVer13 message, PrimitiveSink sink) {
            sink.putShort((short)47);
            sink.putShort((short)6);
            sink.putInt(message.value);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvPartnerSystemPriority> {
        Reader() {
        }

        @Override
        public OFBsnTlvPartnerSystemPriority readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 47) {
                throw new OFParseError("Wrong type: Expected=0x2f(0x2f), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 6) {
                throw new OFParseError("Wrong length: Expected=6(6), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            int value = U16.f(bb.readShort());
            OFBsnTlvPartnerSystemPriorityVer13 bsnTlvPartnerSystemPriorityVer13 = new OFBsnTlvPartnerSystemPriorityVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvPartnerSystemPriorityVer13);
            }
            return bsnTlvPartnerSystemPriorityVer13;
        }
    }

    static class Builder
    implements OFBsnTlvPartnerSystemPriority.Builder {
        private boolean valueSet;
        private int value;

        Builder() {
        }

        @Override
        public int getType() {
            return 47;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvPartnerSystemPriority.Builder setValue(int value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvPartnerSystemPriority build() {
            int value = this.valueSet ? this.value : 0;
            return new OFBsnTlvPartnerSystemPriorityVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvPartnerSystemPriority.Builder {
        final OFBsnTlvPartnerSystemPriorityVer13 parentMessage;
        private boolean valueSet;
        private int value;

        BuilderWithParent(OFBsnTlvPartnerSystemPriorityVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 47;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvPartnerSystemPriority.Builder setValue(int value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvPartnerSystemPriority build() {
            int value = this.valueSet ? this.value : this.parentMessage.value;
            return new OFBsnTlvPartnerSystemPriorityVer13(value);
        }
    }
}

