/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.bsntlv.OFBsnTlvPort;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFBsnTlvPortVer13
implements OFBsnTlvPort {
    private static final Logger logger = LoggerFactory.getLogger(OFBsnTlvPortVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 8;
    private static final OFPort DEFAULT_VALUE = OFPort.ANY;
    private final OFPort value;
    static final OFBsnTlvPortVer13 DEFAULT = new OFBsnTlvPortVer13(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFBsnTlvPortVer13Funnel FUNNEL = new OFBsnTlvPortVer13Funnel();
    static final Writer WRITER = new Writer();

    OFBsnTlvPortVer13(OFPort value) {
        if (value == null) {
            throw new NullPointerException("OFBsnTlvPortVer13: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public OFPort getValue() {
        return this.value;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFBsnTlvPort.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFBsnTlvPortVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFBsnTlvPortVer13 other = (OFBsnTlvPortVer13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFBsnTlvPortVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFBsnTlvPortVer13 message) {
            bb.writeShort(0);
            bb.writeShort(8);
            message.value.write4Bytes(bb);
        }
    }

    static class OFBsnTlvPortVer13Funnel
    implements Funnel<OFBsnTlvPortVer13> {
        private static final long serialVersionUID = 1L;

        OFBsnTlvPortVer13Funnel() {
        }

        public void funnel(OFBsnTlvPortVer13 message, PrimitiveSink sink) {
            sink.putShort((short)0);
            sink.putShort((short)8);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFBsnTlvPort> {
        Reader() {
        }

        @Override
        public OFBsnTlvPort readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 0) {
                throw new OFParseError("Wrong type: Expected=0x0(0x0), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            OFPort value = OFPort.read4Bytes(bb);
            OFBsnTlvPortVer13 bsnTlvPortVer13 = new OFBsnTlvPortVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)bsnTlvPortVer13);
            }
            return bsnTlvPortVer13;
        }
    }

    static class Builder
    implements OFBsnTlvPort.Builder {
        private boolean valueSet;
        private OFPort value;

        Builder() {
        }

        @Override
        public int getType() {
            return 0;
        }

        @Override
        public OFPort getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvPort.Builder setValue(OFPort value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvPort build() {
            OFPort value;
            OFPort oFPort = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvPortVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFBsnTlvPort.Builder {
        final OFBsnTlvPortVer13 parentMessage;
        private boolean valueSet;
        private OFPort value;

        BuilderWithParent(OFBsnTlvPortVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 0;
        }

        @Override
        public OFPort getValue() {
            return this.value;
        }

        @Override
        public OFBsnTlvPort.Builder setValue(OFPort value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFBsnTlvPort build() {
            OFPort value;
            OFPort oFPort = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFBsnTlvPortVer13(value);
        }
    }
}

