/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFExpExtAdId;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.ver13.OFExpExtAdidSonetVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFExpPortAdidOtnVer13;
import org.projectfloodlight.openflow.types.U16;

abstract class OFExpExtAdIdVer13 {
    static final byte WIRE_VERSION = 4;
    static final int MINIMUM_LENGTH = 8;
    public static final Reader READER = new Reader();

    OFExpExtAdIdVer13() {
    }

    static class Reader
    implements OFMessageReader<OFExpExtAdId> {
        Reader() {
        }

        @Override
        public OFExpExtAdId readFrom(ChannelBuffer bb) throws OFParseError {
            if (bb.readableBytes() < 8) {
                return null;
            }
            int start = bb.readerIndex();
            U16.f(bb.readShort());
            int length = U16.f(bb.readShort());
            if (length < 8) {
                throw new OFParseError("Wrong length: Expected to be >= 8, was: " + length);
            }
            short namespace = bb.readShort();
            if (namespace != 0) {
                throw new OFParseError("Wrong namespace: Expected=0x0(0x0), got=" + namespace);
            }
            short nsType = bb.readShort();
            bb.readerIndex(start);
            switch (nsType) {
                case 1: {
                    return OFExpExtAdidSonetVer13.READER.readFrom(bb);
                }
                case 0: {
                    return OFExpPortAdidOtnVer13.READER.readFrom(bb);
                }
            }
            throw new OFParseError("Unknown value for discriminator nsType of class OFExpExtAdIdVer13: " + nsType);
        }
    }
}

