/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmBsnInnerVlanVidMasked;
import org.projectfloodlight.openflow.protocol.ver13.OFOxmBsnInnerVlanVidVer13;
import org.projectfloodlight.openflow.types.OFVlanVidMatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmBsnInnerVlanVidMaskedVer13
implements OFOxmBsnInnerVlanVidMasked {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmBsnInnerVlanVidMaskedVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 8;
    private static final OFVlanVidMatch DEFAULT_VALUE = OFVlanVidMatch.NONE;
    private static final OFVlanVidMatch DEFAULT_VALUE_MASK = OFVlanVidMatch.NONE;
    private final OFVlanVidMatch value;
    private final OFVlanVidMatch mask;
    static final OFOxmBsnInnerVlanVidMaskedVer13 DEFAULT = new OFOxmBsnInnerVlanVidMaskedVer13(DEFAULT_VALUE, DEFAULT_VALUE_MASK);
    static final Reader READER = new Reader();
    static final OFOxmBsnInnerVlanVidMaskedVer13Funnel FUNNEL = new OFOxmBsnInnerVlanVidMaskedVer13Funnel();
    static final Writer WRITER = new Writer();

    OFOxmBsnInnerVlanVidMaskedVer13(OFVlanVidMatch value, OFVlanVidMatch mask) {
        if (value == null) {
            throw new NullPointerException("OFOxmBsnInnerVlanVidMaskedVer13: property value cannot be null");
        }
        if (mask == null) {
            throw new NullPointerException("OFOxmBsnInnerVlanVidMaskedVer13: property mask cannot be null");
        }
        this.value = value;
        this.mask = mask;
    }

    @Override
    public long getTypeLen() {
        return 209156L;
    }

    @Override
    public OFVlanVidMatch getValue() {
        return this.value;
    }

    @Override
    public OFVlanVidMatch getMask() {
        return this.mask;
    }

    @Override
    public MatchField<OFVlanVidMatch> getMatchField() {
        return MatchField.BSN_INNER_VLAN_VID;
    }

    @Override
    public boolean isMasked() {
        return true;
    }

    @Override
    public OFOxm<OFVlanVidMatch> getCanonical() {
        if (OFVlanVidMatch.NO_MASK.equals(this.mask)) {
            return new OFOxmBsnInnerVlanVidVer13(this.value);
        }
        if (OFVlanVidMatch.FULL_MASK.equals(this.mask)) {
            return null;
        }
        return this;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFOxmBsnInnerVlanVidMasked.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmBsnInnerVlanVidMaskedVer13(");
        b.append("value=").append(this.value);
        b.append(", ");
        b.append("mask=").append(this.mask);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmBsnInnerVlanVidMaskedVer13 other = (OFOxmBsnInnerVlanVidMaskedVer13)obj;
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return !(this.mask == null ? other.mask != null : !this.mask.equals(other.mask));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        result = 31 * result + (this.mask == null ? 0 : this.mask.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmBsnInnerVlanVidMaskedVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFOxmBsnInnerVlanVidMaskedVer13 message) {
            bb.writeInt(209156);
            message.value.write2Bytes(bb);
            message.mask.write2Bytes(bb);
        }
    }

    static class OFOxmBsnInnerVlanVidMaskedVer13Funnel
    implements Funnel<OFOxmBsnInnerVlanVidMaskedVer13> {
        private static final long serialVersionUID = 1L;

        OFOxmBsnInnerVlanVidMaskedVer13Funnel() {
        }

        public void funnel(OFOxmBsnInnerVlanVidMaskedVer13 message, PrimitiveSink sink) {
            sink.putInt(209156);
            message.value.putTo(sink);
            message.mask.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmBsnInnerVlanVidMasked> {
        Reader() {
        }

        @Override
        public OFOxmBsnInnerVlanVidMasked readFrom(ChannelBuffer bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != 209156) {
                throw new OFParseError("Wrong typeLen: Expected=0x33104L(0x33104L), got=" + typeLen);
            }
            OFVlanVidMatch value = OFVlanVidMatch.read2Bytes(bb);
            OFVlanVidMatch mask = OFVlanVidMatch.read2Bytes(bb);
            OFOxmBsnInnerVlanVidMaskedVer13 oxmBsnInnerVlanVidMaskedVer13 = new OFOxmBsnInnerVlanVidMaskedVer13(value, mask);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmBsnInnerVlanVidMaskedVer13);
            }
            return oxmBsnInnerVlanVidMaskedVer13;
        }
    }

    static class Builder
    implements OFOxmBsnInnerVlanVidMasked.Builder {
        private boolean valueSet;
        private OFVlanVidMatch value;
        private boolean maskSet;
        private OFVlanVidMatch mask;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 209156L;
        }

        @Override
        public OFVlanVidMatch getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnInnerVlanVidMasked.Builder setValue(OFVlanVidMatch value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVlanVidMatch getMask() {
            return this.mask;
        }

        @Override
        public OFOxmBsnInnerVlanVidMasked.Builder setMask(OFVlanVidMatch mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<OFVlanVidMatch> getMatchField() {
            return MatchField.BSN_INNER_VLAN_VID;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<OFVlanVidMatch> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmBsnInnerVlanVidMasked build() {
            OFVlanVidMatch mask;
            OFVlanVidMatch value;
            OFVlanVidMatch oFVlanVidMatch = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            OFVlanVidMatch oFVlanVidMatch2 = mask = this.maskSet ? this.mask : DEFAULT_VALUE_MASK;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmBsnInnerVlanVidMaskedVer13(value, mask);
        }
    }

    static class BuilderWithParent
    implements OFOxmBsnInnerVlanVidMasked.Builder {
        final OFOxmBsnInnerVlanVidMaskedVer13 parentMessage;
        private boolean valueSet;
        private OFVlanVidMatch value;
        private boolean maskSet;
        private OFVlanVidMatch mask;

        BuilderWithParent(OFOxmBsnInnerVlanVidMaskedVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 209156L;
        }

        @Override
        public OFVlanVidMatch getValue() {
            return this.value;
        }

        @Override
        public OFOxmBsnInnerVlanVidMasked.Builder setValue(OFVlanVidMatch value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public OFVlanVidMatch getMask() {
            return this.mask;
        }

        @Override
        public OFOxmBsnInnerVlanVidMasked.Builder setMask(OFVlanVidMatch mask) {
            this.mask = mask;
            this.maskSet = true;
            return this;
        }

        @Override
        public MatchField<OFVlanVidMatch> getMatchField() {
            return MatchField.BSN_INNER_VLAN_VID;
        }

        @Override
        public boolean isMasked() {
            return true;
        }

        @Override
        public OFOxm<OFVlanVidMatch> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmBsnInnerVlanVidMasked build() {
            OFVlanVidMatch mask;
            OFVlanVidMatch value;
            OFVlanVidMatch oFVlanVidMatch = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            OFVlanVidMatch oFVlanVidMatch2 = mask = this.maskSet ? this.mask : this.parentMessage.mask;
            if (mask == null) {
                throw new NullPointerException("Property mask must not be null");
            }
            return new OFOxmBsnInnerVlanVidMaskedVer13(value, mask);
        }
    }
}

