/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmExpOchSigId;
import org.projectfloodlight.openflow.types.CircuitSignalID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmExpOchSigIdVer13
implements OFOxmExpOchSigId {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmExpOchSigIdVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 14;
    private static final CircuitSignalID DEFAULT_VALUE = CircuitSignalID.NONE;
    private final CircuitSignalID value;
    static final OFOxmExpOchSigIdVer13 DEFAULT = new OFOxmExpOchSigIdVer13(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmExpOchSigIdVer13Funnel FUNNEL = new OFOxmExpOchSigIdVer13Funnel();
    static final Writer WRITER = new Writer();

    OFOxmExpOchSigIdVer13(CircuitSignalID value) {
        if (value == null) {
            throw new NullPointerException("OFOxmExpOchSigIdVer13: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 4294904326L;
    }

    @Override
    public long getExperimenter() {
        return 0xFF000007L;
    }

    @Override
    public CircuitSignalID getValue() {
        return this.value;
    }

    @Override
    public MatchField<CircuitSignalID> getMatchField() {
        return MatchField.EXP_OCH_SIG_ID;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<CircuitSignalID> getCanonical() {
        return this;
    }

    @Override
    public CircuitSignalID getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.3");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFOxmExpOchSigId.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmExpOchSigIdVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmExpOchSigIdVer13 other = (OFOxmExpOchSigIdVer13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmExpOchSigIdVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFOxmExpOchSigIdVer13 message) {
            bb.writeInt(-62970);
            bb.writeInt(-16777209);
            message.value.write6Bytes(bb);
        }
    }

    static class OFOxmExpOchSigIdVer13Funnel
    implements Funnel<OFOxmExpOchSigIdVer13> {
        private static final long serialVersionUID = 1L;

        OFOxmExpOchSigIdVer13Funnel() {
        }

        public void funnel(OFOxmExpOchSigIdVer13 message, PrimitiveSink sink) {
            sink.putInt(-62970);
            sink.putInt(-16777209);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmExpOchSigId> {
        Reader() {
        }

        @Override
        public OFOxmExpOchSigId readFrom(ChannelBuffer bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -62970) {
                throw new OFParseError("Wrong typeLen: Expected=0xffff0a06L(0xffff0a06L), got=" + typeLen);
            }
            int experimenter = bb.readInt();
            if (experimenter != -16777209) {
                throw new OFParseError("Wrong experimenter: Expected=0xff000007L(0xff000007L), got=" + experimenter);
            }
            CircuitSignalID value = CircuitSignalID.read6Bytes(bb);
            OFOxmExpOchSigIdVer13 oxmExpOchSigIdVer13 = new OFOxmExpOchSigIdVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmExpOchSigIdVer13);
            }
            return oxmExpOchSigIdVer13;
        }
    }

    static class Builder
    implements OFOxmExpOchSigId.Builder {
        private boolean valueSet;
        private CircuitSignalID value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 4294904326L;
        }

        @Override
        public long getExperimenter() {
            return 0xFF000007L;
        }

        @Override
        public CircuitSignalID getValue() {
            return this.value;
        }

        @Override
        public OFOxmExpOchSigId.Builder setValue(CircuitSignalID value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<CircuitSignalID> getMatchField() {
            return MatchField.EXP_OCH_SIG_ID;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<CircuitSignalID> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public CircuitSignalID getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmExpOchSigId build() {
            CircuitSignalID value;
            CircuitSignalID circuitSignalID = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmExpOchSigIdVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmExpOchSigId.Builder {
        final OFOxmExpOchSigIdVer13 parentMessage;
        private boolean valueSet;
        private CircuitSignalID value;

        BuilderWithParent(OFOxmExpOchSigIdVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 4294904326L;
        }

        @Override
        public long getExperimenter() {
            return 0xFF000007L;
        }

        @Override
        public CircuitSignalID getValue() {
            return this.value;
        }

        @Override
        public OFOxmExpOchSigId.Builder setValue(CircuitSignalID value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<CircuitSignalID> getMatchField() {
            return MatchField.EXP_OCH_SIG_ID;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<CircuitSignalID> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public CircuitSignalID getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmExpOchSigId build() {
            CircuitSignalID value;
            CircuitSignalID circuitSignalID = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmExpOchSigIdVer13(value);
        }
    }
}

