/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmOfdpaMplsType;
import org.projectfloodlight.openflow.types.U16;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmOfdpaMplsTypeVer13
implements OFOxmOfdpaMplsType {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmOfdpaMplsTypeVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 10;
    private static final U16 DEFAULT_VALUE = U16.ZERO;
    private final U16 value;
    static final OFOxmOfdpaMplsTypeVer13 DEFAULT = new OFOxmOfdpaMplsTypeVer13(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmOfdpaMplsTypeVer13Funnel FUNNEL = new OFOxmOfdpaMplsTypeVer13Funnel();
    static final Writer WRITER = new Writer();

    OFOxmOfdpaMplsTypeVer13(U16 value) {
        if (value == null) {
            throw new NullPointerException("OFOxmOfdpaMplsTypeVer13: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 4294913542L;
    }

    @Override
    public long getExperimenterId() {
        return 4120L;
    }

    @Override
    public U16 getValue() {
        return this.value;
    }

    @Override
    public MatchField<U16> getMatchField() {
        return MatchField.OFDPA_MPLS_TYPE;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<U16> getCanonical() {
        return this;
    }

    @Override
    public U16 getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.3");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFOxmOfdpaMplsType.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmOfdpaMplsTypeVer13(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmOfdpaMplsTypeVer13 other = (OFOxmOfdpaMplsTypeVer13)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmOfdpaMplsTypeVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFOxmOfdpaMplsTypeVer13 message) {
            bb.writeInt(-53754);
            bb.writeInt(4120);
            bb.writeShort((int)message.value.getRaw());
        }
    }

    static class OFOxmOfdpaMplsTypeVer13Funnel
    implements Funnel<OFOxmOfdpaMplsTypeVer13> {
        private static final long serialVersionUID = 1L;

        OFOxmOfdpaMplsTypeVer13Funnel() {
        }

        public void funnel(OFOxmOfdpaMplsTypeVer13 message, PrimitiveSink sink) {
            sink.putInt(-53754);
            sink.putInt(4120);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmOfdpaMplsType> {
        Reader() {
        }

        @Override
        public OFOxmOfdpaMplsType readFrom(ChannelBuffer bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -53754) {
                throw new OFParseError("Wrong typeLen: Expected=0xffff2e06L(0xffff2e06L), got=" + typeLen);
            }
            int experimenterId = bb.readInt();
            if (experimenterId != 4120) {
                throw new OFParseError("Wrong experimenterId: Expected=0x1018L(0x1018L), got=" + experimenterId);
            }
            U16 value = U16.of(bb.readShort());
            OFOxmOfdpaMplsTypeVer13 oxmOfdpaMplsTypeVer13 = new OFOxmOfdpaMplsTypeVer13(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmOfdpaMplsTypeVer13);
            }
            return oxmOfdpaMplsTypeVer13;
        }
    }

    static class Builder
    implements OFOxmOfdpaMplsType.Builder {
        private boolean valueSet;
        private U16 value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 4294913542L;
        }

        @Override
        public long getExperimenterId() {
            return 4120L;
        }

        @Override
        public U16 getValue() {
            return this.value;
        }

        @Override
        public OFOxmOfdpaMplsType.Builder setValue(U16 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U16> getMatchField() {
            return MatchField.OFDPA_MPLS_TYPE;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U16> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public U16 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmOfdpaMplsType build() {
            U16 value;
            U16 u16 = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmOfdpaMplsTypeVer13(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmOfdpaMplsType.Builder {
        final OFOxmOfdpaMplsTypeVer13 parentMessage;
        private boolean valueSet;
        private U16 value;

        BuilderWithParent(OFOxmOfdpaMplsTypeVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 4294913542L;
        }

        @Override
        public long getExperimenterId() {
            return 4120L;
        }

        @Override
        public U16 getValue() {
            return this.value;
        }

        @Override
        public OFOxmOfdpaMplsType.Builder setValue(U16 value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<U16> getMatchField() {
            return MatchField.OFDPA_MPLS_TYPE;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<U16> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.3");
        }

        @Override
        public U16 getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFOxmOfdpaMplsType build() {
            U16 value;
            U16 u16 = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmOfdpaMplsTypeVer13(value);
        }
    }
}

