/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.collect.ImmutableList;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFPortOpticalTransportLayerEntry;
import org.projectfloodlight.openflow.protocol.OFPortOpticalTransportLayerStack;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.ver13.OFPortOpticalTransportLayerEntryVer13;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.util.ChannelUtils;
import org.projectfloodlight.openflow.util.FunnelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFPortOpticalTransportLayerStackVer13
implements OFPortOpticalTransportLayerStack {
    private static final Logger logger = LoggerFactory.getLogger(OFPortOpticalTransportLayerStackVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int MINIMUM_LENGTH = 8;
    private static final int DEFAULT_FEATURE_TYPE = 0;
    private static final List<OFPortOpticalTransportLayerEntry> DEFAULT_ENTRIES = ImmutableList.of();
    private final int featureType;
    private final List<OFPortOpticalTransportLayerEntry> entries;
    static final OFPortOpticalTransportLayerStackVer13 DEFAULT = new OFPortOpticalTransportLayerStackVer13(0, DEFAULT_ENTRIES);
    static final Reader READER = new Reader();
    static final OFPortOpticalTransportLayerStackVer13Funnel FUNNEL = new OFPortOpticalTransportLayerStackVer13Funnel();
    static final Writer WRITER = new Writer();

    OFPortOpticalTransportLayerStackVer13(int featureType, List<OFPortOpticalTransportLayerEntry> entries) {
        if (entries == null) {
            throw new NullPointerException("OFPortOpticalTransportLayerStackVer13: property entries cannot be null");
        }
        this.featureType = featureType;
        this.entries = entries;
    }

    @Override
    public int getFeatureType() {
        return this.featureType;
    }

    @Override
    public List<OFPortOpticalTransportLayerEntry> getEntries() {
        return this.entries;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFPortOpticalTransportLayerStack.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFPortOpticalTransportLayerStackVer13(");
        b.append("featureType=").append(this.featureType);
        b.append(", ");
        b.append("entries=").append(this.entries);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFPortOpticalTransportLayerStackVer13 other = (OFPortOpticalTransportLayerStackVer13)obj;
        if (this.featureType != other.featureType) {
            return false;
        }
        return !(this.entries == null ? other.entries != null : !this.entries.equals(other.entries));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.featureType;
        result = 31 * result + (this.entries == null ? 0 : this.entries.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFPortOpticalTransportLayerStackVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFPortOpticalTransportLayerStackVer13 message) {
            int startIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(message.featureType));
            int lengthIndex = bb.writerIndex();
            bb.writeShort((int)U16.t(0));
            bb.writeZero(4);
            ChannelUtils.writeList(bb, message.entries);
            int length = bb.writerIndex() - startIndex;
            bb.setShort(lengthIndex, length);
        }
    }

    static class OFPortOpticalTransportLayerStackVer13Funnel
    implements Funnel<OFPortOpticalTransportLayerStackVer13> {
        private static final long serialVersionUID = 1L;

        OFPortOpticalTransportLayerStackVer13Funnel() {
        }

        public void funnel(OFPortOpticalTransportLayerStackVer13 message, PrimitiveSink sink) {
            sink.putInt(message.featureType);
            FunnelUtils.putList(message.entries, sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFPortOpticalTransportLayerStack> {
        Reader() {
        }

        @Override
        public OFPortOpticalTransportLayerStack readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            int featureType = U16.f(bb.readShort());
            int length = U16.f(bb.readShort());
            if (length < 8) {
                throw new OFParseError("Wrong length: Expected to be >= 8, was: " + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            bb.skipBytes(4);
            List<OFPortOpticalTransportLayerEntry> entries = ChannelUtils.readList(bb, length - (bb.readerIndex() - start), OFPortOpticalTransportLayerEntryVer13.READER);
            OFPortOpticalTransportLayerStackVer13 portOpticalTransportLayerStackVer13 = new OFPortOpticalTransportLayerStackVer13(featureType, entries);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)portOpticalTransportLayerStackVer13);
            }
            return portOpticalTransportLayerStackVer13;
        }
    }

    static class Builder
    implements OFPortOpticalTransportLayerStack.Builder {
        private boolean featureTypeSet;
        private int featureType;
        private boolean entriesSet;
        private List<OFPortOpticalTransportLayerEntry> entries;

        Builder() {
        }

        @Override
        public int getFeatureType() {
            return this.featureType;
        }

        @Override
        public OFPortOpticalTransportLayerStack.Builder setFeatureType(int featureType) {
            this.featureType = featureType;
            this.featureTypeSet = true;
            return this;
        }

        @Override
        public List<OFPortOpticalTransportLayerEntry> getEntries() {
            return this.entries;
        }

        @Override
        public OFPortOpticalTransportLayerStack.Builder setEntries(List<OFPortOpticalTransportLayerEntry> entries) {
            this.entries = entries;
            this.entriesSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFPortOpticalTransportLayerStack build() {
            List<OFPortOpticalTransportLayerEntry> entries;
            int featureType = this.featureTypeSet ? this.featureType : 0;
            List<OFPortOpticalTransportLayerEntry> list = entries = this.entriesSet ? this.entries : DEFAULT_ENTRIES;
            if (entries == null) {
                throw new NullPointerException("Property entries must not be null");
            }
            return new OFPortOpticalTransportLayerStackVer13(featureType, entries);
        }
    }

    static class BuilderWithParent
    implements OFPortOpticalTransportLayerStack.Builder {
        final OFPortOpticalTransportLayerStackVer13 parentMessage;
        private boolean featureTypeSet;
        private int featureType;
        private boolean entriesSet;
        private List<OFPortOpticalTransportLayerEntry> entries;

        BuilderWithParent(OFPortOpticalTransportLayerStackVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getFeatureType() {
            return this.featureType;
        }

        @Override
        public OFPortOpticalTransportLayerStack.Builder setFeatureType(int featureType) {
            this.featureType = featureType;
            this.featureTypeSet = true;
            return this;
        }

        @Override
        public List<OFPortOpticalTransportLayerEntry> getEntries() {
            return this.entries;
        }

        @Override
        public OFPortOpticalTransportLayerStack.Builder setEntries(List<OFPortOpticalTransportLayerEntry> entries) {
            this.entries = entries;
            this.entriesSet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFPortOpticalTransportLayerStack build() {
            List entries;
            int featureType = this.featureTypeSet ? this.featureType : this.parentMessage.featureType;
            List list = entries = this.entriesSet ? this.entries : this.parentMessage.entries;
            if (entries == null) {
                throw new NullPointerException("Property entries must not be null");
            }
            return new OFPortOpticalTransportLayerStackVer13(featureType, entries);
        }
    }
}

