/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFQueueStatsEntry;
import org.projectfloodlight.openflow.protocol.OFQueueStatsProp;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.OFPort;
import org.projectfloodlight.openflow.types.U32;
import org.projectfloodlight.openflow.types.U64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFQueueStatsEntryVer13
implements OFQueueStatsEntry {
    private static final Logger logger = LoggerFactory.getLogger(OFQueueStatsEntryVer13.class);
    static final byte WIRE_VERSION = 4;
    static final int LENGTH = 40;
    private static final OFPort DEFAULT_PORT_NO = OFPort.ANY;
    private static final long DEFAULT_QUEUE_ID = 0L;
    private static final U64 DEFAULT_TX_BYTES = U64.ZERO;
    private static final U64 DEFAULT_TX_PACKETS = U64.ZERO;
    private static final U64 DEFAULT_TX_ERRORS = U64.ZERO;
    private static final long DEFAULT_DURATION_SEC = 0L;
    private static final long DEFAULT_DURATION_NSEC = 0L;
    private final OFPort portNo;
    private final long queueId;
    private final U64 txBytes;
    private final U64 txPackets;
    private final U64 txErrors;
    private final long durationSec;
    private final long durationNsec;
    static final OFQueueStatsEntryVer13 DEFAULT = new OFQueueStatsEntryVer13(DEFAULT_PORT_NO, 0L, DEFAULT_TX_BYTES, DEFAULT_TX_PACKETS, DEFAULT_TX_ERRORS, 0L, 0L);
    static final Reader READER = new Reader();
    static final OFQueueStatsEntryVer13Funnel FUNNEL = new OFQueueStatsEntryVer13Funnel();
    static final Writer WRITER = new Writer();

    OFQueueStatsEntryVer13(OFPort portNo, long queueId, U64 txBytes, U64 txPackets, U64 txErrors, long durationSec, long durationNsec) {
        if (portNo == null) {
            throw new NullPointerException("OFQueueStatsEntryVer13: property portNo cannot be null");
        }
        if (txBytes == null) {
            throw new NullPointerException("OFQueueStatsEntryVer13: property txBytes cannot be null");
        }
        if (txPackets == null) {
            throw new NullPointerException("OFQueueStatsEntryVer13: property txPackets cannot be null");
        }
        if (txErrors == null) {
            throw new NullPointerException("OFQueueStatsEntryVer13: property txErrors cannot be null");
        }
        this.portNo = portNo;
        this.queueId = queueId;
        this.txBytes = txBytes;
        this.txPackets = txPackets;
        this.txErrors = txErrors;
        this.durationSec = durationSec;
        this.durationNsec = durationNsec;
    }

    @Override
    public OFPort getPortNo() {
        return this.portNo;
    }

    @Override
    public long getQueueId() {
        return this.queueId;
    }

    @Override
    public U64 getTxBytes() {
        return this.txBytes;
    }

    @Override
    public U64 getTxPackets() {
        return this.txPackets;
    }

    @Override
    public U64 getTxErrors() {
        return this.txErrors;
    }

    @Override
    public long getDurationSec() {
        return this.durationSec;
    }

    @Override
    public long getDurationNsec() {
        return this.durationNsec;
    }

    @Override
    public List<OFQueueStatsProp> getProperties() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property properties not supported in version 1.3");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_13;
    }

    @Override
    public OFQueueStatsEntry.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFQueueStatsEntryVer13(");
        b.append("portNo=").append(this.portNo);
        b.append(", ");
        b.append("queueId=").append(this.queueId);
        b.append(", ");
        b.append("txBytes=").append(this.txBytes);
        b.append(", ");
        b.append("txPackets=").append(this.txPackets);
        b.append(", ");
        b.append("txErrors=").append(this.txErrors);
        b.append(", ");
        b.append("durationSec=").append(this.durationSec);
        b.append(", ");
        b.append("durationNsec=").append(this.durationNsec);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFQueueStatsEntryVer13 other = (OFQueueStatsEntryVer13)obj;
        if (this.portNo == null ? other.portNo != null : !this.portNo.equals(other.portNo)) {
            return false;
        }
        if (this.queueId != other.queueId) {
            return false;
        }
        if (this.txBytes == null ? other.txBytes != null : !this.txBytes.equals(other.txBytes)) {
            return false;
        }
        if (this.txPackets == null ? other.txPackets != null : !this.txPackets.equals(other.txPackets)) {
            return false;
        }
        if (this.txErrors == null ? other.txErrors != null : !this.txErrors.equals(other.txErrors)) {
            return false;
        }
        if (this.durationSec != other.durationSec) {
            return false;
        }
        return this.durationNsec == other.durationNsec;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.portNo == null ? 0 : this.portNo.hashCode());
        result = 31 * (int)(this.queueId ^ this.queueId >>> 32);
        result = 31 * result + (this.txBytes == null ? 0 : this.txBytes.hashCode());
        result = 31 * result + (this.txPackets == null ? 0 : this.txPackets.hashCode());
        result = 31 * result + (this.txErrors == null ? 0 : this.txErrors.hashCode());
        result = 31 * (int)(this.durationSec ^ this.durationSec >>> 32);
        result = 31 * (int)(this.durationNsec ^ this.durationNsec >>> 32);
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFQueueStatsEntryVer13> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFQueueStatsEntryVer13 message) {
            message.portNo.write4Bytes(bb);
            bb.writeInt(U32.t(message.queueId));
            bb.writeLong(message.txBytes.getValue());
            bb.writeLong(message.txPackets.getValue());
            bb.writeLong(message.txErrors.getValue());
            bb.writeInt(U32.t(message.durationSec));
            bb.writeInt(U32.t(message.durationNsec));
        }
    }

    static class OFQueueStatsEntryVer13Funnel
    implements Funnel<OFQueueStatsEntryVer13> {
        private static final long serialVersionUID = 1L;

        OFQueueStatsEntryVer13Funnel() {
        }

        public void funnel(OFQueueStatsEntryVer13 message, PrimitiveSink sink) {
            message.portNo.putTo(sink);
            sink.putLong(message.queueId);
            message.txBytes.putTo(sink);
            message.txPackets.putTo(sink);
            message.txErrors.putTo(sink);
            sink.putLong(message.durationSec);
            sink.putLong(message.durationNsec);
        }
    }

    static class Reader
    implements OFMessageReader<OFQueueStatsEntry> {
        Reader() {
        }

        @Override
        public OFQueueStatsEntry readFrom(ChannelBuffer bb) throws OFParseError {
            OFPort portNo = OFPort.read4Bytes(bb);
            long queueId = U32.f(bb.readInt());
            U64 txBytes = U64.ofRaw(bb.readLong());
            U64 txPackets = U64.ofRaw(bb.readLong());
            U64 txErrors = U64.ofRaw(bb.readLong());
            long durationSec = U32.f(bb.readInt());
            long durationNsec = U32.f(bb.readInt());
            OFQueueStatsEntryVer13 queueStatsEntryVer13 = new OFQueueStatsEntryVer13(portNo, queueId, txBytes, txPackets, txErrors, durationSec, durationNsec);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)queueStatsEntryVer13);
            }
            return queueStatsEntryVer13;
        }
    }

    static class Builder
    implements OFQueueStatsEntry.Builder {
        private boolean portNoSet;
        private OFPort portNo;
        private boolean queueIdSet;
        private long queueId;
        private boolean txBytesSet;
        private U64 txBytes;
        private boolean txPacketsSet;
        private U64 txPackets;
        private boolean txErrorsSet;
        private U64 txErrors;
        private boolean durationSecSet;
        private long durationSec;
        private boolean durationNsecSet;
        private long durationNsec;

        Builder() {
        }

        @Override
        public OFPort getPortNo() {
            return this.portNo;
        }

        @Override
        public OFQueueStatsEntry.Builder setPortNo(OFPort portNo) {
            this.portNo = portNo;
            this.portNoSet = true;
            return this;
        }

        @Override
        public long getQueueId() {
            return this.queueId;
        }

        @Override
        public OFQueueStatsEntry.Builder setQueueId(long queueId) {
            this.queueId = queueId;
            this.queueIdSet = true;
            return this;
        }

        @Override
        public U64 getTxBytes() {
            return this.txBytes;
        }

        @Override
        public OFQueueStatsEntry.Builder setTxBytes(U64 txBytes) {
            this.txBytes = txBytes;
            this.txBytesSet = true;
            return this;
        }

        @Override
        public U64 getTxPackets() {
            return this.txPackets;
        }

        @Override
        public OFQueueStatsEntry.Builder setTxPackets(U64 txPackets) {
            this.txPackets = txPackets;
            this.txPacketsSet = true;
            return this;
        }

        @Override
        public U64 getTxErrors() {
            return this.txErrors;
        }

        @Override
        public OFQueueStatsEntry.Builder setTxErrors(U64 txErrors) {
            this.txErrors = txErrors;
            this.txErrorsSet = true;
            return this;
        }

        @Override
        public long getDurationSec() {
            return this.durationSec;
        }

        @Override
        public OFQueueStatsEntry.Builder setDurationSec(long durationSec) {
            this.durationSec = durationSec;
            this.durationSecSet = true;
            return this;
        }

        @Override
        public long getDurationNsec() {
            return this.durationNsec;
        }

        @Override
        public OFQueueStatsEntry.Builder setDurationNsec(long durationNsec) {
            this.durationNsec = durationNsec;
            this.durationNsecSet = true;
            return this;
        }

        @Override
        public List<OFQueueStatsProp> getProperties() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property properties not supported in version 1.3");
        }

        @Override
        public OFQueueStatsEntry.Builder setProperties(List<OFQueueStatsProp> properties) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property properties not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFQueueStatsEntry build() {
            U64 txErrors;
            U64 txPackets;
            U64 txBytes;
            OFPort portNo;
            OFPort oFPort = portNo = this.portNoSet ? this.portNo : DEFAULT_PORT_NO;
            if (portNo == null) {
                throw new NullPointerException("Property portNo must not be null");
            }
            long queueId = this.queueIdSet ? this.queueId : 0L;
            U64 u64 = txBytes = this.txBytesSet ? this.txBytes : DEFAULT_TX_BYTES;
            if (txBytes == null) {
                throw new NullPointerException("Property txBytes must not be null");
            }
            U64 u642 = txPackets = this.txPacketsSet ? this.txPackets : DEFAULT_TX_PACKETS;
            if (txPackets == null) {
                throw new NullPointerException("Property txPackets must not be null");
            }
            U64 u643 = txErrors = this.txErrorsSet ? this.txErrors : DEFAULT_TX_ERRORS;
            if (txErrors == null) {
                throw new NullPointerException("Property txErrors must not be null");
            }
            long durationSec = this.durationSecSet ? this.durationSec : 0L;
            long durationNsec = this.durationNsecSet ? this.durationNsec : 0L;
            return new OFQueueStatsEntryVer13(portNo, queueId, txBytes, txPackets, txErrors, durationSec, durationNsec);
        }
    }

    static class BuilderWithParent
    implements OFQueueStatsEntry.Builder {
        final OFQueueStatsEntryVer13 parentMessage;
        private boolean portNoSet;
        private OFPort portNo;
        private boolean queueIdSet;
        private long queueId;
        private boolean txBytesSet;
        private U64 txBytes;
        private boolean txPacketsSet;
        private U64 txPackets;
        private boolean txErrorsSet;
        private U64 txErrors;
        private boolean durationSecSet;
        private long durationSec;
        private boolean durationNsecSet;
        private long durationNsec;

        BuilderWithParent(OFQueueStatsEntryVer13 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public OFPort getPortNo() {
            return this.portNo;
        }

        @Override
        public OFQueueStatsEntry.Builder setPortNo(OFPort portNo) {
            this.portNo = portNo;
            this.portNoSet = true;
            return this;
        }

        @Override
        public long getQueueId() {
            return this.queueId;
        }

        @Override
        public OFQueueStatsEntry.Builder setQueueId(long queueId) {
            this.queueId = queueId;
            this.queueIdSet = true;
            return this;
        }

        @Override
        public U64 getTxBytes() {
            return this.txBytes;
        }

        @Override
        public OFQueueStatsEntry.Builder setTxBytes(U64 txBytes) {
            this.txBytes = txBytes;
            this.txBytesSet = true;
            return this;
        }

        @Override
        public U64 getTxPackets() {
            return this.txPackets;
        }

        @Override
        public OFQueueStatsEntry.Builder setTxPackets(U64 txPackets) {
            this.txPackets = txPackets;
            this.txPacketsSet = true;
            return this;
        }

        @Override
        public U64 getTxErrors() {
            return this.txErrors;
        }

        @Override
        public OFQueueStatsEntry.Builder setTxErrors(U64 txErrors) {
            this.txErrors = txErrors;
            this.txErrorsSet = true;
            return this;
        }

        @Override
        public long getDurationSec() {
            return this.durationSec;
        }

        @Override
        public OFQueueStatsEntry.Builder setDurationSec(long durationSec) {
            this.durationSec = durationSec;
            this.durationSecSet = true;
            return this;
        }

        @Override
        public long getDurationNsec() {
            return this.durationNsec;
        }

        @Override
        public OFQueueStatsEntry.Builder setDurationNsec(long durationNsec) {
            this.durationNsec = durationNsec;
            this.durationNsecSet = true;
            return this;
        }

        @Override
        public List<OFQueueStatsProp> getProperties() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property properties not supported in version 1.3");
        }

        @Override
        public OFQueueStatsEntry.Builder setProperties(List<OFQueueStatsProp> properties) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property properties not supported in version 1.3");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_13;
        }

        @Override
        public OFQueueStatsEntry build() {
            U64 txErrors;
            U64 txPackets;
            U64 txBytes;
            OFPort portNo;
            OFPort oFPort = portNo = this.portNoSet ? this.portNo : this.parentMessage.portNo;
            if (portNo == null) {
                throw new NullPointerException("Property portNo must not be null");
            }
            long queueId = this.queueIdSet ? this.queueId : this.parentMessage.queueId;
            U64 u64 = txBytes = this.txBytesSet ? this.txBytes : this.parentMessage.txBytes;
            if (txBytes == null) {
                throw new NullPointerException("Property txBytes must not be null");
            }
            U64 u642 = txPackets = this.txPacketsSet ? this.txPackets : this.parentMessage.txPackets;
            if (txPackets == null) {
                throw new NullPointerException("Property txPackets must not be null");
            }
            U64 u643 = txErrors = this.txErrorsSet ? this.txErrors : this.parentMessage.txErrors;
            if (txErrors == null) {
                throw new NullPointerException("Property txErrors must not be null");
            }
            long durationSec = this.durationSecSet ? this.durationSec : this.parentMessage.durationSec;
            long durationNsec = this.durationNsecSet ? this.durationNsec : this.parentMessage.durationNsec;
            return new OFQueueStatsEntryVer13(portNo, queueId, txBytes, txPackets, txErrors, durationSec, durationNsec);
        }
    }
}

