/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver13;

import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFStatsRequest;
import org.projectfloodlight.openflow.protocol.ver13.OFAggregateStatsRequestVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFDescStatsRequestVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFExperimenterStatsRequestVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFFlowStatsRequestVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFGroupDescStatsRequestVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFGroupFeaturesStatsRequestVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFGroupStatsRequestVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFMeterConfigStatsRequestVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFMeterFeaturesStatsRequestVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFMeterStatsRequestVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFPortDescStatsRequestVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFPortStatsRequestVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFQueueStatsRequestVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFTableFeaturesStatsRequestVer13;
import org.projectfloodlight.openflow.protocol.ver13.OFTableStatsRequestVer13;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U32;

abstract class OFStatsRequestVer13 {
    static final byte WIRE_VERSION = 4;
    static final int MINIMUM_LENGTH = 16;
    public static final Reader READER = new Reader();

    OFStatsRequestVer13() {
    }

    static class Reader
    implements OFMessageReader<OFStatsRequest<?>> {
        Reader() {
        }

        @Override
        public OFStatsRequest<?> readFrom(ChannelBuffer bb) throws OFParseError {
            if (bb.readableBytes() < 16) {
                return null;
            }
            int start = bb.readerIndex();
            byte version = bb.readByte();
            if (version != 4) {
                throw new OFParseError("Wrong version: Expected=OFVersion.OF_13(4), got=" + version);
            }
            byte type = bb.readByte();
            if (type != 18) {
                throw new OFParseError("Wrong type: Expected=OFType.STATS_REQUEST(18), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 16) {
                throw new OFParseError("Wrong length: Expected to be >= 16, was: " + length);
            }
            U32.f(bb.readInt());
            short statsType = bb.readShort();
            bb.readerIndex(start);
            switch (statsType) {
                case 2: {
                    return OFAggregateStatsRequestVer13.READER.readFrom(bb);
                }
                case -1: {
                    return OFExperimenterStatsRequestVer13.READER.readFrom(bb);
                }
                case 0: {
                    return OFDescStatsRequestVer13.READER.readFrom(bb);
                }
                case 1: {
                    return OFFlowStatsRequestVer13.READER.readFrom(bb);
                }
                case 4: {
                    return OFPortStatsRequestVer13.READER.readFrom(bb);
                }
                case 5: {
                    return OFQueueStatsRequestVer13.READER.readFrom(bb);
                }
                case 3: {
                    return OFTableStatsRequestVer13.READER.readFrom(bb);
                }
                case 7: {
                    return OFGroupDescStatsRequestVer13.READER.readFrom(bb);
                }
                case 6: {
                    return OFGroupStatsRequestVer13.READER.readFrom(bb);
                }
                case 8: {
                    return OFGroupFeaturesStatsRequestVer13.READER.readFrom(bb);
                }
                case 10: {
                    return OFMeterConfigStatsRequestVer13.READER.readFrom(bb);
                }
                case 11: {
                    return OFMeterFeaturesStatsRequestVer13.READER.readFrom(bb);
                }
                case 9: {
                    return OFMeterStatsRequestVer13.READER.readFrom(bb);
                }
                case 13: {
                    return OFPortDescStatsRequestVer13.READER.readFrom(bb);
                }
                case 12: {
                    return OFTableFeaturesStatsRequestVer13.READER.readFrom(bb);
                }
            }
            throw new OFParseError("Unknown value for discriminator statsType of class OFStatsRequestVer13: " + statsType);
        }
    }
}

