/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.protocol.oxm.OFOxm;
import org.projectfloodlight.openflow.protocol.oxm.OFOxmArpSpa;
import org.projectfloodlight.openflow.types.IPv4Address;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFOxmArpSpaVer14
implements OFOxmArpSpa {
    private static final Logger logger = LoggerFactory.getLogger(OFOxmArpSpaVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 8;
    private static final IPv4Address DEFAULT_VALUE = IPv4Address.NONE;
    private final IPv4Address value;
    static final OFOxmArpSpaVer14 DEFAULT = new OFOxmArpSpaVer14(DEFAULT_VALUE);
    static final Reader READER = new Reader();
    static final OFOxmArpSpaVer14Funnel FUNNEL = new OFOxmArpSpaVer14Funnel();
    static final Writer WRITER = new Writer();

    OFOxmArpSpaVer14(IPv4Address value) {
        if (value == null) {
            throw new NullPointerException("OFOxmArpSpaVer14: property value cannot be null");
        }
        this.value = value;
    }

    @Override
    public long getTypeLen() {
        return 2147494916L;
    }

    @Override
    public IPv4Address getValue() {
        return this.value;
    }

    @Override
    public MatchField<IPv4Address> getMatchField() {
        return MatchField.ARP_SPA;
    }

    @Override
    public boolean isMasked() {
        return false;
    }

    @Override
    public OFOxm<IPv4Address> getCanonical() {
        return this;
    }

    @Override
    public IPv4Address getMask() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Property mask not supported in version 1.4");
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFOxmArpSpa.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFOxmArpSpaVer14(");
        b.append("value=").append(this.value);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFOxmArpSpaVer14 other = (OFOxmArpSpaVer14)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFOxmArpSpaVer14> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFOxmArpSpaVer14 message) {
            bb.writeInt(-2147472380);
            message.value.write4Bytes(bb);
        }
    }

    static class OFOxmArpSpaVer14Funnel
    implements Funnel<OFOxmArpSpaVer14> {
        private static final long serialVersionUID = 1L;

        OFOxmArpSpaVer14Funnel() {
        }

        public void funnel(OFOxmArpSpaVer14 message, PrimitiveSink sink) {
            sink.putInt(-2147472380);
            message.value.putTo(sink);
        }
    }

    static class Reader
    implements OFMessageReader<OFOxmArpSpa> {
        Reader() {
        }

        @Override
        public OFOxmArpSpa readFrom(ChannelBuffer bb) throws OFParseError {
            int typeLen = bb.readInt();
            if (typeLen != -2147472380) {
                throw new OFParseError("Wrong typeLen: Expected=0x80002c04L(0x80002c04L), got=" + typeLen);
            }
            IPv4Address value = IPv4Address.read4Bytes(bb);
            OFOxmArpSpaVer14 oxmArpSpaVer14 = new OFOxmArpSpaVer14(value);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)oxmArpSpaVer14);
            }
            return oxmArpSpaVer14;
        }
    }

    static class Builder
    implements OFOxmArpSpa.Builder {
        private boolean valueSet;
        private IPv4Address value;

        Builder() {
        }

        @Override
        public long getTypeLen() {
            return 2147494916L;
        }

        @Override
        public IPv4Address getValue() {
            return this.value;
        }

        @Override
        public OFOxmArpSpa.Builder setValue(IPv4Address value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<IPv4Address> getMatchField() {
            return MatchField.ARP_SPA;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<IPv4Address> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public IPv4Address getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmArpSpa build() {
            IPv4Address value;
            IPv4Address iPv4Address = value = this.valueSet ? this.value : DEFAULT_VALUE;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmArpSpaVer14(value);
        }
    }

    static class BuilderWithParent
    implements OFOxmArpSpa.Builder {
        final OFOxmArpSpaVer14 parentMessage;
        private boolean valueSet;
        private IPv4Address value;

        BuilderWithParent(OFOxmArpSpaVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public long getTypeLen() {
            return 2147494916L;
        }

        @Override
        public IPv4Address getValue() {
            return this.value;
        }

        @Override
        public OFOxmArpSpa.Builder setValue(IPv4Address value) {
            this.value = value;
            this.valueSet = true;
            return this;
        }

        @Override
        public MatchField<IPv4Address> getMatchField() {
            return MatchField.ARP_SPA;
        }

        @Override
        public boolean isMasked() {
            return false;
        }

        @Override
        public OFOxm<IPv4Address> getCanonical() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property canonical not supported in version 1.4");
        }

        @Override
        public IPv4Address getMask() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Property mask not supported in version 1.4");
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFOxmArpSpa build() {
            IPv4Address value;
            IPv4Address iPv4Address = value = this.valueSet ? this.value : this.parentMessage.value;
            if (value == null) {
                throw new NullPointerException("Property value must not be null");
            }
            return new OFOxmArpSpaVer14(value);
        }
    }
}

