/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFPortDescPropBsn;
import org.projectfloodlight.openflow.protocol.ver14.OFPortDescPropBsnGenerationIdVer14;
import org.projectfloodlight.openflow.protocol.ver14.OFPortDescPropBsnUplinkVer14;
import org.projectfloodlight.openflow.types.U16;

abstract class OFPortDescPropBsnVer14 {
    static final byte WIRE_VERSION = 5;
    static final int MINIMUM_LENGTH = 12;
    public static final Reader READER = new Reader();

    OFPortDescPropBsnVer14() {
    }

    static class Reader
    implements OFMessageReader<OFPortDescPropBsn> {
        Reader() {
        }

        @Override
        public OFPortDescPropBsn readFrom(ChannelBuffer bb) throws OFParseError {
            if (bb.readableBytes() < 12) {
                return null;
            }
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != -1) {
                throw new OFParseError("Wrong type: Expected=0xffff(0xffff), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length < 12) {
                throw new OFParseError("Wrong length: Expected to be >= 12, was: " + length);
            }
            int experimenter = bb.readInt();
            if (experimenter != 6035143) {
                throw new OFParseError("Wrong experimenter: Expected=0x5c16c7L(0x5c16c7L), got=" + experimenter);
            }
            int expType = bb.readInt();
            bb.readerIndex(start);
            switch (expType) {
                case 1: {
                    return OFPortDescPropBsnGenerationIdVer14.READER.readFrom(bb);
                }
                case 0: {
                    return OFPortDescPropBsnUplinkVer14.READER.readFrom(bb);
                }
            }
            throw new OFParseError("Unknown value for discriminator expType of class OFPortDescPropBsnVer14: " + expType);
        }
    }
}

