/*
 * Decompiled with CFR 0.152.
 */
package org.projectfloodlight.openflow.protocol.ver14;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import org.jboss.netty.buffer.ChannelBuffer;
import org.projectfloodlight.openflow.exceptions.OFParseError;
import org.projectfloodlight.openflow.protocol.OFMessageReader;
import org.projectfloodlight.openflow.protocol.OFMessageWriter;
import org.projectfloodlight.openflow.protocol.OFTableModPropVacancy;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.types.U16;
import org.projectfloodlight.openflow.types.U8;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OFTableModPropVacancyVer14
implements OFTableModPropVacancy {
    private static final Logger logger = LoggerFactory.getLogger(OFTableModPropVacancyVer14.class);
    static final byte WIRE_VERSION = 5;
    static final int LENGTH = 8;
    private static final short DEFAULT_VACANCY_DOWN = 0;
    private static final short DEFAULT_VACANCY_UP = 0;
    private static final short DEFAULT_VACANCY = 0;
    private final short vacancyDown;
    private final short vacancyUp;
    private final short vacancy;
    static final OFTableModPropVacancyVer14 DEFAULT = new OFTableModPropVacancyVer14(0, 0, 0);
    static final Reader READER = new Reader();
    static final OFTableModPropVacancyVer14Funnel FUNNEL = new OFTableModPropVacancyVer14Funnel();
    static final Writer WRITER = new Writer();

    OFTableModPropVacancyVer14(short vacancyDown, short vacancyUp, short vacancy) {
        this.vacancyDown = vacancyDown;
        this.vacancyUp = vacancyUp;
        this.vacancy = vacancy;
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public short getVacancyDown() {
        return this.vacancyDown;
    }

    @Override
    public short getVacancyUp() {
        return this.vacancyUp;
    }

    @Override
    public short getVacancy() {
        return this.vacancy;
    }

    @Override
    public OFVersion getVersion() {
        return OFVersion.OF_14;
    }

    @Override
    public OFTableModPropVacancy.Builder createBuilder() {
        return new BuilderWithParent(this);
    }

    @Override
    public void putTo(PrimitiveSink sink) {
        FUNNEL.funnel(this, sink);
    }

    @Override
    public void writeTo(ChannelBuffer bb) {
        WRITER.write(bb, this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder("OFTableModPropVacancyVer14(");
        b.append("vacancyDown=").append(this.vacancyDown);
        b.append(", ");
        b.append("vacancyUp=").append(this.vacancyUp);
        b.append(", ");
        b.append("vacancy=").append(this.vacancy);
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OFTableModPropVacancyVer14 other = (OFTableModPropVacancyVer14)obj;
        if (this.vacancyDown != other.vacancyDown) {
            return false;
        }
        if (this.vacancyUp != other.vacancyUp) {
            return false;
        }
        return this.vacancy == other.vacancy;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.vacancyDown;
        result = 31 * result + this.vacancyUp;
        result = 31 * result + this.vacancy;
        return result;
    }

    static class Writer
    implements OFMessageWriter<OFTableModPropVacancyVer14> {
        Writer() {
        }

        @Override
        public void write(ChannelBuffer bb, OFTableModPropVacancyVer14 message) {
            bb.writeShort(3);
            bb.writeShort(8);
            bb.writeByte((int)U8.t(message.vacancyDown));
            bb.writeByte((int)U8.t(message.vacancyUp));
            bb.writeByte((int)U8.t(message.vacancy));
            bb.writeZero(1);
        }
    }

    static class OFTableModPropVacancyVer14Funnel
    implements Funnel<OFTableModPropVacancyVer14> {
        private static final long serialVersionUID = 1L;

        OFTableModPropVacancyVer14Funnel() {
        }

        public void funnel(OFTableModPropVacancyVer14 message, PrimitiveSink sink) {
            sink.putShort((short)3);
            sink.putShort((short)8);
            sink.putShort(message.vacancyDown);
            sink.putShort(message.vacancyUp);
            sink.putShort(message.vacancy);
        }
    }

    static class Reader
    implements OFMessageReader<OFTableModPropVacancy> {
        Reader() {
        }

        @Override
        public OFTableModPropVacancy readFrom(ChannelBuffer bb) throws OFParseError {
            int start = bb.readerIndex();
            short type = bb.readShort();
            if (type != 3) {
                throw new OFParseError("Wrong type: Expected=0x3(0x3), got=" + type);
            }
            int length = U16.f(bb.readShort());
            if (length != 8) {
                throw new OFParseError("Wrong length: Expected=8(8), got=" + length);
            }
            if (bb.readableBytes() + (bb.readerIndex() - start) < length) {
                bb.readerIndex(start);
                return null;
            }
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - length={}", (Object)length);
            }
            short vacancyDown = U8.f(bb.readByte());
            short vacancyUp = U8.f(bb.readByte());
            short vacancy = U8.f(bb.readByte());
            bb.skipBytes(1);
            OFTableModPropVacancyVer14 tableModPropVacancyVer14 = new OFTableModPropVacancyVer14(vacancyDown, vacancyUp, vacancy);
            if (logger.isTraceEnabled()) {
                logger.trace("readFrom - read={}", (Object)tableModPropVacancyVer14);
            }
            return tableModPropVacancyVer14;
        }
    }

    static class Builder
    implements OFTableModPropVacancy.Builder {
        private boolean vacancyDownSet;
        private short vacancyDown;
        private boolean vacancyUpSet;
        private short vacancyUp;
        private boolean vacancySet;
        private short vacancy;

        Builder() {
        }

        @Override
        public int getType() {
            return 3;
        }

        @Override
        public short getVacancyDown() {
            return this.vacancyDown;
        }

        @Override
        public OFTableModPropVacancy.Builder setVacancyDown(short vacancyDown) {
            this.vacancyDown = vacancyDown;
            this.vacancyDownSet = true;
            return this;
        }

        @Override
        public short getVacancyUp() {
            return this.vacancyUp;
        }

        @Override
        public OFTableModPropVacancy.Builder setVacancyUp(short vacancyUp) {
            this.vacancyUp = vacancyUp;
            this.vacancyUpSet = true;
            return this;
        }

        @Override
        public short getVacancy() {
            return this.vacancy;
        }

        @Override
        public OFTableModPropVacancy.Builder setVacancy(short vacancy) {
            this.vacancy = vacancy;
            this.vacancySet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFTableModPropVacancy build() {
            short vacancyDown = this.vacancyDownSet ? this.vacancyDown : (short)0;
            short vacancyUp = this.vacancyUpSet ? this.vacancyUp : (short)0;
            short vacancy = this.vacancySet ? this.vacancy : (short)0;
            return new OFTableModPropVacancyVer14(vacancyDown, vacancyUp, vacancy);
        }
    }

    static class BuilderWithParent
    implements OFTableModPropVacancy.Builder {
        final OFTableModPropVacancyVer14 parentMessage;
        private boolean vacancyDownSet;
        private short vacancyDown;
        private boolean vacancyUpSet;
        private short vacancyUp;
        private boolean vacancySet;
        private short vacancy;

        BuilderWithParent(OFTableModPropVacancyVer14 parentMessage) {
            this.parentMessage = parentMessage;
        }

        @Override
        public int getType() {
            return 3;
        }

        @Override
        public short getVacancyDown() {
            return this.vacancyDown;
        }

        @Override
        public OFTableModPropVacancy.Builder setVacancyDown(short vacancyDown) {
            this.vacancyDown = vacancyDown;
            this.vacancyDownSet = true;
            return this;
        }

        @Override
        public short getVacancyUp() {
            return this.vacancyUp;
        }

        @Override
        public OFTableModPropVacancy.Builder setVacancyUp(short vacancyUp) {
            this.vacancyUp = vacancyUp;
            this.vacancyUpSet = true;
            return this;
        }

        @Override
        public short getVacancy() {
            return this.vacancy;
        }

        @Override
        public OFTableModPropVacancy.Builder setVacancy(short vacancy) {
            this.vacancy = vacancy;
            this.vacancySet = true;
            return this;
        }

        @Override
        public OFVersion getVersion() {
            return OFVersion.OF_14;
        }

        @Override
        public OFTableModPropVacancy build() {
            short vacancyDown = this.vacancyDownSet ? this.vacancyDown : this.parentMessage.vacancyDown;
            short vacancyUp = this.vacancyUpSet ? this.vacancyUp : this.parentMessage.vacancyUp;
            short vacancy = this.vacancySet ? this.vacancy : this.parentMessage.vacancy;
            return new OFTableModPropVacancyVer14(vacancyDown, vacancyUp, vacancy);
        }
    }
}

